/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.dynamodb;

import com.dataiku.dip.datasets.dynamodb.DynamoDBConnectionWrapper;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBDatasetInputHandler;
import com.dataiku.dip.datasets.dynamodb.DynamoDBOutput;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import com.google.common.collect.Lists;
import java.util.List;

public class UnpartitionedDynamoDBDatasetInputHandler
extends DynamoDBDatasetInputHandler {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.dynamodb");

    public UnpartitionedDynamoDBDatasetInputHandler(DynamoDBDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
    }

    @Override
    public void createManaged() throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            DynamoDBOutput.DynamoDBOutputWriter.createTable(dynamoConn, this.datasetHandler.config.table);
        }
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public RowsInputSplit getPartitionSplit(Partition partition) throws Exception {
        return new DynamoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new DynamoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return new DynamoDBDatasetInputHandler.GlobalSplit();
    }

    @Override
    public long computePartitionRecords(Partition p) throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            String tableName = this.datasetHandler.config.table;
            logger.info((Object)("Scanning table " + tableName + " to count all items"));
            ScanRequest scanRequest = (ScanRequest)ScanRequest.builder().tableName(tableName).select("COUNT").build();
            long count = dynamoConn.client.scanPaginator(scanRequest).stream().mapToLong(ScanResponse::count).sum();
            logger.info((Object)("table=" + tableName + " count=" + count));
            long l = count;
            return l;
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new Exception("Unpartitioned dataset has no partitions");
    }

    @Override
    public void updateIndex() throws Exception {
        try (DynamoDBConnectionWrapper dynamoConn = this.datasetHandler.getNewConnection();){
            this.deleteAllGlobalSecondaryIndexes(dynamoConn, this.datasetHandler.config.table);
        }
    }
}

