/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.HighlightedMemTable;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.NDC;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InteractiveSearchService {
    @Autowired
    private TableColoringService coloringService;
    @Autowired
    private FutureService futureService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.elasticsearch");

    public ElasticSearchResultTableWithReport getTableWithReport(ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery, DSSAuthCtx user, Dataset ds, SerializedShakerScript sss, boolean addIndexInfo) throws Exception {
        ElasticSearchIndex.InteractiveSearchResults results;
        long totalHits = 0L;
        HighlightedMemTable mt = new HighlightedMemTable();
        ElasticSearchResultTableWithReport twr = new ElasticSearchResultTableWithReport();
        twr.table = mt;
        twr.facets = new ArrayList();
        twr.filters = null;
        ElasticSearchDatasetHandler elasticSearchDatasetHandler = new ElasticSearchDatasetHandler(user, ds);
        try {
            String customQueryDsl;
            JSONObject customQueryDslJson;
            ElasticSearchIndex elasticSearchIndex = elasticSearchDatasetHandler.getEsIndexForced();
            if (addIndexInfo) {
                Schema schema = ds.getSchema();
                schema.addColumn("__index", Type.STRING);
            }
            JSONObject jSONObject = customQueryDslJson = StringUtils.isBlank((String)(customQueryDsl = elasticSearchDatasetHandler.config.customQueryDsl)) ? null : new JSONObject(customQueryDsl);
            if (searchQuery != null && StringUtils.isNotBlank((String)searchQuery.queryString)) {
                try {
                    searchQuery = (ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery)VariablesUtils.expandObjectFields(ds.getProjectKey(), searchQuery, new String[]{"queryString"});
                }
                catch (IllegalArgumentException e) {
                    WarningsContext warningsContext = new WarningsContext();
                    warningsContext.addWarning(WarningsContext.WarningType.INPUT_ELASTICSEARCH_BAD_QUERY, e.getMessage(), logger);
                    twr.warnings = warningsContext.getOutput();
                    ElasticSearchResultTableWithReport elasticSearchResultTableWithReport = twr;
                    elasticSearchDatasetHandler.close();
                    return elasticSearchResultTableWithReport;
                }
            }
            assert (searchQuery != null);
            ElasticSearchIndex.ESQueryBuilder esQueryBuilder = new ElasticSearchIndex.ESQueryBuilder(searchQuery, customQueryDslJson);
            Params p = ConnectionUtils.getParamsFromProperties(elasticSearchIndex.connection);
            boolean trackTotalHits = p.getBoolParam("dku.connection.elasticsearch.interactiveSearch.exactTotalHits", true);
            results = elasticSearchIndex.getSearchDocumentsFrom(user, esQueryBuilder, trackTotalHits);
            MemTableAppendingOutput out = new MemTableAppendingOutput(mt);
            if (results.hits != null) {
                JSONArray hits = results.hits.getJSONArray("hits");
                totalHits = results.hits.getJSONObject("total").getLong("value");
                twr.hasMoreHits = "gte".equals(results.hits.getJSONObject("total").getString("relation"));
                ElasticSearchIndex.ElasticSearchResultsReader reader = new ElasticSearchIndex.ElasticSearchResultsReader(ElasticSearchIndex.PushMode.SCHEMA_COLUMNS, 0L, mt);
                reader.parseColumns(ds, elasticSearchIndex, elasticSearchIndex.rootIndex);
                reader.pushHits((ProcessorOutput)out, mt, hits, hits.length(), null, addIndexInfo);
            }
            out.lastRowEmitted();
        }
        finally {
            try {
                elasticSearchDatasetHandler.close();
            }
            catch (Throwable throwable) {
                Throwable elasticSearchIndex;
                elasticSearchIndex.addSuppressed(throwable);
            }
        }
        this.setSchemaFromDataset(ds, mt);
        if (searchQuery.from == 0) {
            twr.initialRows = (int)totalHits;
            for (MemColumn cd : mt.columnsList) {
                new TypeInferrer2.NbCharESSearchColumnHandler(mt, cd).call();
            }
        } else {
            twr.initialRows = twr.table.nrows();
        }
        twr.initialCols = twr.table.ncols();
        twr.warnings = results.warningsContext.getOutput();
        if (sss.coloring != null) {
            this.coloringService.prepareColoring(sss.coloring, twr.table);
        }
        return twr;
    }

    private void setSchemaFromDataset(Dataset ds, MemTable mt) {
        Schema schema = ds.getSchema();
        for (MemColumn cd : mt.columnsList) {
            cd.datasetSchemaColumn = schema.getColumn(cd.getName());
            this.inferMeaningFromSchema(cd);
        }
    }

    private void inferMeaningFromSchema(MemColumn cd) {
        cd.selectedType = new DataTypeMatch();
        Type type = cd.datasetSchemaColumn.getType();
        cd.selectedType.type = type == Type.DATE ? new Date() : (type == Type.DATEONLY ? new DateOnly() : (type == Type.DATETIMENOTZ ? new DatetimeNoTz() : (type == Type.BOOLEAN ? new Boolean() : (type.isFloatingPoint() ? new DoubleMeaning() : (type.isInteger() ? new LongMeaning() : (type == Type.GEOPOINT ? new GeoPoint() : (type == Type.GEOMETRY ? new GeometryMeaning() : new Text())))))));
        cd.datasetSchemaColumn.setMeaning(cd.selectedType.type.getClass().getSimpleName());
    }

    public FutureResponse startSearchFuture(DSSAuthCtx owner, Dataset ds, SerializedShakerScript sss, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery, boolean addIndexConnectionInfo) throws Exception {
        if (searchQuery.from == 0) {
            InitialChunkSearchESDatasetThread ft = new InitialChunkSearchESDatasetThread(owner, ds, sss, searchQuery, addIndexConnectionInfo);
            SpringUtils.getInstance().autowire((Object)ft);
            return this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){});
        }
        RefreshChunkSearchESDatasetThread ft = new RefreshChunkSearchESDatasetThread(owner, ds, sss, searchQuery, addIndexConnectionInfo);
        SpringUtils.getInstance().autowire((Object)ft);
        return this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedTableChunk>>(){});
    }

    public FutureResponse<PublicAPISearchESDatasetResult> startPublicAPISearchFuture(DSSAuthCtx owner, Dataset dataset, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery) throws Exception {
        PublicAPISearchESDatasetThread ft = new PublicAPISearchESDatasetThread(owner, dataset, searchQuery);
        SpringUtils.getInstance().autowire((Object)ft);
        return this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<PublicAPISearchESDatasetResult>>(){});
    }

    public static class ElasticSearchResultTableWithReport
    extends MemScriptRunner.TableWithReport {
        public boolean hasMoreHits;
    }

    private static class InitialChunkSearchESDatasetThread
    extends AbstractSearchESDatasetThread<SerializedMemTableV2> {
        ElasticSearchSerializedMemTable result = new ElasticSearchSerializedMemTable();

        public InitialChunkSearchESDatasetThread(DSSAuthCtx owner, Dataset ds, SerializedShakerScript sss, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery, boolean addIndexConnectionInfo) {
            super(owner, ds, sss, searchQuery, addIndexConnectionInfo);
        }

        @Override
        protected void fillResult(ElasticSearchResultTableWithReport twr) {
            this.result.fill(twr, this.sss, this.interactiveSearchQuery.size, twr.table.columnsList.size());
            this.result.overrideRowCount(twr.initialRows);
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        static class ElasticSearchSerializedMemTable
        extends SerializedMemTableV2 {
            public boolean hasMoreHits;

            ElasticSearchSerializedMemTable() {
            }

            public void fill(ElasticSearchResultTableWithReport table, SerializedShakerScript sss, int maxRows, int maxCols) {
                super.fill(table, sss, maxRows, maxCols);
                this.hasMoreHits = table.hasMoreHits;
            }
        }
    }

    private static class RefreshChunkSearchESDatasetThread
    extends AbstractSearchESDatasetThread<SerializedTableChunk> {
        SerializedTableChunk result;

        public RefreshChunkSearchESDatasetThread(DSSAuthCtx owner, Dataset ds, SerializedShakerScript sss, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery, boolean addIndexConnectionInfo) {
            super(owner, ds, sss, searchQuery, addIndexConnectionInfo);
        }

        @Override
        protected void fillResult(ElasticSearchResultTableWithReport twr) {
            this.result = new SerializedTableChunk(0, this.interactiveSearchQuery.size, 0, twr.initialCols, this.interactiveSearchQuery.from);
            this.result.fill(twr.table, twr.filters, this.sss.coloring, this.sss.columnsSelection);
            this.result.warnings = twr.warnings;
        }

        public SerializedTableChunk getResult() {
            return this.result;
        }
    }

    private static class PublicAPISearchESDatasetThread
    extends AbstractSearchESDatasetThread<PublicAPISearchESDatasetResult> {
        PublicAPISearchESDatasetResult result;

        public PublicAPISearchESDatasetThread(DSSAuthCtx owner, Dataset ds, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery) {
            super(owner, ds, new SerializedShakerScript(), searchQuery, false);
        }

        @Override
        protected void fillResult(ElasticSearchResultTableWithReport twr) {
            SerializedTableChunk chunk = new SerializedTableChunk(0, twr.table.nrows(), 0, twr.initialCols, this.interactiveSearchQuery.from);
            chunk.fill(twr.table, twr.filters, this.sss.coloring, this.sss.columnsSelection);
            this.result = new PublicAPISearchESDatasetResult();
            if (twr.warnings != null) {
                Map warnings = twr.warnings.getWarnings();
                if (warnings.containsKey(WarningsContext.WarningType.INPUT_ELASTICSEARCH_BAD_QUERY)) {
                    throw new IllegalArgumentException(((WarningsContext.StoredWarning)((WarningsContext.WarningTypeData)warnings.get((Object)WarningsContext.WarningType.INPUT_ELASTICSEARCH_BAD_QUERY)).stored.get((int)0)).message);
                }
                if (warnings.containsKey(WarningsContext.WarningType.INPUT_ELASTICSEARCH_RESULT_WINDOW_TOO_LARGE)) {
                    throw new IllegalArgumentException(((WarningsContext.StoredWarning)((WarningsContext.WarningTypeData)warnings.get((Object)WarningsContext.WarningType.INPUT_ELASTICSEARCH_RESULT_WINDOW_TOO_LARGE)).stored.get((int)0)).message);
                }
                for (WarningsContext.WarningTypeData warningTypeData : warnings.values()) {
                    for (WarningsContext.StoredWarning storedWarning : warningTypeData.stored) {
                        this.result.warnings.add(storedWarning.message);
                    }
                }
            }
            List columns = this.dataset.getSchema().columns;
            for (MemRow row : twr.table.rows) {
                ArrayList<String> inRow = new ArrayList<String>();
                for (SchemaColumn column : columns) {
                    inRow.add(row.get(column.getName()));
                }
                this.result.rows.add(inRow);
            }
            for (SchemaColumn column : columns) {
                PublicAPISearchESDatasetResult.ResultColumn col = new PublicAPISearchESDatasetResult.ResultColumn(column.getName(), column.getType().getName());
                this.result.columns.add(col);
            }
            if (this.interactiveSearchQuery.from == 0) {
                this.result.found = new PublicAPISearchESDatasetResult.FoundResults();
                this.result.found.total = twr.initialRows;
                this.result.found.hasMoreRows = twr.hasMoreHits;
            }
        }

        public PublicAPISearchESDatasetResult getResult() {
            return this.result;
        }
    }

    public static class PublicAPISearchESDatasetResult {
        List<ResultColumn> columns = new ArrayList<ResultColumn>();
        List<List<String>> rows = new ArrayList<List<String>>();
        List<String> warnings = new ArrayList<String>();
        FoundResults found;

        static class ResultColumn {
            public String name;
            public String type;

            public ResultColumn(String name, String type) {
                this.name = name;
                this.type = type;
            }
        }

        static class FoundResults {
            int total;
            boolean hasMoreRows;

            FoundResults() {
            }
        }
    }

    static abstract class AbstractSearchESDatasetThread<T>
    extends FutureThread<T> {
        final Dataset dataset;
        final ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery interactiveSearchQuery;
        final SerializedShakerScript sss;
        private final FuturePayload futurePayload;
        private final boolean addIndexInfo;

        public AbstractSearchESDatasetThread(DSSAuthCtx owner, Dataset ds, SerializedShakerScript sss, ElasticSearchIndex.ESQueryBuilder.PaginatedInteractiveSearchQuery searchQuery, boolean addIndexInfo) {
            super(owner);
            this.dataset = ds;
            this.sss = sss;
            this.interactiveSearchQuery = searchQuery;
            this.futurePayload = this.buildFuturePayload();
            this.addIndexInfo = addIndexInfo;
        }

        private FuturePayload buildFuturePayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "search_es_dataset";
            fp.targets.add(DSSFuturePayloadUtils.forDataset(this.dataset).withPart("es_search"));
            fp.displayName = "Searching ES dataset";
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        protected abstract void fillResult(ElasticSearchResultTableWithReport var1);

        public void execute() throws Exception {
            NDC.push((String)("search-dataset-table: " + this.dataset.getProjectKey() + "-" + this.dataset.getName()));
            try {
                InteractiveSearchService iss = (InteractiveSearchService)SpringUtils.getBean(InteractiveSearchService.class);
                ElasticSearchResultTableWithReport twr = iss.getTableWithReport(this.interactiveSearchQuery, this.owner, this.dataset, this.sss, this.addIndexInfo);
                this.fillResult(twr);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
            finally {
                NDC.pop();
            }
        }
    }
}

