/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.ProxyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.HttpClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobCopyInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobListDetails;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobContainersOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.ListBlobsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobInputStreamOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.sas.BlobContainerSasPermission;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobInputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobOutputStream;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.StorageSharedKeyCredential;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public class AzureBlobModel {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.azure");

    private AzureBlobModel() {
    }

    public static class BlobHolder {
        private final BlobClient block;

        public BlobHolder(String containerName, String blobName, ConnectionSettings connectionSettings) {
            this.block = connectionSettings.getBlobClient(containerName, blobName);
        }

        public String getUrl() {
            return this.block.getBlobUrl();
        }

        public BlobOutputStream getOutputStream() {
            return this.block.getBlockBlobClient().getBlobOutputStream();
        }

        public void upload(InputStream data) {
            this.block.upload(data, true);
        }

        public SyncPoller<BlobCopyInfo, Void> startCopy(String url) {
            return this.block.beginCopy(url, null);
        }

        public int delete() {
            Response bool = this.block.deleteIfExistsWithResponse(null, null, null, Context.NONE);
            return bool.getStatusCode();
        }

        public String getName() {
            return this.block.getBlobName();
        }

        public BlobProperties getProperties() {
            return this.block.getProperties();
        }

        public BlobInputStream openInputStream() {
            BlobInputStreamOptions options = new BlobInputStreamOptions();
            return this.block.openInputStream(options);
        }
    }

    public static class BlobContainerHolder {
        private final BlobContainerClient container;
        private final ConnectionSettings connectionSettings;
        private final String containerName;

        public BlobContainerHolder(String containerName, ConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            this.containerName = containerName;
            this.container = connectionSettings.getBlobContainerClient(containerName);
        }

        public String generateSAS(UserDelegationKey delegationKey) {
            BlobServiceSasSignatureValues values = new BlobServiceSasSignatureValues();
            BlobContainerSasPermission sasPermission = new BlobContainerSasPermission().setReadPermission(true).setWritePermission(true).setCreatePermission(true).setListPermission(true).setAddPermission(true).setMovePermission(true).setDeletePermission(true);
            values.setStartTime(delegationKey.getSignedStart()).setExpiryTime(delegationKey.getSignedExpiry()).setPermissions(sasPermission);
            return this.container.generateUserDelegationSas(values, delegationKey);
        }

        public boolean exists() {
            return this.container.exists();
        }

        public void create() {
            this.container.createIfNotExists();
        }

        public PagedIterable<BlobItem> listBlobs(String prefix, BlobListDetails listingDetails) {
            ListBlobsOptions options = new ListBlobsOptions();
            options.setPrefix(prefix);
            options.setDetails(listingDetails);
            return this.container.listBlobs(options, null);
        }

        public PagedIterable<BlobItem> listBlobsByHierarchy(String prefix) {
            return this.listBlobsByHierarchy(prefix, new BlobListDetails());
        }

        public PagedIterable<BlobItem> listBlobsByHierarchy(String prefix, BlobListDetails listingDetails) {
            ListBlobsOptions options = new ListBlobsOptions();
            options.setPrefix(prefix);
            options.setDetails(listingDetails);
            return this.container.listBlobsByHierarchy("/", options, null);
        }

        public BlobHolder getBlockBlobReference(String blob) {
            return new BlobHolder(this.containerName, blob, this.connectionSettings);
        }

        public BlobHolder getBlockBlobReference(BlobItem item) {
            return this.getBlockBlobReference(item.getName());
        }

        public String getRelativeBlobItemName(BlobItem item, String root) {
            BlobHolder blob = this.getBlockBlobReference(item);
            Object itemPath = blob.getName();
            if (!((String)itemPath).startsWith("/")) {
                itemPath = "/" + (String)itemPath;
            }
            return ((String)itemPath).length() <= root.length() ? "/" : PathUtils.makeLeadingNoTrailing((String)((String)itemPath).substring(root.length()));
        }

        public String getName() {
            return this.container.getBlobContainerName();
        }

        public void deleteBlob(BlobItem item) {
            String name = item.isPrefix() != false ? PathUtils.makeLeadingNoTrailing((String)item.getName()) : item.getName();
            BlobHolder hdl = this.getBlockBlobReference(name);
            if (hdl != null) {
                int status = hdl.delete();
                logger.debugV("Deleting blob %s with status=%d", new Object[]{name, status});
            }
        }

        public void deleteBlobsRecursive(BlobItem item) {
            PagedIterable<BlobItem> itemsList = this.listBlobsByHierarchy(item.getName(), new BlobListDetails());
            logger.infoV("Deleting blob %s", new Object[]{item.getName()});
            for (BlobItem sub : itemsList) {
                if (sub.isPrefix().booleanValue()) {
                    this.deleteBlobsRecursive(sub);
                    continue;
                }
                this.deleteBlob(sub);
            }
            this.deleteBlob(item);
        }
    }

    public static class BlobServiceAccountHolder {
        private final BlobServiceClient client;
        private final ConnectionSettings connectionSettings;

        public BlobServiceAccountHolder(ConnectionSettings connectionSettings) {
            this.client = connectionSettings.getBlobServiceClient();
            this.connectionSettings = connectionSettings;
        }

        public BlobContainerHolder getContainerReference(String containerName) {
            return new BlobContainerHolder(containerName, this.connectionSettings);
        }

        public PagedIterable<BlobContainerItem> listContainers() {
            ListBlobContainersOptions options = new ListBlobContainersOptions();
            return this.client.listBlobContainers(options, null);
        }

        public UserDelegationKey generateDelegationKey(long expiresOn) {
            return this.client.getUserDelegationKey(OffsetDateTime.now(), OffsetDateTime.ofInstant(Instant.ofEpochMilli(expiresOn), ZoneOffset.UTC));
        }
    }

    public static class ConnectionSettings {
        private final String url;
        private final ProxyOptions proxy;
        private final TokenCredential token;
        private final StorageSharedKeyCredential sharedKey;
        private final AzureSasCredential sasToken;

        public ConnectionSettings(String url, ProxySettings proxy, StorageSharedKeyCredential sharedKey) {
            this.url = url;
            this.sharedKey = sharedKey;
            this.token = null;
            this.sasToken = null;
            this.proxy = ConnectionSettings.createProxyOptions(proxy);
        }

        public ConnectionSettings(String url, ProxySettings proxy, TokenCredential token) {
            this.url = url;
            this.sharedKey = null;
            this.sasToken = null;
            this.token = token;
            this.proxy = ConnectionSettings.createProxyOptions(proxy);
        }

        public ConnectionSettings(String url, ProxySettings proxy, AzureSasCredential sasKey) {
            this.url = url;
            this.sharedKey = null;
            this.token = null;
            this.sasToken = sasKey;
            this.proxy = ConnectionSettings.createProxyOptions(proxy);
        }

        private static ProxyOptions createProxyOptions(ProxySettings proxy) {
            if (proxy.hasProxy()) {
                ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.Type.HTTP, new InetSocketAddress(proxy.host, proxy.port));
                if (proxy.hasAuthentication()) {
                    proxyOptions.setCredentials(proxy.username, proxy.password);
                }
                return proxyOptions;
            }
            return null;
        }

        public BlobServiceClient getBlobServiceClient() {
            BlobServiceClientBuilder builder = new BlobServiceClientBuilder();
            builder.endpoint(this.url);
            if (this.proxy != null) {
                builder.clientOptions((ClientOptions)new HttpClientOptions().setProxyOptions(this.proxy));
            }
            if (this.sharedKey != null) {
                builder.credential(this.sharedKey);
            } else if (this.sasToken != null) {
                builder.credential(this.sasToken);
            } else {
                builder.credential(this.token);
            }
            return builder.buildClient();
        }

        public BlobContainerClient getBlobContainerClient(String containerName) {
            BlobContainerClientBuilder builder = new BlobContainerClientBuilder();
            builder.endpoint(this.url);
            builder.containerName(containerName);
            if (this.proxy != null) {
                builder.clientOptions((ClientOptions)new HttpClientOptions().setProxyOptions(this.proxy));
            }
            if (this.sharedKey != null) {
                builder.credential(this.sharedKey);
            } else if (this.sasToken != null) {
                builder.credential(this.sasToken);
            } else {
                builder.credential(this.token);
            }
            return builder.buildClient();
        }

        public BlobClient getBlobClient(String containerName, String blobName) {
            BlobClientBuilder builder = new BlobClientBuilder();
            builder.endpoint(this.url);
            builder.containerName(containerName);
            builder.blobName(blobName);
            if (this.proxy != null) {
                builder.clientOptions((ClientOptions)new HttpClientOptions().setProxyOptions(this.proxy));
            }
            if (this.sharedKey != null) {
                builder.credential(this.sharedKey);
            } else if (this.sasToken != null) {
                builder.credential(this.sasToken);
            } else {
                builder.credential(this.token);
            }
            return builder.buildClient();
        }
    }
}

