/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.datasets.fs.BlobLikeFSProvider;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUTracedAction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobCopyInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobListDetails;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobOutputStream;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AzureBlobStorageFSProvider
implements BlobLikeFSProvider,
PathToURIConverter {
    private final AzureConnection connection;
    private final String root;
    private final String container;
    private final ProxySettings proxySettings;
    private final AuthCtx authCtx;
    private AzureBlobModel.BlobContainerHolder cloudBlobContainer;
    private final Boolean useCachedAccessToken;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private final int enumerationProgressInterval = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationProgressInterval", Integer.valueOf(10000));
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.azure");
    private static final DKULogger actionsLogger = DKULogger.getLogger((String)"dku.fs.azure.actions");

    public AzureBlobStorageFSProvider(AuthCtx authCtx, DSSConnection connection, String root, String container, ProxySettings proxySettings, boolean useCachedAccessToken) throws IOException, DKUSecurityException {
        this.authCtx = authCtx;
        this.container = container;
        this.proxySettings = proxySettings;
        assert (connection instanceof AzureConnection);
        this.connection = (AzureConnection)connection;
        this.useCachedAccessToken = useCachedAccessToken;
        if (StringUtils.isBlank((String)container)) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_CONFIG, "Container to read is not defined");
        }
        if ((root = StringUtils.trimToEmpty((String)root)).equals("..") || root.contains("../") || root.contains("/..")) {
            logger.error((Object)("Forbidden '..' segment in Azure filesystem path, root='" + root + "'"));
            throw new DKUSecurityException("Forbidden '..' segment in Azure filesystem path").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        this.root = PathUtils.makeLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.connection.params.chroot, root, false)));
        logger.info((Object)("Created Azure FS Provider container=" + this.container + " path=" + this.root));
    }

    public AzureBlobStorageFSProvider(AuthCtx authCtx, DSSConnection connection, String root, String container, ProxySettings proxySettings) throws IOException, DKUSecurityException {
        this(authCtx, connection, root, container, proxySettings, true);
    }

    static IOException tryCode(String message, Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        Object statusCode = "";
        if (e instanceof BlobStorageException) {
            statusCode = " (errorCode=" + String.valueOf(((BlobStorageException)e).getErrorCode()) + ")";
        }
        if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"the specified container does not exist")) {
            return new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_BUCKET_DOES_NOT_EXIST, message + (String)statusCode, null);
        }
        if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"not authorized to perform this operation using this permission")) {
            return new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_AZURE_PERMISSION, "You must verify the permissions of the container/folder." + (String)statusCode, null);
        }
        if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"signature did not match")) {
            return new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_AZURE_CONNECTION, "You must verify the credentials of your connection." + (String)statusCode, null);
        }
        return new IOException(StringUtils.defaultIfBlank((String)message, (String)("Data access error" + (String)statusCode)), e);
    }

    private AzureBlobModel.BlobContainerHolder getContainerInstance() throws IOException {
        try {
            AzureBlobModel.BlobServiceAccountHolder client = this.connection.getAzureBlobClient(this.authCtx, this.useCachedAccessToken);
            return client.getContainerReference(this.container);
        }
        catch (Exception exc) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to get container instance", exc);
        }
    }

    private synchronized AzureBlobModel.BlobContainerHolder getContainer() throws IOException, DKUSecurityException {
        if (this.cloudBlobContainer == null) {
            this.cloudBlobContainer = this.getContainerInstance();
        }
        return this.cloudBlobContainer;
    }

    private String getPathInsideRoot(String path) {
        return PathUtils.concatLNT((String[])new String[]{this.root, path});
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        HashMap ret = Maps.newHashMap();
        ret.put("container", this.container);
        ret.put("root", this.root);
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
            ret.put("accessKey", creds.key);
            ret.put("storageAccount", this.connection.params.storageAccount);
            if (this.connection.useGlobalProxy) {
                ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (Map)ret);
            }
        }
        return ret;
    }

    @Override
    public boolean fileExists(String path) throws IOException, DKUSecurityException {
        return this.stat(path) != null;
    }

    @Override
    public void waitUntilReadable(String path) throws IOException {
    }

    @Override
    public String getRootWithinBucket() throws IOException, DKUSecurityException {
        AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
        AzureBlobModel.BlobHolder rootDir = blobContainer.getBlockBlobReference(PathUtils.makeNotLeadingNoTrailing((String)this.root));
        String pathWithContainer = rootDir.getName();
        if (pathWithContainer.startsWith("/" + this.container)) {
            return pathWithContainer.substring(("/" + this.container).length());
        }
        logger.warn((Object)("getRootWithinBucket: pathWithContainer=" + pathWithContainer + " does not start by /" + this.container));
        return pathWithContainer;
    }

    public String convertPathToURI(String path) {
        String scheme = this.connection.getHDFSScheme();
        String location = this.connection.getHDFSLocation();
        return scheme + "://" + this.container + "@" + this.connection.params.storageAccount + "." + location + PathUtils.slashes((String)(this.root + "/" + path), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
    }

    public void close() {
    }

    private BlobItem getFolderMarkerForDeletion(String prefix, AzureBlobModel.BlobContainerHolder blobContainer) throws DKUSecurityException, IOException {
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root + '" + path + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        try {
            String lookup = PathUtils.makeNotLeadingNoTrailing((String)path);
            BlobListDetails details = new BlobListDetails();
            details.setRetrieveMetadata(true);
            for (BlobItem item : blobContainer.listBlobsByHierarchy(lookup, details)) {
                if (!this.isFolderMarker(item)) continue;
                return item;
            }
            return null;
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Fail to getFolderMarkerForDeletion", e);
        }
    }

    private BlobItem getObject(String prefix, AzureBlobModel.BlobContainerHolder blobContainer, FSProvider.FSBrowseStrategy strategy) throws DKUSecurityException, IOException {
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root + '" + path + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        try {
            BlobItem found = null;
            String lookup = PathUtils.makeNotLeadingNoTrailing((String)path);
            if (logger.isTraceEnabled()) {
                logger.traceV("getObject prefix=%s, lookup=%s", new Object[]{prefix, lookup});
            }
            BlobListDetails details = new BlobListDetails();
            details.setRetrieveMetadata(true);
            for (BlobItem item : blobContainer.listBlobsByHierarchy(lookup, details)) {
                boolean isFolder;
                if (logger.isTraceEnabled()) {
                    logger.traceV("Browse found itemType=%s uri=%s", new Object[]{item.getClass(), item.getName()});
                }
                if (this.isFolderMarker(item) || (isFolder = item.isPrefix().booleanValue()) && strategy == FSProvider.FSBrowseStrategy.FILE || !isFolder && strategy == FSProvider.FSBrowseStrategy.DIRECTORY || found != null && strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY && isFolder) continue;
                String itemPath = item.getName();
                if (!(itemPath = PathUtils.makeLeadingNoTrailing((String)itemPath)).equals(path)) continue;
                found = item;
            }
            return found;
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode(String.format("Fail to getObject %s", blobContainer.getName()), e);
        }
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure outside of root + '" + path + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        try {
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            FSBrowsePath ret = FSBrowsePath.makeRoot((String)prefix, (boolean)false);
            BlobItem found = null;
            String cleanPath = PathUtils.makeNotLeadingNoTrailing((String)path);
            if (StringUtils.isNotBlank((String)cleanPath)) {
                logger.debugV("Browse blobs on container=%s prefix=%s path=%s strategy=%s", new Object[]{blobContainer.getName(), prefix, cleanPath, strategy.name()});
                found = this.getObject(prefix, blobContainer, strategy);
            } else {
                this.doBrowseRoot(blobContainer, ret);
                if (!ret.children.isEmpty()) {
                    return ret;
                }
            }
            return this.doBrowseRegular(prefix, path, ret, found);
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to browse " + prefix, e);
        }
    }

    private long getLastModifiedTime(BlobItem file) {
        OffsetDateTime lastModified = file.getProperties().getLastModified();
        return lastModified == null ? new Date().getTime() : lastModified.toInstant().toEpochMilli();
    }

    private boolean isFolderMarker(BlobItem item) {
        return item.getMetadata() != null && (item.getMetadata().containsKey("hdi_isfolder") || item.getMetadata().containsKey("asv_isfolder"));
    }

    private void addChildren(FSBrowsePath ret, Iterable<BlobItem> items) throws CodedIOException {
        for (BlobItem item : items) {
            if (ret.children.size() + 1 > this.enumerationLimit) {
                throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this Azure Blob location (> %d). Enumeration aborted.", this.enumerationLimit));
            }
            String path = item.getName();
            if (item.isPrefix().booleanValue()) {
                if (path.endsWith("//")) continue;
                ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)FilenameUtils.getName((String)PathUtils.makeLeadingNoTrailing((String)path)), (boolean)true, (long)0L, (long)-1L));
                continue;
            }
            if (this.isFolderMarker(item)) continue;
            ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)FilenameUtils.getName((String)path), (boolean)false, (long)item.getProperties().getContentLength(), (long)this.getLastModifiedTime(item)));
        }
    }

    private void doBrowseRoot(AzureBlobModel.BlobContainerHolder blobContainer, FSBrowsePath ret) throws CodedIOException {
        ret.exists = true;
        ret.directory = true;
        BlobListDetails details = new BlobListDetails();
        details.setRetrieveMetadata(true);
        this.addChildren(ret, (Iterable<BlobItem>)blobContainer.listBlobsByHierarchy("", details));
    }

    private FSBrowsePath doBrowseRegular(String prefix, String path, FSBrowsePath ret, BlobItem found) throws IOException, DKUSecurityException {
        if (found == null) {
            ret.exists = false;
        } else {
            logger.debugV("doBrowseRegular prefix=%s path=%s found=%s", new Object[]{prefix, path, found});
            if (!found.isPrefix().booleanValue()) {
                ret.exists = true;
                ret.directory = false;
                ret.size = found.getProperties().getContentLength();
                ret.lastModified = this.getLastModifiedTime(found);
            } else {
                AzureBlobModel.BlobHolder dir = this.getContainer().getBlockBlobReference(found);
                ret.exists = true;
                ret.directory = true;
                logger.debugV("Listing in non-flat mode on dir %s", new Object[]{dir});
                BlobListDetails details = new BlobListDetails();
                details.setRetrieveMetadata(true);
                this.addChildren(ret, (Iterable<BlobItem>)this.getContainer().listBlobsByHierarchy(dir.getName(), details));
            }
        }
        return ret;
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings settings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, settings);
            if (paths == null) {
                return AzureBlobStorageFSEnumerationResult.fromNonExistingPrefix();
            }
            return AzureBlobStorageFSEnumerationResult.fromPaths(settings.filter(paths));
        }
        catch (Exception e) {
            logger.warn((Object)("Recursive enumeration from " + prefix + " failed"), (Throwable)e);
            return AzureBlobStorageFSEnumerationResult.fromError(e);
        }
    }

    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws InvalidKeyException, URISyntaxException, IOException, DKUSecurityException {
        AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
        try {
            return this.enumerateFilesystem(prefix, blobContainer, settings, false);
        }
        catch (Exception e) {
            if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"not authorized")) {
                logger.warn((Object)"enumerate failed to enumerate at the requested prefix (not authorized), considering as a directory and retrying with trailing slash");
                return this.enumerateFilesystem(prefix, blobContainer, settings, true);
            }
            throw AzureBlobStorageFSProvider.tryCode("Fail to enumerateFileSystem", e);
        }
    }

    private List<FSPath> enumerateFilesystem(String prefix, AzureBlobModel.BlobContainerHolder blobContainer, FSEnumerationSettings settings, boolean addTrailingSlash) throws IOException, DKUSecurityException {
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root + '" + path + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        logger.debugV("enumerateFS prefix=%s path=%s", new Object[]{prefix, path});
        ArrayList ret = Lists.newArrayList();
        String pathNLNT = PathUtils.makeNotLeadingNoTrailing((String)path);
        Object pathToEnumerate = pathNLNT;
        String pathToCheckAgainst = pathNLNT + "/";
        if (addTrailingSlash) {
            pathToEnumerate = (String)pathToEnumerate + "/";
        }
        long totalSize = 0L;
        logger.debugV("Listing blobs with path: %s", new Object[]{pathToEnumerate});
        try (TracedAzureAction taa = new TracedAzureAction("listBlobs.forEnumerateRecursive", pathToEnumerate);){
            int enumerated = 0;
            int kept = 0;
            BlobListDetails details = new BlobListDetails();
            details.setRetrieveMetadata(true);
            for (BlobItem item : blobContainer.listBlobs((String)pathToEnumerate, details)) {
                String itemPath;
                String filename;
                if (logger.isTraceEnabled()) {
                    logger.traceV("Browse found itemType=%s uri=%s", new Object[]{item.getClass(), item.getName()});
                }
                if (this.isFolderMarker(item)) continue;
                if (++enumerated % this.enumerationProgressInterval == 0) {
                    logger.infoV("Azure enumeration progress: enumerated=%d kept=%d", new Object[]{enumerated, kept});
                }
                long length = item.getProperties().getContentLength();
                String blobPath = item.getName();
                if (length <= 0L || !pathNLNT.isEmpty() && !blobPath.equals(pathNLNT) && !blobPath.startsWith(pathToCheckAgainst) || FSDatasetUtils.isBadFile(filename = (itemPath = blobContainer.getRelativeBlobItemName(item, this.root)).substring(itemPath.lastIndexOf(47) + 1), settings.showHiddenFiles) || FSDatasetUtils.isBadPath(itemPath) || !settings.selectionRules.includes(itemPath.substring(1))) continue;
                if (ret.size() + 1 > this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this Azure Blob location (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                ret.add(new FSPath(itemPath, length, this.getLastModifiedTime(item)));
                ++kept;
                if (!settings.shouldStopEnumeration((List)ret, totalSize += length)) continue;
                break;
            }
            logger.infoV("Azure enumeration completed: enumerated=%d kept=%d", new Object[]{enumerated, kept});
        }
        logger.debugV("Done Azure enumeration nb_files=%d total_size=%d", new Object[]{ret.size(), totalSize});
        if (ret.isEmpty()) {
            return null;
        }
        FSPath exactPathFile = null;
        for (FSPath p : ret) {
            if (!p.path().equals(prefix)) continue;
            exactPathFile = p;
        }
        if (exactPathFile != null) {
            return Lists.newArrayList((Object[])new FSPath[]{exactPathFile});
        }
        return ret;
    }

    public FSPathOrDirectory stat(String prefix) throws IOException, DKUSecurityException {
        logger.debug((Object)("AzureFSProvider: stat " + prefix));
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            BlobItem found = this.getObject(prefix, blobContainer, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
            if (found == null) {
                return null;
            }
            String itemPath = StringUtils.isEmpty((String)prefix) ? "/" : this.getContainer().getRelativeBlobItemName(found, this.root);
            if (found.isPrefix().booleanValue()) {
                return new FSPathOrDirectory(itemPath, 0L, 0L, true);
            }
            AzureBlobModel.BlobHolder blob = this.getContainer().getBlockBlobReference(found);
            return new FSPathOrDirectory(itemPath, blob.getProperties().getBlobSize(), this.getLastModifiedTime(found), false);
        }
        catch (DKUSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            if ((StringUtils.isBlank((String)prefix) || "/".equals(prefix)) && ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"not authorized")) {
                logger.warn((Object)"stat failed to get object for the root of the provider, (not authorized), considering as a directory");
                return new FSPathOrDirectory("/", 0L, 0L, true);
            }
            throw AzureBlobStorageFSProvider.tryCode("Failed to get information for location '" + prefix + "'", e);
        }
    }

    private boolean delete(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            return this.deleteMoved(prefix, this.getContainer(), strategy);
        }
        catch (DKUSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to delete " + prefix, e);
        }
    }

    public void deleteRecursive(String prefix) throws IOException, DKUSecurityException {
        logger.info((Object)("Delete recursive from " + prefix));
        this.delete(prefix, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }

    public boolean deleteFile(String path) throws IOException, DKUSecurityException {
        logger.info((Object)("Delete file " + path));
        return this.delete(path, FSProvider.FSBrowseStrategy.FILE);
    }

    public boolean deleteDirectory(String path) throws IOException, DKUSecurityException {
        logger.info((Object)("Delete file " + path));
        return this.delete(path, FSProvider.FSBrowseStrategy.DIRECTORY);
    }

    private void moveSecurityCheck(String from, String fromPath, String to, String toPath) throws DKUSecurityException, IOException {
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        if (!fromPath.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root: '" + fromPath + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        if (!toPath.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root: '" + toPath + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        if (toPath.endsWith("..")) {
            throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_INVALID_FILE_NAME, "New name finish with '..'");
        }
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        String fromPath = this.getPathInsideRoot(from);
        String toPath = this.getPathInsideRoot(to);
        this.moveSecurityCheck(from, fromPath, to, toPath);
        if (fromPath.equals(toPath)) {
            return;
        }
        FSDatasetUtils.checkDestDirectoryDoesNotExist(toPath, this.stat(to));
        try {
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            List<FSPath> pathsToMove = this.enumerateFilesystem(from, blobContainer, new FSEnumerationSettings(), true);
            if (pathsToMove != null) {
                this.movePaths(fromPath, toPath, blobContainer, pathsToMove);
                this.deleteMoved(from, blobContainer, FSProvider.FSBrowseStrategy.DIRECTORY);
            }
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to move " + from, e);
        }
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        String fromPath = this.getPathInsideRoot(from);
        String toPath = this.getPathInsideRoot(to);
        this.moveSecurityCheck(from, fromPath, to, toPath);
        if (fromPath.equals(toPath)) {
            return;
        }
        FSDatasetUtils.checkDestFileDoesNotExist(toPath, this.stat(to));
        try {
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            this.movePath(fromPath, toPath, blobContainer);
            BlobItem found = this.getObject(from, blobContainer, FSProvider.FSBrowseStrategy.FILE);
            this.getContainer().deleteBlob(found);
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to move " + from, e);
        }
    }

    private boolean deleteMoved(String from, AzureBlobModel.BlobContainerHolder blobContainer, FSProvider.FSBrowseStrategy strategy) throws DKUSecurityException, IOException {
        logger.infoV("deleteMoved from=%s", new Object[]{from});
        BlobItem found = this.getObject(from, blobContainer, strategy);
        if (found == null) {
            logger.warn((Object)("Nothing to delete at " + from));
            return false;
        }
        if (found.isPrefix().booleanValue()) {
            if (strategy == FSProvider.FSBrowseStrategy.FILE) {
                return false;
            }
            logger.debugV("Found dir: %s, enumerating it (flat)", new Object[]{found.getName()});
            blobContainer.deleteBlobsRecursive(found);
            BlobItem foundMarker = this.getFolderMarkerForDeletion(from, blobContainer);
            if (foundMarker != null) {
                logger.infoV("Removing folder marker (%s)", new Object[]{foundMarker.getName()});
                blobContainer.deleteBlob(foundMarker);
            }
            return true;
        }
        if (strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
            return false;
        }
        blobContainer.deleteBlob(found);
        return true;
    }

    private void movePaths(String fromPath, String toPath, AzureBlobModel.BlobContainerHolder blobContainer, List<FSPath> pathsToMove) throws URISyntaxException, IOException {
        for (FSPath pathToMove : pathsToMove) {
            String newPath = PathUtils.concatLNT((String[])new String[]{toPath, this.getPathInsideRoot(pathToMove.path()).substring(fromPath.length())});
            this.movePath(this.getPathInsideRoot(pathToMove.path()), newPath, blobContainer);
        }
    }

    private void movePath(String fromPath, String toPath, AzureBlobModel.BlobContainerHolder blobContainer) throws IOException {
        AzureBlobModel.BlobHolder fromBlob = blobContainer.getBlockBlobReference(PathUtils.makeNotLeadingNoTrailing((String)fromPath));
        AzureBlobModel.BlobHolder toBlob = blobContainer.getBlockBlobReference(PathUtils.makeNotLeadingNoTrailing((String)toPath));
        this.copy(fromBlob, toBlob);
    }

    private void copy(AzureBlobModel.BlobHolder sourceBlob, AzureBlobModel.BlobHolder targetBlob) throws IOException {
        SyncPoller<BlobCopyInfo, Void> poller = targetBlob.startCopy(sourceBlob.getUrl());
        PollResponse response = poller.waitForCompletion();
        if (response.getStatus() == LongRunningOperationStatus.FAILED) {
            throw new IOException("Failed to copy " + sourceBlob.getUrl() + " to " + targetBlob.getUrl());
        }
    }

    public EnrichedInputStream read(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        try {
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            BlobItem found = this.getObject(prefix, blobContainer, FSProvider.FSBrowseStrategy.FILE);
            if (found == null) {
                throw new IOException("Cannot read " + prefix + " because the blob doesn't exist");
            }
            return new AzureInputStream(found, prefix);
        }
        catch (DKUSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Cannot read " + prefix, e);
        }
    }

    public OutputStream write(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        String path = this.getPathInsideRoot(prefix);
        if (!path.startsWith(this.root)) {
            throw new DKUSecurityException("Cannot access Azure object outside of root: '" + path + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_FSLIKE_REACH_OUT_OF_ROOT);
        }
        try {
            AzureBlobModel.BlobContainerHolder blobContainer = this.getContainer();
            BlobItem blob = this.getObject(prefix, blobContainer, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
            if (blob != null) {
                if (blob.isPrefix().booleanValue()) {
                    throw new IOException("Cannot write to " + prefix + " because it's a directory");
                }
                this.getContainer().deleteBlob(blob);
            }
            AzureBlobModel.BlobHolder blockBlob = blobContainer.getBlockBlobReference(PathUtils.makeNotLeadingNoTrailing((String)path));
            return new SafeBlobOutputStream(blockBlob.getOutputStream());
        }
        catch (DKUSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw AzureBlobStorageFSProvider.tryCode("Failed to write " + prefix, e);
        }
    }

    public void setLastModified(String prefix, long lastModified) throws IOException, DKUSecurityException {
        throw new UnsupportedOperationException("Set last modified on Azure is not supported");
    }

    static class AzureBlobStorageFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public AzureBlobStorageFSEnumerationResult() {
        }

        public AzureBlobStorageFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public AzureBlobStorageFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static AzureBlobStorageFSEnumerationResult fromError(Throwable error) {
            return new AzureBlobStorageFSEnumerationResult(error);
        }

        private static AzureBlobStorageFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new AzureBlobStorageFSEnumerationResult(paths);
        }

        private static AzureBlobStorageFSEnumerationResult fromNonExistingPrefix() {
            return new AzureBlobStorageFSEnumerationResult();
        }
    }

    static class TracedAzureAction
    extends DKUTracedAction {
        TracedAzureAction(Object ... objects) {
            this.init(actionsLogger, "dku.fs.azure.actions", "Azure", objects);
        }
    }

    class AzureInputStream
    extends AutoEnrichedInputStream {
        private final BlobItem blob;

        public AzureInputStream(BlobItem blob, String path) {
            super(blob.getProperties().getContentLength().longValue(), path, PathUtils.getLastPathSegment((String)blob.getName()), path, () -> AzureBlobStorageFSProvider.this.getLastModifiedTime(blob));
            this.blob = blob;
        }

        protected InputStream getBasicInputStream() throws IOException {
            return this.getBasicHeadInputStream(this.size());
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return AzureBlobStorageFSProvider.this.cloudBlobContainer.getBlockBlobReference(this.blob.getName()).openInputStream();
        }
    }

    private static class SafeBlobOutputStream
    extends OutputStream {
        private final BufferedOutputStream wrapped;

        public SafeBlobOutputStream(BlobOutputStream os) {
            int bufSize = DKUApp.getParams().getIntParam("dku.fsproviders.azure.blob.write.bufSizeB", Integer.valueOf(0));
            if (bufSize > 0) {
                logger.infoV("Using %s as write buffer size for blob", new Object[]{bufSize});
                this.wrapped = new BufferedOutputStream((OutputStream)os, bufSize);
            } else {
                this.wrapped = new BufferedOutputStream((OutputStream)os);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.wrapped.write(b);
        }

        @Override
        public synchronized void close() throws IOException {
            try {
                this.wrapped.close();
            }
            catch (IOException e) {
                throw AzureBlobStorageFSProvider.tryCode(null, e);
            }
        }
    }
}

