/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class FSProviderTransferer {
    private final FSProvider from;
    private static final Logger logger = Logger.getLogger((String)"dip.fsprovider.transfer");

    public FSProviderTransferer(FSProvider from) {
        this.from = from;
    }

    public abstract long transfer(String var1, String var2) throws IOException, CodedException, DKUSecurityException;

    protected abstract OutputStream writeToStream(String var1) throws IOException, CodedException, DKUSecurityException;

    protected long writePaths(String fromPath, String toPath, List<FSPath> fromPaths) throws IOException {
        String fromPathLNT = PathUtils.makeLeadingNoTrailing((String)fromPath);
        long totalSize = 0L;
        for (FSPath path : fromPaths) {
            String pathInFrom = path.path().substring(fromPathLNT.length());
            if (StringUtils.isBlank((String)pathInFrom)) {
                if ("/".equals(fromPathLNT)) {
                    throw new IOException("Cannot transfer root path of source");
                }
                pathInFrom = (String)PathUtils.splitBasename((String)path.path()).second;
            }
            Object pathInTo = StringUtils.isBlank((String)toPath) || "/".equals(toPath) ? pathInFrom : toPath + "/" + pathInFrom;
            logger.info((Object)("Transfer '" + path.path() + "' to '" + (String)pathInTo + "'"));
            try (InputStream is = this.from.read(path.path()).rawStream();
                 OutputStream os = this.writeToStream((String)pathInTo);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Failed to copy " + path.path(), e);
            }
            catch (DKUSecurityException e) {
                throw new IOException("Failed to copy " + path.path(), e);
            }
            catch (CodedException e) {
                throw new RuntimeException(e);
            }
            totalSize += path.getSize();
        }
        return totalSize;
    }

    protected List<FSPath> enumeratePaths(String fromPath) throws IOException, CodedException, DKUSecurityException {
        ArrayList fromPaths;
        FSEnumerationResult fromFilesEnumeration = this.from.enumerateRecursive(fromPath, new FSEnumerationSettings());
        if (fromFilesEnumeration.getError() != null) {
            throw new IOException("Could not enumerate files to transfer", fromFilesEnumeration.getError());
        }
        if (!fromFilesEnumeration.enumerationPrefixExists()) {
            logger.warn((Object)"No file to transfer, target folder or file is empty");
            fromPaths = Lists.newArrayList();
        } else {
            if (!fromFilesEnumeration.isSuccessful()) {
                throw new IOException("Could not enumerate files to transfer, unknown error");
            }
            if (fromFilesEnumeration.getPaths() == null) {
                logger.warn((Object)"No file to transfer, no paths");
                fromPaths = Lists.newArrayList();
            } else {
                fromPaths = Lists.newArrayList((Iterable)fromFilesEnumeration.getPaths());
            }
        }
        logger.info((Object)("Got " + fromPaths.size() + " files to transfer"));
        return fromPaths;
    }
}

