/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamDatasetUtils;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.datasets.fs.SharePointOnlineDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SharePointOnlineDatasetTestHandler
extends FSLikeDatasetTestHandler {
    private final PasswordEncryptionService symetricCryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
    static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.fs");

    public SharePointOnlineDatasetTestHandler(AuthCtx authCtx, SharePointOnlineDatasetHandler sharePointOnlineDatasetHandler, DatasetHandler handlerForName, Dataset dataset) throws CodedException, IOException, DKUSecurityException {
        super(authCtx, sharePointOnlineDatasetHandler, handlerForName, dataset);
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) throws Exception {
        SharePointOnlineDatasetHandler handler = (SharePointOnlineDatasetHandler)this.handlerForData;
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try {
            if (handler.getProvider().stat(newDatasetName) != null) {
                ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_MANAGED_UNSAFE_NAME, "Object already exists under key '%s', they may get overwritten", new Object[]{newDatasetName});
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to check if the new dataset name is safe", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_GENERIC_ERROR, "Failed to check if the new dataset name is safe, there could be a problem with the database: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    @Override
    public InputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult result) throws Exception {
        BuiltinFSDatasets.SharePointOnlineDatasetConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.SharePointOnlineDatasetConfig.class);
        try {
            SharePointOnlineConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.handlerForData.authCtx, config.connection, SharePointOnlineConnection.class);
            connection.decryptFields(this.symetricCryptoService);
            try (FSTestProvider testProvider = FSProviderFactory.getTestProvider(this.handlerForData.authCtx, "SharePointOnline", config, connection);){
                result.connectionMetadata.putAll(testProvider.test(false));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"SharePoint Online connection test failed", (Throwable)e);
            result.connectionError = new SerializedError((Throwable)e, false);
            return null;
        }
        logger.info((Object)("Testing connection to :" + (StringUtils.isNotBlank((String)config.siteId) ? config.siteId : config.site) + " / " + (StringUtils.isNotBlank((String)config.driveId) ? config.driveId : config.drive)));
        if ((StringUtils.isNotBlank((String)config.siteId) || StringUtils.isNotBlank((String)config.site)) && (StringUtils.isNotBlank((String)config.driveId) || StringUtils.isNotBlank((String)config.drive))) {
            try {
                InputSplit sampleSplit = this.handlerForData.getSampleSplit();
                if (sampleSplit instanceof StreamsInputSplit) {
                    result.empty = StreamDatasetUtils.isStreamEmpty((StreamsInputSplit)sampleSplit);
                }
                result.connectionOK = true;
                return sampleSplit;
            }
            catch (Exception e) {
                logger.info((Object)"Connection test failed", (Throwable)e);
                result.connectionError = new SerializedError((Throwable)e, false);
                return null;
            }
        }
        result.connectionError = new SerializedError((Throwable)new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "SharePoint Online site / drive not specified"), false);
        return null;
    }
}

