/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.hdfs;

import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;

public class ACLUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.hdfs.permissions");

    public static AclEntry acl(AclEntryScope scope, AclEntryType type, String name, FsAction perm) {
        return new AclEntry.Builder().setScope(scope).setType(type).setName(name).setPermission(perm).build();
    }

    private static boolean strongerThan(AclEntry a, AclEntry b) {
        int rejectsInB;
        int rejectsInA = StringUtils.countMatches((String)a.getPermission().SYMBOL, (String)"-");
        return rejectsInA < (rejectsInB = StringUtils.countMatches((String)b.getPermission().SYMBOL, (String)"-"));
    }

    public static void dedupACLs(List<AclEntry> list) {
        logger.info((Object)("Deduping ACLs: " + StringUtils.join(list, (String)",")));
        HashMap<Object, AclEntry> map = new HashMap<Object, AclEntry>();
        for (AclEntry entry : list) {
            Object key = entry.getScope() == AclEntryScope.DEFAULT ? "default:" : "";
            key = (String)key + String.valueOf(entry.getType() != null ? entry.getType() : "");
            AclEntry prev = (AclEntry)map.get(key = (String)key + ":" + entry.getName());
            if (prev != null && ACLUtils.strongerThan(prev, entry)) {
                logger.info((Object)(" Removing " + String.valueOf(entry) + " because " + String.valueOf(prev) + " is stronger"));
                continue;
            }
            map.put(key, entry);
        }
        list.clear();
        list.addAll(map.values());
    }
}

