/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.cde.CDEProcessUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetMeta;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetParams;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetTestHandler;
import com.dataiku.dip.datasets.iceberg.IcebergFilterConverter;
import com.dataiku.dip.datasets.iceberg.IcebergOutput;
import com.dataiku.dip.datasets.iceberg.IcebergSchemaConverter;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dip.datasets.iceberg.IcebergValueConverter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.iceberg.DataFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.DeleteFiles;
import com.dataiku.dss.shadelib.org.apache.iceberg.FileScanTask;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionField;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Snapshot;
import com.dataiku.dss.shadelib.org.apache.iceberg.StructLike;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.TableScan;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SupportsNamespaces;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.IcebergGenerics;
import com.dataiku.dss.shadelib.org.apache.iceberg.data.Record;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expression;
import com.dataiku.dss.shadelib.org.apache.iceberg.expressions.Expressions;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterable;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.CloseableIterator;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Types;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergDatasetHandler
implements RowOrientedDatasetHandler {
    private static final Logger log = LoggerFactory.getLogger(IcebergDatasetHandler.class);
    protected final IcebergDatasetParams rawConfig;
    protected final IcebergDatasetParams config;
    protected final AuthCtx authCtx;
    protected final Dataset dataset;
    protected final IcebergConnection connection;
    protected Catalog icebergCatalog;
    protected IcebergUtils.ActionRunner icebergActionRunner;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.iceberg");

    public IcebergDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.rawConfig = dataset.getParamsAs(IcebergDatasetParams.class);
        this.config = this.rawConfig.getResolved(dataset.getProjectKey());
        try {
            this.connection = this.getConnection();
        }
        catch (Exception e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Failed to get Iceberg connection", (Throwable)e);
        }
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public IcebergConnection getConnection() {
        try {
            return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, this.config.connection, IcebergConnection.class);
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get connection", e);
        }
    }

    public IcebergDatasetParams getResolvedConfig() {
        return this.config;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        return new IcebergDatasetTestHandler(this.authCtx, this.dataset, this);
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public boolean isParallelWritable() {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() throws IOException {
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return IcebergDatasetMeta.INSTANCE;
    }

    @Override
    public void close() {
        if (this.icebergCatalog instanceof Closeable) {
            try {
                ((Closeable)this.icebergCatalog).close();
            }
            catch (IOException e) {
                logger.warn((Object)"Error while closing iceberg catalog", (Throwable)e);
            }
        }
        this.icebergCatalog = null;
    }

    public IcebergUtils.ActionRunner getIcebergActionRunner() throws IOException, DKUSecurityException {
        if (this.icebergActionRunner == null) {
            this.icebergActionRunner = new IcebergUtils().getUgi(this.connection, this.authCtx, this.dataset.getProjectKey());
        }
        return this.icebergActionRunner;
    }

    Catalog getOrCreateIcebergCatalog() throws IOException, DKUSecurityException {
        if (this.icebergCatalog == null) {
            this.icebergCatalog = this.connection.getIcebergCatalog(this.authCtx, this.dataset.getProjectKey());
        }
        return this.icebergCatalog;
    }

    Namespace resolveNamespace() {
        String namespace = StringUtils.defaultIfBlank((String)this.config.namespace, (String)this.connection.params.defaultNamespace);
        if (StringUtils.isBlank((String)namespace)) {
            return Namespace.empty();
        }
        return new IcebergUtils().toNamespace(namespace);
    }

    public TableIdentifier resolveTableIdentifier() {
        TableIdentifier tableId = TableIdentifier.of((Namespace)this.resolveNamespace(), (String)this.config.table);
        if (this.connection.params.icebergCatalogType == IcebergConnection.IcebergCatalogType.SNOWFLAKE) {
            return new IcebergUtils().makeSnowflakeCompatible(tableId);
        }
        return tableId;
    }

    public List<String> getResolvedTableChunks() {
        ArrayList<String> tableChunks = new ArrayList<String>();
        tableChunks.add(this.connection.makeSparkCatalogName());
        tableChunks.addAll(Arrays.asList(this.resolveNamespace().levels()));
        tableChunks.add(this.config.table);
        return tableChunks;
    }

    public SQLUtils.SQLTable getResolvedSQLTable() {
        if (StringUtils.isBlank((String)this.connection.params.associatedTrinoConnection)) {
            throw new IllegalArgumentException("No associated Trino connection defined on connection of dataset " + this.dataset.getFullName());
        }
        if (!this.connection.params.isAthena && StringUtils.isBlank((String)this.connection.params.associatedTrinoCatalog)) {
            throw new IllegalArgumentException("No Trino catalog defined on connection of dataset " + this.dataset.getFullName());
        }
        return new SQLUtils.SQLTable(this.connection.params.isAthena ? null : this.connection.params.associatedTrinoCatalog, StringUtils.defaultIfBlank((String)this.config.namespace, (String)this.connection.params.defaultNamespace), this.config.table);
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getExtraConf() throws IOException, DKUSecurityException {
        return this.connection.getSparkConfForCatalog(this.authCtx, this.dataset.getProjectKey());
    }

    Table loadTable() throws IOException, DKUSecurityException {
        Catalog catalog = this.getOrCreateIcebergCatalog();
        return catalog.loadTable(this.resolveTableIdentifier());
    }

    Table loadTableOrNull() throws IOException, DKUSecurityException {
        TableIdentifier tableId;
        Catalog catalog = this.getOrCreateIcebergCatalog();
        if (catalog.tableExists(tableId = this.resolveTableIdentifier())) {
            return catalog.loadTable(tableId);
        }
        return null;
    }

    Table loadTableCreateIfNeeded(Output.WriteMode writeMode, Partition partition) throws IOException, DKUSecurityException, InterruptedException {
        if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.CDE) {
            logger.info((Object)"Defer table creation to backend to avoid concurrency issues");
            try (TicketBasedIntercomAPIClient apiClient = CDEProcessUtils.newIntercomAPIClient();){
                apiClient.postFormToJSON("/tintercom/datasets/prepare-iceberg-table-for-write", InfoMessage.InfoMessages.class, new Object[]{"projectKey", this.dataset.getProjectKey(), "writeMode", writeMode, "partition", partition != null ? partition.id() : null, "datasetName", this.dataset.getName()});
            }
        } else {
            this.prepareTableForWrite(partition, writeMode);
        }
        return this.loadTable();
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException, CodedException, DKUSecurityException {
        if (StringUtils.isBlank((String)this.config.connection)) {
            throw ErrorContext.icef((String)"Missing connection for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)this.config.namespace)) {
            throw ErrorContext.icef((String)"Missing namespace for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)this.config.table)) {
            throw ErrorContext.icef((String)"Missing table for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
    }

    @Override
    public String suggestName() throws CodedException, DKUSecurityException {
        return this.config.table;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new IcebergSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        PrivilegedExceptionAction<InputSplit> action = () -> {
            PartitioningScheme scheme = this.dataset.getPartitioningSchema();
            Table table = this.loadTable();
            PartitionSpec partitionSpec = table.spec();
            this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
            Expression filter = new IcebergFilterConverter().toIcebergFilter(partition, table.schema());
            return new IcebergSplit(filter);
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        PrivilegedExceptionAction<FilterResultWithSplits> action = () -> {
            FilterResultWithSplits ret = new FilterResultWithSplits();
            if (filter.hasPartitionsFiltering() && !filter.getPartitionsClause().isEmpty() && !((Partition)filter.getPartitionsClause().get(0)).isNP() && !((Partition)filter.getPartitionsClause().get(0)).isAll()) {
                PartitioningScheme scheme = this.dataset.getPartitioningSchema();
                Table table = this.loadTable();
                PartitionSpec partitionSpec = table.spec();
                this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
                Expression partitionFilter = new IcebergFilterConverter().toIcebergFilter(filter.getPartitionsClause(), table.schema());
                ret.setNeedsRefilter(true);
                ret.withMatchingPartition(new Partition(null)).withSplit((InputSplit)new IcebergSplit(partitionFilter));
            } else {
                ret.setNeedsRefilter(true);
                ret.withMatchingPartition(new Partition(null)).withSplit((InputSplit)new IcebergSplit());
            }
            return ret;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    protected long executePush(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, Expression filter) throws Exception {
        PrivilegedExceptionAction<Long> action = () -> {
            long rowsBefore = listener == null ? 0L : listener.getReadRecords();
            long rowsPushed = 0L;
            Table table = this.loadTable();
            Schema icebergSchema = table.schema();
            IcebergValueConverter converter = new IcebergValueConverter();
            try (CloseableIterable records = IcebergGenerics.read((Table)table).where(filter).build();){
                for (Record record : records) {
                    if (listener != null && ++rowsPushed % 1000L == 0L) {
                        listener.setData(0L, 0L, rowsBefore + rowsPushed);
                    }
                    Row r = rf.row();
                    for (Types.NestedField column : icebergSchema.columns()) {
                        String value = converter.toDSSValue(record.getField(column.name()), column.type());
                        if (value == null) continue;
                        r.put(cf.column(column.name()), value);
                    }
                    out.emitRow(r);
                    if (limit == null || limit.maxRecords <= 0L || rowsPushed < limit.maxRecords) continue;
                    break;
                }
            }
            return rowsPushed;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    Map<String, Integer> checkIcebergPartitioningIsFinerThanDSSPartitioning(PartitionSpec partitionSpec, PartitioningScheme scheme) {
        if (scheme == null || !scheme.isPartitioned()) {
            throw new IllegalArgumentException("Dataset is not partitioned");
        }
        if (partitionSpec == null || !partitionSpec.isPartitioned()) {
            throw new IllegalArgumentException("Dataset is partitioned but not the Iceberg table");
        }
        List columns = scheme.getDimensionNames();
        Schema partitionSchema = partitionSpec.schema();
        List partitionFields = partitionSpec.fields();
        List icebergPartitionColumns = partitionFields.stream().map(f -> partitionSchema.findField(f.sourceId()).name()).collect(Collectors.toList());
        Sets.SetView dssNotIcebergPartitionColumn = Sets.difference((Set)Sets.newHashSet((Iterable)columns), (Set)Sets.newHashSet(icebergPartitionColumns));
        if (!dssNotIcebergPartitionColumn.isEmpty()) {
            throw new IllegalArgumentException("Some dataset partitioning dimensions are not Iceberg partition columns: " + dssNotIcebergPartitionColumn.stream().collect(Collectors.joining(", ")));
        }
        HashMap<String, Integer> icebergPartitionFieldPositions = new HashMap<String, Integer>();
        HashSet acceptedTransforms = Sets.newHashSet((Object[])new String[]{"identity", "year", "month", "day", "hour"});
        for (String name : columns) {
            int pos = icebergPartitionColumns.indexOf(name);
            if (pos < 0) {
                throw new IllegalArgumentException("Partition column " + name + " not found in iceberg partition spec");
            }
            icebergPartitionFieldPositions.put(name, pos);
            PartitionField partitionField = (PartitionField)partitionFields.get(pos);
            if (acceptedTransforms.contains(partitionField.transform().toString())) continue;
            throw new IllegalArgumentException("Iceberg partition transform " + String.valueOf(partitionField.transform()) + " cannot be used in DSS");
        }
        return icebergPartitionFieldPositions;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        PrivilegedExceptionAction<List> action = () -> {
            ArrayList<Partition> ret = new ArrayList<Partition>();
            PartitioningScheme scheme = this.dataset.getPartitioningSchema();
            Table table = this.loadTable();
            PartitionSpec partitionSpec = table.spec();
            Map<String, Integer> nameToPos = this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
            Schema partitionSchema = partitionSpec.schema();
            List columns = scheme.getDimensionNames();
            HashMap distinctValues = new HashMap();
            try (CloseableIterable scan = table.newScan().planFiles();){
                IcebergValueConverter converter = new IcebergValueConverter();
                for (FileScanTask file : scan) {
                    StructLike icebergPartition = file.partition();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("File " + String.valueOf(((DataFile)file.file()).path()) + " has partition " + String.valueOf(icebergPartition)));
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    for (String name : columns) {
                        int i = nameToPos.get(name);
                        PartitionField field = (PartitionField)partitionSpec.fields().get(i);
                        Type icebergType = partitionSchema.findType(name);
                        Object icebergValue = icebergPartition.get(i, partitionSpec.javaClasses()[i]);
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("  Got " + String.valueOf(icebergValue) + " for " + name + " in type " + String.valueOf(icebergType) + " and class " + String.valueOf(partitionSpec.javaClasses()[i]) + " transformed by " + String.valueOf(field.transform())));
                        }
                        String value = converter.toDSSPartitionValue(icebergValue, icebergType, field.transform());
                        values.add(value);
                    }
                    String spec = values.stream().collect(Collectors.joining("|"));
                    distinctValues.put(spec, values);
                }
            }
            for (List values : distinctValues.values()) {
                Partition p = new Partition(scheme);
                for (int i = 0; i < columns.size(); ++i) {
                    Dimension dimension = scheme.getDimension((String)columns.get(i));
                    DimensionValue val = dimension.getValueFromId((String)values.get(i));
                    p.setDimensionValue((String)columns.get(i), val);
                }
                ret.add(p);
            }
            return ret;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public long getRecords() throws Exception {
        logger.info((Object)"Computing record count by aggregating file counts");
        PrivilegedExceptionAction<Long> action = () -> {
            Table table = this.loadTable();
            long count = 0L;
            try (CloseableIterable files = table.newScan().planFiles();){
                for (FileScanTask file : files) {
                    count += ((DataFile)file.file()).recordCount();
                }
            }
            logger.info((Object)("> " + count));
            return count;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public DatasetRecordCount getRecordsFast() throws Exception {
        logger.info((Object)"Computing record count by aggregating approximate counts");
        PrivilegedExceptionAction<DatasetRecordCount> action = () -> {
            Table table = this.loadTable();
            long count = 0L;
            try (CloseableIterable files = table.newScan().planFiles();){
                for (FileScanTask file : files) {
                    count += file.estimatedRowsCount();
                }
            }
            logger.info((Object)("> " + count));
            return DatasetRecordCount.approximate(count);
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        logger.info((Object)("Computing record count by aggregating counts for partition " + (p == null ? "" : p.id())));
        PrivilegedExceptionAction<Long> action = () -> {
            Table table = this.loadTable();
            long count = 0L;
            TableScan tableScan = table.newScan();
            if (p != null && !p.isNP() && !p.isAll()) {
                PartitioningScheme scheme = this.dataset.getPartitioningSchema();
                PartitionSpec partitionSpec = table.spec();
                this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
                Expression filter = new IcebergFilterConverter().toIcebergFilter(p, table.schema());
                tableScan = (TableScan)tableScan.filter(filter);
            }
            try (CloseableIterable files = tableScan.planFiles();){
                for (FileScanTask file : files) {
                    count += ((DataFile)file.file()).recordCount();
                }
            }
            logger.info((Object)("> " + count));
            return count;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        try {
            PrivilegedExceptionAction<DatasetReadiness> action = () -> {
                TableIdentifier tableId;
                Catalog catalog = this.getOrCreateIcebergCatalog();
                if (catalog.tableExists(tableId = this.resolveTableIdentifier())) {
                    Table table = catalog.loadTable(tableId);
                    PartitioningScheme scheme = this.dataset.getPartitioningSchema();
                    if (scheme != null && scheme.isPartitioned()) {
                        PartitionSpec partitionSpec = table.spec();
                        this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
                        Expression filter = new IcebergFilterConverter().toIcebergFilter(p, table.schema());
                        ArrayList<String> fileHashes = new ArrayList<String>();
                        try (CloseableIterable files = ((TableScan)table.newScan().filter(filter)).planFiles();){
                            for (FileScanTask file : files) {
                                Long fileNumber = ((DataFile)file.file()).fileSequenceNumber();
                                if (fileNumber == null) {
                                    String location = StringUtils.defaultIfBlank((String)((DataFile)file.file()).path().toString(), (String)"");
                                    long size = ((DataFile)file.file()).fileSizeInBytes();
                                    fileHashes.add(String.format("{l=%s s=%s}", location, size));
                                    continue;
                                }
                                fileHashes.add(Long.toString(fileNumber));
                            }
                        }
                        if (fileHashes.isEmpty()) {
                            return DatasetReadiness.notReady(new Exception("Iceberg table " + String.valueOf(tableId) + " exist but has no partition " + p.id()));
                        }
                        return DatasetReadiness.ready(DKUtils.md5Base64((String)fileHashes.stream().collect(Collectors.joining(" "))));
                    }
                    Snapshot snapshot = table.currentSnapshot();
                    if (snapshot == null) {
                        return DatasetReadiness.notReady(new Exception("Iceberg table " + String.valueOf(tableId) + " exist but is empty"));
                    }
                    long snapshotId = snapshot.snapshotId();
                    return DatasetReadiness.ready(Long.toString(snapshotId));
                }
                return DatasetReadiness.notReady(new Exception("Iceberg table " + String.valueOf(tableId) + " doesn't exist"));
            };
            return this.getIcebergActionRunner().doAs(action);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to test iceberg table readiness", (Throwable)e);
            return DatasetReadiness.error(e);
        }
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        PrivilegedExceptionAction<Boolean> action = () -> {
            PartitioningScheme scheme = this.dataset.getPartitioningSchema();
            Table table = this.loadTableOrNull();
            if (table == null) {
                return false;
            }
            PartitionSpec partitionSpec = table.spec();
            this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
            Expression filter = new IcebergFilterConverter().toIcebergFilter(p, table.schema());
            try (CloseableIterable files = ((TableScan)table.newScan().filter(filter)).planFiles();){
                CloseableIterator closeableIterator = files.iterator();
                if (closeableIterator.hasNext()) {
                    FileScanTask file = (FileScanTask)closeableIterator.next();
                    Boolean bl = true;
                    return bl;
                }
            }
            return false;
        };
        return this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public void createManaged() throws Exception {
        if (this.dataset.getSchema() == null) {
            throw ErrorContext.iaef((String)"Dataset %s has no schema, can't create table", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        logger.info((Object)("Create iceberg table for dataset " + this.dataset.getFullName()));
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        String connectionTblPropPrefix = "default.table.property.";
        String datasetTblPropPrefix = "table.property.";
        for (AbstractSQLConnection.CustomDatabaseProperty prop : this.connection.getDkuProperties()) {
            if (!prop.name.startsWith(connectionTblPropPrefix)) continue;
            tableProperties.put(prop.name.substring(connectionTblPropPrefix.length()), prop.value);
        }
        for (AbstractSQLConnection.CustomDatabaseProperty prop : this.dataset.getModel().dkuProperties) {
            if (!prop.name.startsWith(datasetTblPropPrefix)) continue;
            tableProperties.put(prop.name.substring(datasetTblPropPrefix.length()), prop.value);
        }
        if (!tableProperties.isEmpty()) {
            logger.info((Object)("Using table properties " + JSON.log(tableProperties)));
        }
        PrivilegedExceptionAction<Void> action = () -> {
            Catalog catalog = this.getOrCreateIcebergCatalog();
            TableIdentifier tableId = this.resolveTableIdentifier();
            PartitioningScheme scheme = this.dataset.getPartitioningSchema();
            if (catalog instanceof SupportsNamespaces) {
                SupportsNamespaces namespaces = (SupportsNamespaces)catalog;
                if (this.connection.params.autoCreateNamespace && !namespaces.namespaceExists(tableId.namespace())) {
                    String[] levels = tableId.namespace().levels();
                    for (int l = 1; l <= levels.length; ++l) {
                        Namespace ns = Namespace.of((String[])Arrays.copyOf(levels, l));
                        if (!namespaces.namespaceExists(ns)) {
                            logger.info((Object)("Creating " + String.valueOf(ns)));
                            namespaces.createNamespace(ns);
                            continue;
                        }
                        logger.info((Object)("Namespace " + String.valueOf(ns) + " already exists"));
                    }
                }
            }
            if (scheme == null || !scheme.isPartitioned()) {
                catalog.createTable(tableId, new IcebergSchemaConverter().convert(this.dataset.getSchema()), null, tableProperties);
            } else {
                Schema schema = new IcebergSchemaConverter().convert(this.dataset.getSchema());
                PartitionSpec.Builder partitionSpecBuilder = PartitionSpec.builderFor((Schema)schema);
                block7: for (String name : scheme.getDimensionNames()) {
                    Dimension dimension = scheme.getDimension(name);
                    if (dimension instanceof ExactValueDimension) {
                        partitionSpecBuilder.identity(name);
                        continue;
                    }
                    if (dimension instanceof TimeDimension) {
                        switch (((TimeDimension)dimension).mappedPeriod) {
                            case YEAR: {
                                partitionSpecBuilder.year(name);
                                continue block7;
                            }
                            case MONTH: {
                                partitionSpecBuilder.month(name);
                                continue block7;
                            }
                            case DAY: {
                                partitionSpecBuilder.day(name);
                                continue block7;
                            }
                            case HOUR: {
                                partitionSpecBuilder.hour(name);
                                continue block7;
                            }
                        }
                        throw new IllegalArgumentException("Unknown time dimension period " + String.valueOf(((TimeDimension)dimension).mappedPeriod));
                    }
                    throw new IllegalArgumentException("Unhandled dimension type: " + dimension.getClass().getCanonicalName());
                }
                catalog.createTable(tableId, schema, partitionSpecBuilder.build(), tableProperties);
            }
            return null;
        };
        this.getIcebergActionRunner().doAs(action);
    }

    public void prepareTableForWrite(Partition targetPartition, Output.WriteMode writeMode) throws IOException, DKUSecurityException, InterruptedException {
        try (AutoCloseableLock lock = NamedLock.acquire((String)("iceberg.structure." + this.dataset.getFullName()));){
            PrivilegedExceptionAction<Void> action = () -> {
                boolean whole;
                Catalog catalog = this.getOrCreateIcebergCatalog();
                TableIdentifier tableId = this.resolveTableIdentifier();
                boolean bl = whole = !this.dataset.getPartitioningSchema().isPartitioned() || targetPartition == null || targetPartition.isAll() || targetPartition.isNP();
                if (whole) {
                    if (writeMode == Output.WriteMode.OVERWRITE) {
                        if (catalog.tableExists(tableId)) {
                            catalog.dropTable(tableId, this.connection.params.purgeOnDrop);
                        }
                        this.createManaged();
                    } else if (!catalog.tableExists(tableId)) {
                        this.createManaged();
                    } else {
                        Boolean compatible = this.isCompatible();
                        if (compatible == null || !compatible.booleanValue()) {
                            if (this.config.noDropOnSchemaMismatch) {
                                throw new IOException("Cannot write to table, table already exists but with an incompatible schema");
                            }
                            logger.info((Object)"Table schema is not compatible, recreate");
                            catalog.dropTable(tableId, this.connection.params.purgeOnDrop);
                            this.createManaged();
                        } else {
                            logger.info((Object)"Table schema is compatible");
                        }
                    }
                } else if (!catalog.tableExists(tableId)) {
                    this.createManaged();
                } else {
                    Boolean compatible = this.isCompatible();
                    if (compatible == null || !compatible.booleanValue()) {
                        if (this.config.noDropOnSchemaMismatch) {
                            throw new IOException("Cannot write to table, table already exists but with an incompatible schema");
                        }
                        logger.info((Object)"Table schema is not compatible, recreate");
                        catalog.dropTable(tableId, this.connection.params.purgeOnDrop);
                        this.createManaged();
                    } else if (writeMode == Output.WriteMode.OVERWRITE) {
                        logger.info((Object)"Schema is compatible, clear output partition");
                        this.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                    } else {
                        logger.info((Object)"Schema is compatible");
                    }
                }
                return null;
            };
            IcebergUtils.runAsThrowingIOException(this.getIcebergActionRunner(), action);
        }
    }

    private Boolean isCompatible() throws IOException, DKUSecurityException {
        Boolean compatible = null;
        IcebergSchemaConverter converter = new IcebergSchemaConverter();
        Table table = this.loadTable();
        compatible = converter.isCompatible((com.dataiku.dip.coremodel.Schema)this.dataset.getSchema(), (Schema)table.schema()).ok;
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme != null && scheme.isPartitioned()) {
            PartitionSpec partitionSpec = table.spec();
            try {
                this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
            }
            catch (Exception e) {
                logger.info((Object)"Partitioning is not correct, regenerating table", (Throwable)e);
                compatible = false;
            }
        }
        return compatible;
    }

    @Override
    public void clearAllData() throws Exception {
        this.clearAllDataAndStructure();
        this.createManaged();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws DKUSecurityException, IOException, InterruptedException {
        if (partitions == null || partitions.isEmpty()) {
            logger.info((Object)"Nothing to clear");
            return;
        }
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme == null || !scheme.isPartitioned()) {
            this.deleteFilesFromTable();
        } else {
            this.deleteFilesFromPartitions(partitions);
        }
    }

    private void deleteFilesFromTable() throws DKUSecurityException, IOException, InterruptedException {
        logger.info((Object)"Clearing table");
        PrivilegedExceptionAction<Void> action = () -> {
            Table table = this.loadTableOrNull();
            if (table == null) {
                return null;
            }
            DeleteFiles deletion = table.newDelete();
            try (CloseableIterable files = table.newScan().planFiles();){
                for (FileScanTask file : files) {
                    logger.info((Object)("Add file for deletion " + String.valueOf(((DataFile)file.file()).path())));
                    deletion.deleteFile((DataFile)file.file());
                }
            }
            IcebergUtils.commitWithRetry(deletion);
            return null;
        };
        IcebergUtils.runAsThrowingIOException(this.getIcebergActionRunner(), action);
    }

    private void deleteFilesFromPartitions(List<Partition> partitions) throws DKUSecurityException, IOException, InterruptedException {
        logger.info((Object)("Clearing partitions " + partitions.stream().map(Partition::id).collect(Collectors.joining(", "))));
        PrivilegedExceptionAction<Void> action = () -> {
            PartitioningScheme scheme = this.dataset.getPartitioningSchema();
            Table table = this.loadTableOrNull();
            if (table == null) {
                return null;
            }
            PartitionSpec partitionSpec = table.spec();
            this.checkIcebergPartitioningIsFinerThanDSSPartitioning(partitionSpec, scheme);
            Schema schema = table.schema();
            IcebergFilterConverter filterConverter = new IcebergFilterConverter();
            Expression filter = filterConverter.toIcebergFilter(partitions, schema);
            DeleteFiles deletion = table.newDelete();
            try (CloseableIterable files = ((TableScan)table.newScan().filter(filter)).planFiles();){
                for (FileScanTask file : files) {
                    logger.info((Object)("Add file for deletion " + String.valueOf(((DataFile)file.file()).path())));
                    deletion.deleteFile((DataFile)file.file());
                }
            }
            IcebergUtils.commitWithRetry(deletion);
            return null;
        };
        IcebergUtils.runAsThrowingIOException(this.getIcebergActionRunner(), action);
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        PrivilegedExceptionAction<Void> action = () -> {
            TableIdentifier tableId;
            Catalog catalog = this.getOrCreateIcebergCatalog();
            if (catalog.tableExists(tableId = this.resolveTableIdentifier())) {
                catalog.dropTable(tableId, this.connection.params.purgeOnDrop);
            } else {
                logger.info((Object)"Table doesn't exist");
            }
            return null;
        };
        this.getIcebergActionRunner().doAs(action);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return new IcebergOutput(this, this.dataset, targetSplit, resplitFactor, targetPartition, warningsContext);
    }

    public PartitioningScheme getIcebergPartitioning() throws IOException, DKUSecurityException, InterruptedException {
        PrivilegedExceptionAction<PartitioningScheme> action = () -> {
            TableIdentifier tableId;
            Catalog catalog = this.getOrCreateIcebergCatalog();
            Table table = catalog.loadTable(tableId = this.resolveTableIdentifier());
            PartitionSpec spec = table.spec();
            if (!spec.isPartitioned()) {
                throw new IllegalArgumentException("Iceberg table is not partitioned");
            }
            PartitioningScheme scheme = new PartitioningScheme();
            Schema partitionSchema = spec.schema();
            for (PartitionField partitionField : spec.fields()) {
                String columnName = partitionSchema.findField(partitionField.sourceId()).name();
                switch (partitionField.transform().toString()) {
                    case "identity": {
                        scheme.addDimension((Dimension)new ExactValueDimension(columnName));
                        break;
                    }
                    case "year": {
                        scheme.addDimension((Dimension)new TimeDimension(columnName, TimeDimension.Period.YEAR));
                        break;
                    }
                    case "month": {
                        scheme.addDimension((Dimension)new TimeDimension(columnName, TimeDimension.Period.MONTH));
                        break;
                    }
                    case "day": {
                        scheme.addDimension((Dimension)new TimeDimension(columnName, TimeDimension.Period.DAY));
                        break;
                    }
                    case "hour": {
                        scheme.addDimension((Dimension)new TimeDimension(columnName, TimeDimension.Period.HOUR));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Iceberg partition transform " + String.valueOf(partitionField.transform()) + " cannot be used in DSS");
                    }
                }
                if (scheme.getDimensionNames().stream().filter(n -> scheme.getDimension(n) instanceof TimeDimension).count() <= 1L) continue;
                throw new IllegalArgumentException("DSS cannot handle more than 1 temporal dimension in the Iceberg table.");
            }
            return scheme;
        };
        return IcebergUtils.runAsThrowingIOException(this.getIcebergActionRunner(), action);
    }

    public class IcebergSplit
    extends RowsInputSplit {
        private final Expression filter;

        IcebergSplit() {
            this.filter = Expressions.alwaysTrue();
        }

        IcebergSplit(Expression filter) {
            this.filter = filter;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return IcebergDatasetHandler.this.executePush(out, cf, rf, limit, listener, this.filter);
        }

        public String getDesc() {
            return "Iceberg";
        }
    }
}

