/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetParams;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import org.apache.commons.lang.StringUtils;

public class IcebergDatasetMeta
extends DatasetHandler.NonFSMeta<IcebergDatasetHandler, IcebergDatasetParams> {
    public static final IcebergDatasetMeta INSTANCE = new IcebergDatasetMeta();

    @Override
    public String getType() {
        return "iceberg";
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return IcebergDatasetParams.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new IcebergDatasetHandler(authCtx, dataset);
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean handlesClearForOverwriteMode() {
        return true;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings, boolean useExistingParams) throws CodedException {
        IcebergConnection.Params connectionParams = ((IcebergConnection)targetConnection).getParams();
        dataset.setType(this.getType());
        dataset.setManaged(true);
        IcebergDatasetParams config = new IcebergDatasetParams();
        config.connection = targetConnection.name;
        if (specificSettings != null && StringUtils.isNotBlank((String)specificSettings.overrideIcebergNamespace)) {
            config.namespace = specificSettings.overrideIcebergNamespace;
        } else if (StringUtils.isNotBlank((String)connectionParams.defaultNamespaceInManagedDatasetCreation)) {
            config.namespace = connectionParams.defaultNamespaceInManagedDatasetCreation;
        }
        config.table = dataset.getName();
        if (!StringUtils.isBlank((String)connectionParams.tableNameDatasetNamePrefix)) {
            config.table = connectionParams.tableNameDatasetNamePrefix + config.table;
        }
        if (!StringUtils.isBlank((String)connectionParams.tableNameDatasetNameSuffix)) {
            config.table = config.table + connectionParams.tableNameDatasetNameSuffix;
        }
        dataset.setParams(config);
    }
}

