/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.IcebergConnection;
import com.dataiku.dip.connections.iceberg.IcebergCatalogHandler;
import com.dataiku.dip.connections.iceberg.IcebergCatalogHandlers;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.ExactValueDimension;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.HadoopDelegationTokensGenerator;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionField;
import com.dataiku.dss.shadelib.org.apache.iceberg.PartitionSpec;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.SnapshotUpdate;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Namespace;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.SupportsNamespaces;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.BadRequestException;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.CommitFailedException;
import com.dataiku.dss.shadelib.org.apache.iceberg.types.Type;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Master;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public class IcebergUtils {
    private static Pattern NEED_QUOTING = Pattern.compile("[^a-zA-Z0-9_]");
    private static Pattern ESCAPED_TERMINATING_QUOTE = Pattern.compile("(^|^.*[^\\\\])(\\\\\\\\)*\\\\\"$");
    private static Type.TypeID timestampNano = null;
    private static boolean testedTimestampNano = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.iceberg.utils");

    public static synchronized Type.TypeID getTimestampNanoTypeId() {
        if (!testedTimestampNano) {
            try {
                timestampNano = Type.TypeID.valueOf((String)"TIMESTAMP_NANO");
            }
            catch (Exception e) {
                logger.info((Object)"No TIMESTAMP_NANO found in this iceberg version");
            }
            testedTimestampNano = true;
        }
        return timestampNano;
    }

    public Namespace toNamespace(String namespace) {
        if (StringUtils.isBlank((String)namespace)) {
            return Namespace.empty();
        }
        String[] chunks = namespace.split("\\.");
        ArrayList<String> levels = new ArrayList<String>();
        boolean insideQuotes = false;
        ArrayList<String> quotedLevel = new ArrayList<String>();
        for (String chunk : chunks) {
            if (insideQuotes) {
                if (chunk.charAt(chunk.length() - 1) != '\"' || ESCAPED_TERMINATING_QUOTE.matcher(chunk).matches()) {
                    quotedLevel.add(chunk);
                    continue;
                }
                insideQuotes = false;
                quotedLevel.add(chunk);
                String level = quotedLevel.stream().collect(Collectors.joining("."));
                levels.add(this.unquoteLevel(level));
                quotedLevel.clear();
                continue;
            }
            if (chunk.startsWith("\"")) {
                if (chunk.charAt(chunk.length() - 1) != '\"' || ESCAPED_TERMINATING_QUOTE.matcher(chunk).matches()) {
                    insideQuotes = true;
                    quotedLevel.add(chunk);
                    continue;
                }
                levels.add(this.unquoteLevel(chunk));
                continue;
            }
            levels.add(chunk);
        }
        if (insideQuotes) {
            throw new IllegalArgumentException("Unable to parse quoted namespace : " + namespace);
        }
        return Namespace.of((String[])levels.toArray(new String[0]));
    }

    public String namespaceToQuotedString(Namespace namespace) {
        ArrayList<String> levels = new ArrayList<String>();
        boolean doQuote = false;
        for (String level : namespace.levels()) {
            if (NEED_QUOTING.matcher(level).find()) {
                doQuote = true;
            }
            levels.add(level);
        }
        if (doQuote) {
            return levels.stream().map(l -> this.quoteLevel((String)l)).collect(Collectors.joining("."));
        }
        return levels.stream().collect(Collectors.joining("."));
    }

    private String quoteLevel(String level) {
        return "\"" + level.replace("\"", "\\\"") + "\"";
    }

    private String unquoteLevel(String level) {
        return level.substring(1, level.length() - 1).replace("\\\"", "\"");
    }

    public List<String> listNamespacesRecursively(SupportsNamespaces catalog) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Namespace namespace : catalog.listNamespaces()) {
            logger.info((Object)("Got top-level namespace: " + String.valueOf(namespace)));
            ret.add(this.namespaceToQuotedString(namespace));
            ret.addAll(this.listNamespacesRecursively(catalog, namespace, 1));
        }
        return ret;
    }

    private List<String> listNamespacesRecursively(SupportsNamespaces catalog, Namespace parent, int depth) {
        ArrayList<String> ret = new ArrayList<String>();
        if (parent.toString().contains("\u001f")) {
            logger.warn((Object)"Namespace contains unit separator, not recursing");
            return ret;
        }
        String indent = IntStream.range(0, depth).mapToObj(i -> "  ").collect(Collectors.joining());
        try {
            for (Namespace namespace : catalog.listNamespaces(parent)) {
                logger.info((Object)(indent + "Got sub namespace: " + String.valueOf(namespace)));
                ret.add(this.namespaceToQuotedString(namespace));
                ret.addAll(this.listNamespacesRecursively(catalog, namespace, depth + 1));
            }
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("listNamespaces must be at either ROOT or DATABASE level")) {
                logger.warn((Object)("listNamespaces failed because : " + e.getMessage()));
                return ret;
            }
            throw e;
        }
        catch (BadRequestException e) {
            if (e.getMessage() != null && e.getMessage().contains("Multipart namespaces are not supported")) {
                logger.warn((Object)("Hierarchical namespaces aren't supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
            throw e;
        }
        return ret;
    }

    public PartitioningScheme inferPartitioningScheme(PartitionSpec icebergSpec, Schema icebergSchema) {
        PartitioningScheme scheme = new PartitioningScheme();
        block14: for (PartitionField field : icebergSpec.fields()) {
            String column = field.name();
            switch (field.transform().toString()) {
                case "identity": {
                    scheme.addDimension((Dimension)new ExactValueDimension(column));
                    continue block14;
                }
                case "year": {
                    scheme.addDimension((Dimension)new TimeDimension(column, TimeDimension.Period.YEAR));
                    continue block14;
                }
                case "month": {
                    scheme.addDimension((Dimension)new TimeDimension(column, TimeDimension.Period.MONTH));
                    continue block14;
                }
                case "day": {
                    scheme.addDimension((Dimension)new TimeDimension(column, TimeDimension.Period.DAY));
                    continue block14;
                }
                case "hour": {
                    scheme.addDimension((Dimension)new TimeDimension(column, TimeDimension.Period.HOUR));
                    continue block14;
                }
            }
            logger.info((Object)("Ignoring partition on " + column + " because the transform is not suitable for DSS " + field.transform().toString()));
        }
        return scheme;
    }

    public TableIdentifier makeSnowflakeCompatible(TableIdentifier tableId) {
        Object table = tableId.name();
        if (!((String)table).startsWith("\"") && !StringUtils.equals((String)table, (String)((String)table).toUpperCase())) {
            table = "\"" + (String)table + "\"";
        }
        return TableIdentifier.of((Namespace)tableId.namespace(), (String)table);
    }

    public ActionRunner getUgi(IcebergConnection icebergConnection, AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException {
        IImpersonationResolverService impersonationResolverService;
        IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(icebergConnection);
        IImpersonationResolverService iImpersonationResolverService = impersonationResolverService = catalogHandler.impersonateHadoopUser() ? (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class) : null;
        if (catalogHandler.impersonateHadoopUser() && impersonationResolverService.isEnabled()) {
            UserGroupInformation ugi;
            if (authCtx.getAuthSource() != AuthCtx.AuthSource.NONE) {
                UserImpersonationTarget impersonated = impersonationResolverService.getTargetUser(projectKey, authCtx);
                ugi = UserGroupInformation.createProxyUser((String)impersonated.hadoopUser, (UserGroupInformation)UserGroupInformation.getLoginUser());
                if (icebergConnection.params.icebergCatalogType == IcebergConnection.IcebergCatalogType.HIVE) {
                    List<AbstractSQLConnection.CustomDatabaseProperty> hadoopProperties = catalogHandler.getHadoopProperties();
                    try {
                        Configuration conf = new Configuration();
                        hadoopProperties.stream().forEach(p -> conf.set(p.name, p.value));
                        String renewer = Master.getMasterPrincipal((Configuration)conf);
                        List<SimpleKeyValue> properties = hadoopProperties.stream().map(p -> new SimpleKeyValue(p.name, p.value)).collect(Collectors.toList());
                        Credentials cred = new Credentials();
                        HadoopDelegationTokensGenerator.fetchHiveMetastoreDelegationToken(properties, ugi, renewer, cred);
                        cred.getAllTokens().stream().forEach(arg_0 -> ((UserGroupInformation)ugi).addToken(arg_0));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to get metastore token", (Throwable)e);
                    }
                }
            } else {
                ugi = UserGroupInformation.getCurrentUser();
            }
            return new ActionRunner(){

                @Override
                public <T> T doAs(PrivilegedExceptionAction<T> action) throws Exception {
                    try {
                        return (T)ugi.doAs(action);
                    }
                    catch (UndeclaredThrowableException e) {
                        if (e.getCause() != null && e.getCause() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                }
            };
        }
        return new ActionRunner(){

            @Override
            public <T> T doAs(PrivilegedExceptionAction<T> action) throws Exception {
                return action.run();
            }
        };
    }

    public static <T> T runAsThrowingIOException(ActionRunner runner, PrivilegedExceptionAction<T> action) throws IOException, InterruptedException, DKUSecurityException {
        try {
            return runner.doAs(action);
        }
        catch (Error e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (DKUSecurityException | IOException | InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to run action", e);
        }
    }

    public static void commitWithRetry(SnapshotUpdate<?> update) throws IOException {
        int nbRetries = DKUApp.getParams().getIntParam("dku.iceberg.commitRetries", Integer.valueOf(10));
        CommitFailedException first = null;
        for (int i = 0; i < nbRetries; ++i) {
            try {
                update.commit();
                return;
            }
            catch (CommitFailedException e) {
                first = e;
                logger.warn((Object)("Commit failed (try " + i + " / " + nbRetries + "): " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e2) {
                    logger.warn((Object)"Interrupted in retry loop");
                    break;
                }
                catch (Exception e3) {
                    logger.warn((Object)("Error in retry loop: " + ExceptionUtils.getMessageWithCauses((Throwable)e3)));
                    break;
                }
            }
        }
        throw new IOException("Unable to commit operation", first);
    }

    public static interface ActionRunner {
        public <T> T doAs(PrivilegedExceptionAction<T> var1) throws Exception;
    }
}

