/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.inline;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetConfig;
import com.dataiku.dip.datasets.inline.InlineDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.datasets.FileUploadService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class InlineDatasetTestHandler
extends FSLikeDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TransactionService transactionService;
    private Dataset dataset;
    static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.inline");

    public InlineDatasetTestHandler(AuthCtx authCtx, InlineDatasetHandler handlerForData, DatasetHandler handlerForName, Dataset dataset) throws IOException {
        super(authCtx, null, handlerForName, dataset);
        this.dataset = dataset;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult scr = new DatasetTestHandler.SchemaConsistencyResult();
        scr.result = new SchemaDetection.SchemaDetectionResult();
        return scr;
    }

    public InlineDatasetTestResult testAsEditable(AuthCtx liu, Dataset ds) throws IllegalArgumentException, IOException {
        InlineDatasetTestResult ret = new InlineDatasetTestResult();
        ret.connectionOK = true;
        return ret;
    }

    @Override
    public InlineDatasetTestResult detectFormats(AuthCtx authCtx) throws Exception {
        InlineDatasetConfig params = this.dataset.getParamsAs(InlineDatasetConfig.class);
        assert (params.importSourceType == InlineDatasetConfig.ImportSourceType.FILE);
        Dataset fakeDataset = new Dataset();
        fakeDataset.setType("Filesystem");
        fakeDataset.setFullName("fakeP.fake");
        File uploadBoxDir = FileUploadService.uploadBoxDir(params.uploadBoxId);
        FilesystemDatasetConfig fakeConfig = new FilesystemDatasetConfig(null, uploadBoxDir.getAbsolutePath());
        fakeDataset.setParams(fakeConfig);
        try (FSLikeDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(DSSAuthCtx.newNone(), fakeDataset, FSLikeDatasetTestHandler.class);){
            FSLikeDatasetTestHandler.FSLikeDatasetTestResult fsres = testHandler.detectFormats(authCtx);
            InlineDatasetTestResult ret = new InlineDatasetTestResult(fsres);
            ret.suggestedName = DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), this.handlerForName.suggestName(), this.datasetsDAO, this.transactionService);
            InlineDatasetTestResult inlineDatasetTestResult = ret;
            return inlineDatasetTestResult;
        }
    }

    @Override
    public InlineDatasetTestResult testFormat(AuthCtx authCtx, boolean forConsistencyCheck, boolean inferStorageTypes) throws Exception {
        InlineDatasetConfig params = this.dataset.getParamsAs(InlineDatasetConfig.class);
        if (params.importSourceType == InlineDatasetConfig.ImportSourceType.FILE) {
            Dataset fakeDataset = new Dataset();
            fakeDataset.setType("Filesystem");
            fakeDataset.setFullName("fakeP.fake");
            File uploadBoxDir = FileUploadService.uploadBoxDir(params.uploadBoxId);
            FilesystemDatasetConfig fakeConfig = new FilesystemDatasetConfig(null, uploadBoxDir.getAbsolutePath());
            fakeDataset.setParams(fakeConfig);
            try (FSLikeDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(DSSAuthCtx.newNone(), fakeDataset, FSLikeDatasetTestHandler.class);){
                FSLikeDatasetTestHandler.FSLikeDatasetTestResult fsres = testHandler.testFormat(authCtx, forConsistencyCheck, inferStorageTypes);
                InlineDatasetTestResult ret = new InlineDatasetTestResult(fsres);
                ret.suggestedName = DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), this.handlerForName.suggestName(), this.datasetsDAO, this.transactionService);
                InlineDatasetTestResult inlineDatasetTestResult = ret;
                return inlineDatasetTestResult;
            }
        }
        InlineDatasetTestResult res = new InlineDatasetTestResult();
        res.connectionOK = true;
        return res;
    }

    public StreamsInputSplit testConnection(FSLikeDatasetTestHandler.FSLikeDatasetTestResult result) throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return new InfoMessage.InfoMessages();
    }

    public static class InlineDatasetTestResult
    extends FSLikeDatasetTestHandler.FSLikeDatasetTestResult {
        public InlineDatasetTestResult() {
        }

        public InlineDatasetTestResult(FSLikeDatasetTestHandler.FSLikeDatasetTestResult fsres) {
            this.connectionError = fsres.connectionError;
            this.connectionMetadata = fsres.connectionMetadata;
            this.connectionOK = fsres.connectionOK;
            this.empty = fsres.empty;
            this.format = fsres.format;
        }
    }
}

