/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.labeling;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.labeling.LabelsDatasetMeta;
import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.datasets.labeling.LabelsDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswerCRUDService;
import com.dataiku.dip.labeling.LabelingService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class LabelsDatasetHandler
implements RowOrientedDatasetHandler {
    @Autowired
    private LabelingAnswerCRUDService labelingAnswerCRUDService;
    @Autowired
    private LabelingService labelingService;
    private final LabelsDatasetParams params;
    private final Dataset dataset;
    private final AuthCtx authCtx;
    public static final LabelsDatasetMeta META = new LabelsDatasetMeta();
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.labeling");

    public LabelsDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.dataset = dataset;
        this.authCtx = authCtx;
        this.params = dataset.getParamsAs(LabelsDatasetParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    private LabelingTask getLabelingTask() throws IOException {
        return this.labelingService.getLabelingTask(this.dataset.getProjectKey(), this.params.labelingTaskId);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void close() {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new LabelsDatasetTestHandler(this);
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
        if (this.params.labelingTaskId == null) {
            throw ErrorContext.ice((String)"Missing input labeling task id");
        }
        if (this.params.labelingTaskType == null) {
            throw ErrorContext.ice((String)"Missing input labeling task type");
        }
    }

    @Override
    public String suggestName() {
        return "labels";
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return true;
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        ExploresService exploresService = (ExploresService)SpringUtils.getBean(ExploresService.class);
        DatasetExploreSettings exploreSettings = exploresService.get(this.dataset.getProjectKey(), this.dataset.getName());
        exploreSettings.script.explorationSampling.autoRefreshSample = true;
        exploresService.save(this.dataset.getProjectKey(), this.dataset.getName(), exploreSettings);
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot manage a Labeling dataset");
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Request to clear a labeling dataset: ignored.");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Request to clear partitions of a labeling dataset: ignored.");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        logger.info((Object)"Request to clear a labeling dataset and its structure: ignored.");
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot write on a Labeling dataset");
    }

    @Override
    public boolean outputHandlesClear() {
        throw new Error("Cannot write on a Labeling dataset");
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new AnnotationSplit(this.getLabelingTask());
    }

    @Override
    public long getRecords() throws Exception {
        return this.labelingAnswerCRUDService.countAnswers(this.authCtx, this.dataset.getProjectKey(), this.params.labelingTaskId, this.params.view);
    }

    Schema getSchema() throws IOException {
        return LabelsDatasetHandler.getSchema(this.params, this.getLabelingTask());
    }

    public static Schema getSchema(LabelsDatasetParams params, LabelingTask labelingTask) {
        if (!labelingTask.hasMinimalPreconditions()) {
            logger.info((Object)"Cannot compute actual schema of labels dataset, labeling task missing some preconditions");
            return new Schema();
        }
        ArrayList columns = Lists.newArrayList();
        columns.add(new SchemaColumn("labeling_task_id", Type.STRING));
        if (labelingTask.idColumn != null) {
            columns.add(new SchemaColumn(labelingTask.idColumn, Type.STRING));
        }
        if (labelingTask.dataColumn() != null) {
            columns.add(new SchemaColumn(labelingTask.dataColumn(), Type.STRING));
        }
        if (labelingTask.preLabelColumn != null) {
            columns.add(new SchemaColumn(labelingTask.getPreLabelOutputColumnName(), Type.STRING));
        }
        columns.add(new SchemaColumn("annotation_date", Type.BIGINT));
        columns.add(new SchemaColumn("reviewer", Type.STRING));
        if (labelingTask.hasCommentsEnabled()) {
            columns.add(new SchemaColumn(labelingTask.commentSettings.columnName, Type.STRING));
        }
        columns.add(new SchemaColumn(labelingTask.labelColumnName, Type.STRING));
        if (params.view == LabelsDatasetParams.View.ALL) {
            columns.add(new SchemaColumn("annotator", Type.STRING));
            columns.add(new SchemaColumn("status", Type.STRING));
        }
        return new Schema((List)columns, true);
    }

    public long getLastUpdate() {
        try {
            return this.labelingAnswerCRUDService.getLastUpdateForLabelsDataset(this.authCtx, this.dataset.getProjectKey(), this.params.labelingTaskId, this.params.view);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get last updated answer", (Throwable)e);
            return 0L;
        }
    }

    class AnnotationSplit
    extends RowsInputSplit {
        private final LabelingTask labelingTask;

        AnnotationSplit(LabelingTask labelingTask) {
            labelingTask.checkMinimalPreconditions();
            this.labelingTask = labelingTask;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            long rowsPushed = 0L;
            List<? extends LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<? extends BaseLabelingAnswer>> answers = LabelsDatasetHandler.this.labelingAnswerCRUDService.listAllForLabelsDataset(LabelsDatasetHandler.this.authCtx, LabelsDatasetHandler.this.dataset.getProjectKey(), LabelsDatasetHandler.this.params.labelingTaskId, LabelsDatasetHandler.this.params.view);
            for (LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<? extends BaseLabelingAnswer> baseLabelingAnswerWithOutputData : answers) {
                this.push(baseLabelingAnswerWithOutputData, out, rf, cf);
                if (limit == null || limit.maxRecords < 0L || ++rowsPushed < limit.maxRecords) continue;
                break;
            }
            if (rowsPushed == 0L) {
                this.addColumns(cf);
            }
            return rowsPushed;
        }

        LabelsDatasetAnswerStatus getStatus(BaseLabelingAnswer answer) {
            if (answer instanceof VerifiedLabelingAnswer) {
                return LabelsDatasetAnswerStatus.VERIFIED;
            }
            if (answer instanceof LabelingAnswer) {
                switch (((LabelingAnswer)answer).status) {
                    case REVIEWED: {
                        return LabelsDatasetAnswerStatus.REVIEWED;
                    }
                    case PENDING_REVIEW: {
                        return LabelsDatasetAnswerStatus.PENDING_REVIEW;
                    }
                }
                throw new IllegalArgumentException("Unreachable");
            }
            throw new IllegalArgumentException("Unreachable");
        }

        private void push(LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<?> answerWithOutputData, ProcessorOutput out, RowFactory rf, ColumnFactory cf) throws Exception {
            Object answer = answerWithOutputData.answer;
            Row row = rf.row();
            row.put(cf.column("labeling_task_id"), LabelsDatasetHandler.this.params.labelingTaskId);
            if (this.labelingTask.idColumn != null) {
                row.put(cf.column(this.labelingTask.idColumn), ((BaseLabelingAnswer)answer).recordId);
            }
            if (answerWithOutputData.data != null && this.labelingTask.dataColumn() != null) {
                row.put(cf.column(this.labelingTask.dataColumn()), answerWithOutputData.data);
            }
            if (this.labelingTask.preLabelColumn != null && answerWithOutputData.preLabel != null) {
                row.put(cf.column(this.labelingTask.getPreLabelOutputColumnName()), answerWithOutputData.preLabel.format());
            }
            row.put(cf.column("annotation_date"), ((BaseLabelingAnswer)answer).creationTime);
            row.put(cf.column("reviewer"), ((BaseLabelingAnswer)answer).reviewer);
            if (this.labelingTask.hasCommentsEnabled()) {
                row.put(cf.column(this.labelingTask.commentSettings.columnName), ((BaseLabelingAnswer)answer).label.comment);
            }
            row.put(cf.column(this.labelingTask.labelColumnName), ((BaseLabelingAnswer)answer).label.format());
            if (LabelsDatasetHandler.this.params.view == LabelsDatasetParams.View.ALL) {
                String annotatorId = null;
                if (answer instanceof LabelingAnswer) {
                    annotatorId = ((LabelingAnswer)answer).annotatorId;
                }
                row.put(cf.column("annotator"), annotatorId);
                row.put(cf.column("status"), this.getStatus((BaseLabelingAnswer)answer).name());
            }
            out.emitRow(row);
        }

        private void addColumns(ColumnFactory cf) {
            cf.column("labeling_task_id");
            if (this.labelingTask.idColumn != null) {
                cf.column(this.labelingTask.idColumn);
            }
            if (this.labelingTask.dataColumn() != null) {
                cf.column(this.labelingTask.dataColumn());
            }
            if (this.labelingTask.preLabelColumn != null) {
                cf.column(this.labelingTask.getPreLabelOutputColumnName());
            }
            cf.column("annotation_date");
            cf.column("reviewer");
            cf.column(this.labelingTask.labelColumnName);
            if (LabelsDatasetHandler.this.params.view == LabelsDatasetParams.View.ALL) {
                cf.column("annotator");
                cf.column("status");
            }
        }

        public String getDesc() {
            return "annotations";
        }
    }

    static enum LabelsDatasetAnswerStatus {
        PENDING_REVIEW,
        REVIEWED,
        VERIFIED;

    }
}

