/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetInputHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetMeta;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetTestHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBOutput;
import com.dataiku.dip.datasets.mongodb.PartitionedMongoDBDatasetInputHandler;
import com.dataiku.dip.datasets.mongodb.UnpartitionedMongoDBDatasetInputHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bson.conversions.Bson;
import org.bson.json.JsonParseException;

public class MongoDBDatasetHandler
implements RowOrientedDatasetHandler {
    public static final DatasetHandler.DatasetMeta<MongoDBDatasetHandler, Config> META = new MongoDBDatasetMeta();
    private final AuthCtx authCtx;
    private final Dataset dataset;
    protected final Config config;
    protected DBObject query;
    protected DBObject queryFields;
    private MongoDBDatasetInputHandler inputHandler;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.mongodb");

    public MongoDBDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.config = (Config)dataset.getParams();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public String suggestName() {
        return this.config.collection;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public void close() {
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException, DKUSecurityException {
        ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, this.config.connection, MongoDBConnection.class);
        if (StringUtils.isBlank((String)this.config.collection)) {
            throw ErrorContext.iae((String)"Missing collection parameter");
        }
        String queryParam = this.config.query;
        if (queryParam != null && !queryParam.isEmpty()) {
            try {
                BasicDBObject basicDBObject = BasicDBObject.parse((String)queryParam);
            }
            catch (JsonParseException e) {
                throw new IllegalArgumentException("Invalid JSON query : " + queryParam + " : " + e.getMessage());
            }
        }
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        this.initInputHandler();
        return this.inputHandler.listPartitions();
    }

    @Override
    public long getRecords() throws Exception {
        this.initInputHandler();
        try (MongoDBConnectionWrapper mongoConn = this.getNewConnection();){
            MongoCollection coll = mongoConn.db.getCollection(this.config.collection);
            BasicDBObject q = this.query == null ? new BasicDBObject() : this.query;
            logger.infoV("Counting collection %s with filter %s", new Object[]{this.config.collection, q.toString()});
            BasicDBObject bsonFilter = new BasicDBObject(q.toMap());
            long l = coll.countDocuments((Bson)bsonFilter);
            return l;
        }
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        this.initInputHandler();
        return this.inputHandler.computePartitionRecords(p);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        try {
            this.checkConfiguration();
            this.initInputHandler();
            try (MongoDBConnectionWrapper mongoConn = this.getNewConnection();){
                if (MongoDBDatasetHandler.collectionExists(mongoConn, this.config.collection)) {
                    if (this.dataset.getParams().isNotReadyIfEmpty()) {
                        logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                        DatasetReadiness datasetReadiness = RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                        return datasetReadiness;
                    }
                    DatasetReadiness datasetReadiness = DatasetReadiness.ready(null);
                    return datasetReadiness;
                }
                DatasetReadiness datasetReadiness = DatasetReadiness.notReady(new IOException("Collection does not exist: " + this.config.collection));
                return datasetReadiness;
            }
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return this.listPartitions().contains(p);
    }

    @Override
    public void createManaged() throws Exception {
        this.initInputHandler();
        this.inputHandler.createManaged();
    }

    @Override
    public void clearAllData() throws Exception {
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            this.clearPartitions(this.listPartitions());
        } else {
            this.clearAllDataAndStructure();
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        this.initInputHandler();
        this.inputHandler.clearPartitions(partitions);
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        try (MongoDBConnectionWrapper mongoConn = this.getNewConnection();){
            if (MongoDBDatasetHandler.collectionExists(mongoConn, this.config.collection)) {
                mongoConn.db.getCollection(this.config.collection).drop();
            }
        }
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new MongoDBDatasetTestHandler(this.authCtx, this);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        return new MongoDBOutput(this.authCtx, this.dataset, targetPartition, warningsContext);
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        this.initInputHandler();
        return this.inputHandler.getPartitionSplit(partition);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        this.initInputHandler();
        return this.inputHandler.getFilterSplits(filter);
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        this.initInputHandler();
        return this.inputHandler.getSingleSplit();
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        this.initInputHandler();
        return this.inputHandler.getSampleSplit();
    }

    private void initInputHandler() {
        if (this.inputHandler != null) {
            return;
        }
        String queryParam = this.config.query;
        if (queryParam != null && !queryParam.isEmpty()) {
            try {
                this.query = (DBObject)JSON.parse((String)queryParam, BasicDBObject.class);
            }
            catch (JsonParseException e) {
                logger.warn((Object)("invalid JSON query : " + queryParam + " : " + e.getMessage()));
                throw e;
            }
        }
        if (this.config.strictInputFormat && this.dataset.getSchema() != null) {
            boolean hasIdsInSchema = false;
            this.queryFields = new BasicDBObject();
            for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                this.queryFields.put(sc.getName(), (Object)1);
                if (!sc.getName().equals("_id")) continue;
                hasIdsInSchema = true;
            }
            if (!hasIdsInSchema && !this.config.importIds) {
                this.queryFields.put("_id", (Object)0);
            }
        } else if (!this.config.importIds) {
            this.queryFields = new BasicDBObject("_id", (Object)0);
        }
        this.inputHandler = this.dataset.getPartitioningSchema().isPartitioned() ? new PartitionedMongoDBDatasetInputHandler(this) : new UnpartitionedMongoDBDatasetInputHandler(this);
    }

    protected MongoDBConnectionWrapper getNewConnection() throws IOException, DKUSecurityException {
        logger.info((Object)("Connecting to database, connection=" + this.config.connection));
        return MongoDBConnectionWrapper.get(this.authCtx, this.config.connection);
    }

    @Override
    public boolean executeFastPostCreateOperations() throws IOException {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    static boolean collectionExists(MongoDBConnectionWrapper mongoConn, String collectionName) {
        for (String s : mongoConn.db.listCollectionNames()) {
            if (!Objects.equals(s, collectionName)) continue;
            return true;
        }
        return false;
    }

    public static class Config
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public boolean notReadyIfEmpty;
        public String collection;
        public String query;
        public boolean importIds;
        public boolean strictInputFormat;
        public boolean strictOutputFormat;
        public boolean partitioned;
        public String explicitPartitionsList;
        public String partitioningColumn;
        public StorageTypeVerifier.DataTypeMismatchBehavior readDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
        public StorageTypeVerifier.DataTypeMismatchBehavior writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }
    }
}

