/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.mongodb.MongoDBConnectionWrapper;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetInputHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowSequenceInputSplit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.warnings.WarningsContext;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class PartitionedMongoDBDatasetInputHandler
extends MongoDBDatasetInputHandler {
    protected List<Partition> explicitPartitionsList;
    protected String column;
    protected PartitioningScheme scheme;

    public PartitionedMongoDBDatasetInputHandler(MongoDBDatasetHandler datasetHandler) {
        this.datasetHandler = datasetHandler;
        this.column = datasetHandler.config.partitioningColumn;
        this.scheme = datasetHandler.getDataset().getPartitioningSchema();
        assert (this.scheme.getSingleDimension().getName().equals(this.column));
        String explicitPartitionSpec = datasetHandler.config.explicitPartitionsList;
        if (StringUtils.isNotBlank((String)explicitPartitionSpec)) {
            this.explicitPartitionsList = PartitionFactory.fromPartitionSpec(this.scheme, explicitPartitionSpec);
        }
    }

    @Override
    public void createManaged() throws Exception {
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            logger.infoV("Creating collection %s with index on %s", new Object[]{this.datasetHandler.config.collection, this.column});
            mongoConn.db.createCollection(this.datasetHandler.config.collection);
            mongoConn.db.getCollection(this.datasetHandler.config.collection).createIndex((Bson)new BasicDBObject(this.column, (Object)1));
        }
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList;
        }
        Dimension dimension = this.scheme.getSingleDimension();
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
            logger.info((Object)("Listing partitions for collection: " + this.datasetHandler.config.collection + " with column " + this.column + (String)(this.datasetHandler.query != null ? " with query " + String.valueOf(this.datasetHandler.query) : "")));
            BasicDBObject bsonFilter = this.datasetHandler.query != null ? new BasicDBObject(this.datasetHandler.query.toMap()) : new BasicDBObject();
            DistinctIterable values = this.datasetHandler.query == null ? coll.distinct(this.column, String.class) : coll.distinct(this.column, (Bson)bsonFilter, String.class);
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (Object v : values) {
                Partition part = new Partition(this.scheme);
                DimensionValue value = dimension.getValueFromId(v.toString());
                part.setDimensionValue(this.column, value);
                result.add(part);
            }
            Object object = result;
            return object;
        }
    }

    private Partition getSamplePartition() throws IOException, DKUSecurityException {
        if (this.explicitPartitionsList != null) {
            return this.explicitPartitionsList.isEmpty() ? null : this.explicitPartitionsList.get(0);
        }
        Dimension dimension = this.scheme.getSingleDimension();
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            BasicDBObject q;
            MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
            logger.info((Object)("Looking up sample partition value for collection: " + this.datasetHandler.config.collection + " with column " + this.column + (String)(this.datasetHandler.query != null ? " with query " + String.valueOf(this.datasetHandler.query) : "")));
            BasicDBObject filter = new BasicDBObject(this.column, (Object)new BasicDBObject("$exists", (Object)true).append("$ne", null));
            if (this.datasetHandler.query == null) {
                q = filter;
            } else {
                BasicDBList l = new BasicDBList();
                l.add((Object)filter);
                l.add((Object)this.datasetHandler.query);
                q = new BasicDBObject("$and", (Object)l);
            }
            BasicDBObject bsonFilter = new BasicDBObject(q.toMap());
            FindIterable obj = coll.find((Bson)bsonFilter).projection((Bson)new BasicDBObject(this.column, (Object)1));
            Object v = ((Document)obj.cursor().next()).get((Object)this.column);
            if (v == null) {
                Partition partition = null;
                return partition;
            }
            Partition part = new Partition(this.scheme);
            DimensionValue value = dimension.getValueFromId(v.toString());
            part.setDimensionValue(this.column, value);
            Partition partition = part;
            return partition;
        }
    }

    @Override
    public RowsInputSplit getPartitionSplit(Partition partition) throws Exception {
        return new PartitionSplit(partition);
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        ArrayList<RowsInputSplit> splits = new ArrayList<RowsInputSplit>();
        for (Partition part : this.listPartitions()) {
            RowsInputSplit split = this.getPartitionSplit(part);
            splits.add(split);
        }
        return new RowSequenceInputSplit(splits);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        FilterResultWithSplits result = new FilterResultWithSplits();
        if (!filter.hasPartitionsFiltering()) {
            for (Partition partition : this.listPartitions()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        } else {
            for (Partition partition : filter.getPartitionsClause()) {
                result.withMatchingPartition(partition).withSplit((InputSplit)this.getPartitionSplit(partition));
            }
        }
        return result;
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        Partition part = this.getSamplePartition();
        return part == null ? null : this.getPartitionSplit(part);
    }

    @Override
    public long computePartitionRecords(Partition partition) throws Exception {
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            BasicDBObject q;
            MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
            BasicDBObject partitionQuery = new BasicDBObject(this.column, (Object)((DimensionValue)partition.getDimensionValues().get(this.column)).id());
            if (this.datasetHandler.query == null) {
                q = partitionQuery;
            } else {
                BasicDBList l = new BasicDBList();
                l.add((Object)partitionQuery);
                l.add((Object)this.datasetHandler.query);
                q = new BasicDBObject("$and", (Object)l);
            }
            logger.info((Object)("Counting collection partition: " + this.datasetHandler.config.collection + " with filter " + String.valueOf(q)));
            BasicDBObject bsonFilter = new BasicDBObject(q.toMap());
            long result = coll.countDocuments((Bson)bsonFilter);
            logger.info((Object)("partition=" + ((DimensionValue)partition.getDimensionValues().get(this.column)).id() + " count=" + result));
            long l = result;
            return l;
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"MongoDB clearPartition");
        if (partitions.isEmpty()) {
            return;
        }
        BasicDBList partitionQueries = new BasicDBList();
        for (Partition p : partitions) {
            String partitionId = ((DimensionValue)p.getDimensionValues().get(this.column)).id();
            BasicDBObject partitionQuery = new BasicDBObject(this.column, (Object)partitionId);
            partitionQueries.add((Object)partitionQuery);
        }
        BasicDBObject query = new BasicDBObject("$and", (Object)partitionQueries);
        logger.info((Object)("MongoDB clearPartitions query: " + String.valueOf(query)));
        try (MongoDBConnectionWrapper mongoConn = this.datasetHandler.getNewConnection();){
            MongoCollection coll = mongoConn.db.getCollection(this.datasetHandler.config.collection);
            coll.deleteMany((Bson)query);
        }
    }

    class PartitionSplit
    extends RowsInputSplit {
        Partition partition;

        PartitionSplit(Partition partition) {
            this.partition = partition;
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            BasicDBObject q;
            BasicDBObject partitionQuery = new BasicDBObject(PartitionedMongoDBDatasetInputHandler.this.column, (Object)((DimensionValue)this.partition.getDimensionValues().get(PartitionedMongoDBDatasetInputHandler.this.column)).id());
            if (PartitionedMongoDBDatasetInputHandler.this.datasetHandler.query == null) {
                q = partitionQuery;
            } else {
                BasicDBList l = new BasicDBList();
                l.add((Object)partitionQuery);
                l.add((Object)PartitionedMongoDBDatasetInputHandler.this.datasetHandler.query);
                q = new BasicDBObject("$and", (Object)l);
            }
            return PartitionedMongoDBDatasetInputHandler.this.executePush((DBObject)q, out, cf, rf, limit, listener, warningsContext);
        }

        public String getDesc() {
            return "MongoDB partition " + this.partition.id();
        }
    }
}

