/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sample;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.DelegateFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.sample.LoadedSampleDataset;
import com.dataiku.dip.datasets.sample.SampleDatasetMeta;
import com.dataiku.dip.datasets.sample.SampleDatasetParams;
import com.dataiku.dip.datasets.sample.SampleDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SampleDatasetHandler
extends DelegateFSDatasetHandler {
    private final LoadedSampleDataset loaded;
    private LoadedSampleDataset.AvailableDataset cachedAvailableDataset;

    public SampleDatasetHandler(AuthCtx authCtx, LoadedSampleDataset loaded, Dataset dataset) {
        super(authCtx, dataset);
        this.loaded = loaded;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return new SampleDatasetMeta(this.loaded);
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        return new SampleDatasetTestHandler(this.authCtx, this);
    }

    private static CSVFormatConfig getCSVFormatConfig() {
        CSVFormatConfig ret = new CSVFormatConfig();
        ret.style = CSVFormatConfig.CSVStyle.EXCEL;
        ret.setSeparatorStr(",");
        return ret;
    }

    @Override
    protected void buildReal() throws IOException {
        LoadedSampleDataset.AvailableDataset availableDataset = this.getUsedDataset();
        SerializedDataset realSerializedDataset = new SerializedDataset();
        realSerializedDataset.type = "Filesystem";
        realSerializedDataset.name = this.dataset.getName();
        realSerializedDataset.shortDesc = availableDataset.description;
        realSerializedDataset.projectKey = this.dataset.getProjectKey();
        FilesystemDatasetConfig subConfig = new FilesystemDatasetConfig();
        subConfig.connection = null;
        subConfig.path = availableDataset.path;
        realSerializedDataset.setParams(subConfig);
        realSerializedDataset.formatType = "csv";
        realSerializedDataset.setFormatParams(SampleDatasetHandler.getCSVFormatConfig());
        realSerializedDataset.setSchema(new Schema());
        realSerializedDataset.getSchema().columns = availableDataset.columns;
        realSerializedDataset.managed = false;
        this.setRealDataset(Dataset.fromSerialized(realSerializedDataset));
        FilesystemDatasetHandler dh = (FilesystemDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.getRealDataset());
        this.setRealHandler(dh);
    }

    @Override
    public boolean executeFastPostCreateOperations() {
        return false;
    }

    @Override
    public String suggestName() throws CodedException, DKUSecurityException {
        return this.getUsedDataset().path == null ? "" : new File(this.getUsedDataset().path).getParentFile().getName();
    }

    private LoadedSampleDataset.AvailableDataset getUsedDataset() {
        if (this.cachedAvailableDataset != null) {
            return this.cachedAvailableDataset;
        }
        String version = this.dataset.getParamsAs(SampleDatasetParams.class).getVersionAsString();
        this.cachedAvailableDataset = this.loaded.getDataset(version);
        return this.cachedAvailableDataset;
    }

    private static CodedException cannotWrite() {
        return new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot perform write operation on a sample dataset");
    }

    @Override
    public void createManaged() throws Exception {
        throw SampleDatasetHandler.cannotWrite();
    }

    @Override
    public void clearAllData() throws Exception {
        throw SampleDatasetHandler.cannotWrite();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw SampleDatasetHandler.cannotWrite();
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        throw SampleDatasetHandler.cannotWrite();
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        throw SampleDatasetHandler.cannotWrite();
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    public Schema getSchemaForSampleDataset() throws IOException {
        Dataset realDataset = this.getRealDataset();
        Schema schema = realDataset.getSchema();
        if (schema == null || !schema.hasColumns()) {
            throw ErrorContext.iaef((String)"The sample %s has no schema or an empty schema, please update the corresponding plugin component.", (Object)realDataset.getType(), (Object[])new Object[0]);
        }
        return schema;
    }

    public void checkVersionExists(String version) {
        if (this.loaded.getDataset(version) == null) {
            throw ErrorContext.iaef((String)"This sample dataset has no version %s, please use a correct version or update the corresponding plugin component.", (Object)version, (Object[])new Object[0]);
        }
    }
}

