/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sharepointonline;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.SharePointOnlineDatasetHandler;
import com.dataiku.dip.datasets.mongodb.MongoDBDatasetHandler;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;

public class SharePointOnlineDatasetMeta
extends DatasetHandler.NonFSMeta<SharePointOnlineDatasetHandler, MongoDBDatasetHandler.Config> {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sharepointonlinelist");

    @Override
    public String getType() {
        return "SharePointOnline";
    }

    @Override
    public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
        return MongoDBDatasetHandler.Config.class;
    }

    @Override
    public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
        return new SharePointOnlineDatasetHandler(authCtx, dataset);
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isParallelWritable() {
        return false;
    }

    @Override
    public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
        dataset.setType(this.getType());
        dataset.setManaged(true);
        MongoDBDatasetHandler.Config config = new MongoDBDatasetHandler.Config();
        config.collection = dataset.getName();
        config.connection = targetConnection.name;
        dataset.setParams(config);
    }

    @Override
    protected void selfReport(MongoDBDatasetHandler.Config param, JsonObject ret) throws Exception {
    }
}

