/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.signature;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HTTPDatasetHandler;
import com.dataiku.dip.datasets.labeling.LabelsDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DatasetSignatures {
    private static Logger logger = Logger.getLogger((String)"dku.sampling");

    public static String computeBasicSignature(Dataset dataset, List<String> partitions) {
        SerializedDataset sd = dataset.serialize();
        sd.setAllFieldsToNonRawMode();
        sd.smartName = null;
        String pretty = sd.toJSONAndFixupForDataQuality(true);
        String ret = DigestUtils.md5Hex((String)(pretty + (String)(partitions != null ? "---" + StringUtils.join(partitions, (String)"-") : "")));
        return ret;
    }

    public static String computeBasicSignature(StreamingEndpoint streamingEndpoint, List<String> partitions) {
        StreamingEndpoint se = (StreamingEndpoint)JSON.deepCopy((Object)streamingEndpoint);
        String pretty = JSON.pretty((Object)se);
        String ret = DigestUtils.md5Hex((String)(pretty + (String)(partitions != null ? "---" + StringUtils.join(partitions, (String)"-") : "")));
        return ret;
    }

    public static String computeContentSignature(AuthCtx authCtx, Dataset dataset) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (DatasetInspector.isFS(dataset)) {
            logger.info((Object)"Computing content signature on FS dataset");
            try (AbstractFSDatasetHandler fid = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                StringBuilder identifier = new StringBuilder();
                for (FSPath p : fid.enumerateFilesystem()) {
                    identifier.append(p.path()).append('=').append(p.getSize()).append('@').append(p.getLastModified());
                }
                String string = DigestUtils.md5Hex((String)identifier.toString());
                return string;
            }
        }
        if ("HTTP".equals(dataset.getType())) {
            if (!dataset.getPartitioningSchema().isPartitioned()) {
                logger.info((Object)"Computing content signature on unpartitioned HTTP dataset");
                try (HTTPDatasetHandler hdh = (HTTPDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                    String string = hdh.getReadiness((Partition)Partition.newNP(), null).hash;
                    return string;
                }
            }
            BuiltinFSDatasets.HTTPDatasetConfig config = dataset.getParamsAs(BuiltinFSDatasets.HTTPDatasetConfig.class);
            if (!config.partitions.isEmpty()) {
                logger.info((Object)("Computing content signature on HTTP dataset with all partitions " + config.previewPartition));
                return DatasetSignatures.computeContentSignature(authCtx, dataset, config.partitions);
            }
            if (StringUtils.isNotBlank((String)config.previewPartition)) {
                logger.info((Object)("Computing content signature on HTTP dataset with preview partition " + config.previewPartition));
                return DatasetSignatures.computeContentSignature(authCtx, dataset, Lists.newArrayList((Object[])new String[]{config.previewPartition}));
            }
        } else if ("Labels".equals(dataset.getType())) {
            logger.info((Object)"Computing content signature on Labels dataset");
            try (LabelsDatasetHandler dh = (LabelsDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                String string = String.valueOf(dh.getLastUpdate());
                return string;
            }
        }
        return null;
    }

    public static String computeContentSignature(AuthCtx authCtx, StreamingEndpoint streamingEndpoint) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return null;
    }

    public static String computeContentSignature(AuthCtx authCtx, Dataset dataset, List<String> partitions) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (DatasetInspector.isFS(dataset)) {
            try (AbstractFSDatasetHandler fid = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                InputFilter filter = new InputFilter();
                if (partitions != null) {
                    for (String p : partitions) {
                        filter.withSelectedPartition(PartitionFactory.fromIdentifier(dataset.getPartitioningSchema(), p));
                    }
                }
                StringBuilder identifier = new StringBuilder();
                FilePartitioner.ResolvedFilesFilterResult files = fid.getRequiredFiles(filter);
                for (FSPath p : files.getAllPaths()) {
                    identifier.append(p.path()).append('=').append(p.getSize()).append('@').append(p.getLastModified());
                }
                String string = DigestUtils.md5Hex((String)identifier.toString());
                return string;
            }
        }
        if ("HTTP".equals(dataset.getType())) {
            try (HTTPDatasetHandler hdh = (HTTPDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
                if (partitions.size() == 1) {
                    String filter = hdh.getReadiness((Partition)PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partitions.get((int)0)), null).hash;
                    return filter;
                }
                StringBuilder sb = new StringBuilder();
                for (String partition : partitions) {
                    sb.append(hdh.getReadiness((Partition)PartitionFactory.fromIdentifier((PartitioningScheme)dataset.getPartitioningSchema(), (String)partition), null).hash).append('\n');
                }
                String string = DigestUtils.md5Hex((String)sb.toString());
                return string;
            }
        }
        return null;
    }
}

