/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DatasetStorageConflictDetector {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private VariablesService variablesService;
    private final String projectKey;
    private final VariablesContext vc;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.DatasetStorageConflictDetector");

    public DatasetStorageConflictDetector(String projectKey) {
        SpringUtils.getInstance().autowire((Object)this);
        this.projectKey = projectKey;
        this.vc = this.variablesService.getForProject(projectKey);
    }

    public DatasetConflictsCheckResult findConflictsFor(SerializedDataset dataset) throws IOException {
        if (DKUApp.getProperty((String)"dku.datasets.managed.skipStorageConflictCheck", (boolean)false)) {
            return DatasetConflictsCheckResult.noDuplicate();
        }
        DatasetTableIdentifier id = this.getIdentifierFor(dataset);
        if (id == null) {
            return DatasetConflictsCheckResult.noDuplicate();
        }
        for (SerializedDataset other : this.datasetsDAO.listUnsafe(this.projectKey)) {
            try {
                if (other.getId().equals(dataset.name) || !StringUtils.equals((CharSequence)other.getParams().getConnection(), (CharSequence)id.connection) || !Objects.equals(id, this.getIdentifierFor(other))) continue;
                return DatasetConflictsCheckResult.withTableDuplicate(id, other.name);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to read dataset config for " + other.getFullName()), (Throwable)e);
            }
        }
        return DatasetConflictsCheckResult.noDuplicate();
    }

    public ProjectConflictsCheckResult findAllConflictsForProject() throws IOException {
        if (DKUApp.getProperty((String)"dku.datasets.managed.skipStorageConflictCheck", (boolean)false)) {
            return new ProjectConflictsCheckResult(0, Collections.emptyList());
        }
        HashMap<DatasetTableIdentifier, ProjectConflictsCheckHit> idToDatasets = new HashMap<DatasetTableIdentifier, ProjectConflictsCheckHit>();
        for (SerializedDataset dataset : this.datasetsDAO.listUnsafe(this.projectKey)) {
            try {
                DatasetTableIdentifier id = this.getIdentifierFor(dataset);
                if (id == null) continue;
                ProjectConflictsCheckHit hit2 = idToDatasets.computeIfAbsent(id, key -> new ProjectConflictsCheckHit(ConflictKind.SQL_TABLE, id.connection, id.tableLabel(), new ArrayList<String>(), new ArrayList<String>()));
                if (dataset.managed) {
                    hit2.managedDatasetsName.add(dataset.getId());
                    continue;
                }
                hit2.notManagedDatasetNames.add(dataset.getId());
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to read table for dataset " + dataset.getFullName()), (Throwable)e);
            }
        }
        List<ProjectConflictsCheckHit> result = idToDatasets.values().stream().filter(hit -> hit.managedDatasetsName.size() + hit.notManagedDatasetNames.size() > 1 && !hit.managedDatasetsName.isEmpty()).toList();
        int totalManagedWithIssue = result.stream().map(cnt -> cnt.managedDatasetsName.size()).reduce(0, Integer::sum);
        return new ProjectConflictsCheckResult(totalManagedWithIssue, result);
    }

    @Nullable
    private DatasetTableIdentifier getIdentifierFor(SerializedDataset dataset) {
        if (DatasetInspector.isSQLTable(dataset)) {
            AbstractSQLDatasetHandler.AbstractSQLConfig sqlParams = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class);
            return new DatasetTableIdentifier(sqlParams.getConnection(), this.vc.expandAllowUnresolved(sqlParams.catalog), this.vc.expandAllowUnresolved(sqlParams.schema), this.vc.expandAllowUnresolved(sqlParams.table));
        }
        return null;
    }

    public record DatasetConflictsCheckResult(boolean hasDuplicate, @Nullable ConflictKind kind, @Nullable String conflictingLabel, @Nullable String duplicateName) {
        public static DatasetConflictsCheckResult noDuplicate() {
            return new DatasetConflictsCheckResult(false, null, null, null);
        }

        public static DatasetConflictsCheckResult withTableDuplicate(DatasetTableIdentifier id, String duplicateName) {
            return new DatasetConflictsCheckResult(true, ConflictKind.SQL_TABLE, id.tableLabel(), duplicateName);
        }

        public InfoMessage.InfoMessages toInfoMessages() {
            if (this.hasDuplicate && this.kind != null) {
                switch (this.kind) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case SQL_TABLE: 
                }
                return new InfoMessage.InfoMessages().withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_SQL_TABLE_NAME_CONFLICTS_WITH_OTHER_DATASET, "Table '%s' conflicts with the table used by the dataset '%s'. This may result in unexpected behavior or data loss.", new Object[]{this.conflictingLabel, this.duplicateName});
            }
            return new InfoMessage.InfoMessages();
        }
    }

    public record DatasetTableIdentifier(String connection, String catalog, String schema, String table) {
        public String tableLabel() {
            StringBuilder sb = new StringBuilder();
            if (this.catalog != null) {
                sb.append(this.catalog).append(".").append(this.schema == null ? "" : this.schema).append(".");
            } else if (this.schema != null) {
                sb.append(this.schema).append(".");
            }
            sb.append(this.table);
            return sb.toString();
        }
    }

    public record ProjectConflictsCheckResult(int totalManagedWithIssue, List<ProjectConflictsCheckHit> duplicates) {
    }

    public record ProjectConflictsCheckHit(ConflictKind kind, String connection, String conflictingLabel, List<String> managedDatasetsName, List<String> notManagedDatasetNames) {
    }

    public static enum ConflictKind {
        SQL_TABLE;

    }
}

