/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.treasuredata;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.datasets.sql.treasuredata.RowData;
import com.dataiku.dip.datasets.sql.treasuredata.TreasureDataSQLTableOutputWriter;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TreasureDataSQLTableOutput
implements Output,
CanShareSQLConnection {
    private final AbstractSQLTableDatasetHandler handler;
    private final Partition targetPartition;
    private final WarningsContext warningsContext;
    private final List<RowData.Cell> dimensionValues = new ArrayList<RowData.Cell>();
    private CanShareSQLConnection.SQLConnectionShare connShare;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql.treasuredata");

    public TreasureDataSQLTableOutput(AbstractSQLTableDatasetHandler handler, Partition targetPartition, WarningsContext warningsContext) {
        Dataset dataset = handler.getDataset();
        assert (DatasetInspector.isTreasureData(dataset.getType()));
        if (dataset.getSchema() == null) {
            String errorPattern = "Cannot write to a TreasureDataSQLTable dataset with no schema: %s";
            throw ErrorContext.iaef((String)errorPattern, (Object)dataset.getName(), (Object[])new Object[0]);
        }
        String datasetMode = handler.getResolvedAbstractConfig().mode;
        if (!"table".equals(datasetMode)) {
            String errorPattern = "Cannot write to a TreasureData dataset in '%s' mode: %s";
            throw ErrorContext.iaef((String)errorPattern, (Object)datasetMode, (Object[])new Object[]{dataset.getName()});
        }
        this.handler = handler;
        this.targetPartition = targetPartition;
        this.warningsContext = warningsContext;
        if (targetPartition != null) {
            assert (targetPartition.getScheme() == null || targetPartition.getScheme().equals((Object)dataset.getPartitioningSchema()));
            for (String dimensionName : dataset.getPartitioningSchema().getDimensionNames()) {
                DimensionValue dimensionValue = (DimensionValue)targetPartition.getDimensionValues().get(dimensionName);
                if (dimensionValue == null) {
                    this.dimensionValues.add(RowData.Cell.primitive(dimensionName, null, Type.STRING));
                    continue;
                }
                SchemaColumn partitionColumn = dataset.getSchema().getColumn(dimensionName);
                if (partitionColumn == null) {
                    String errorPattern = "Dataset '%s' does not contain the partitioning column: %s";
                    String error = String.format(errorPattern, dataset.getName(), dimensionName);
                    throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, error);
                }
                Type partitionColumnType = partitionColumn.getType();
                String value = ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType);
                this.dimensionValues.add(RowData.Cell.primitive(dimensionName, value, Type.STRING));
            }
        }
    }

    @Override
    public void shareSQLConnection(CanShareSQLConnection.SQLConnectionShare connShare) {
        this.connShare = connShare;
    }

    public OutputWriter getWriter(Output.WriteMode mode) throws IOException, DKUSecurityException {
        CanShareSQLConnection.SQLConnectionShare connShareToUse = this.connShare == null ? new CanShareSQLConnection.SQLConnectionShare(this.handler.getConnectionData()) : this.connShare;
        return new TreasureDataSQLTableOutputWriter(this.handler, this.warningsContext, mode, connShareToUse, this.targetPartition, this.dimensionValues);
    }
}

