/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.output.OptionallyExtensible;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.TransactionalizableOutputWriter;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class FSBasedStreamWriter
extends StreamWriter {
    protected final AbstractFSDatasetHandler outputFSDH;
    private static Logger logger = Logger.getLogger((String)"dip.stream.writer.fs");

    public FSBasedStreamWriter(AuthCtx authCtx, AbstractFSDatasetHandler outputDH, String sourceId, int splitId) {
        super(authCtx, outputDH, sourceId, splitId);
        this.outputFSDH = outputDH;
    }

    @Override
    public void checkpoint(String newState) throws Exception {
        String backupPath = "_backup-streamstate-" + this.sourceId + "-" + this.splitId + ".json";
        String streamStateFile = "_streamstate-" + this.sourceId + "-" + this.splitId + ".json";
        StreamSourceRecordedState oldState = new StreamSourceRecordedState();
        if (this.outputFSDH.getProvider().stat(streamStateFile) != null) {
            try (InputStream is = this.outputFSDH.getProvider().read(streamStateFile).rawStream();){
                oldState = (StreamSourceRecordedState)JSON.parse((InputStream)is, StreamSourceRecordedState.class);
            }
        }
        CheckpointBackup backup = new CheckpointBackup();
        backup.writesInProgress = this.gatherWritesInProgress();
        backup.state = oldState.state;
        try (OutputStream os = this.outputFSDH.getProvider().write(backupPath);){
            os.write(JSON.json((Object)backup).getBytes(StandardCharsets.UTF_8));
        }
        this.closeOpenPartitions();
        StreamSourceRecordedState ssrs = new StreamSourceRecordedState();
        ssrs.state = newState;
        try (OutputStream os = this.outputFSDH.getProvider().write(streamStateFile);){
            os.write(JSON.json((Object)ssrs).getBytes(StandardCharsets.UTF_8));
        }
        this.outputFSDH.getProvider().deleteRecursive(backupPath);
    }

    protected abstract JsonElement gatherWritesInProgress() throws IOException, InterruptedException;

    @Override
    public String getRecordedState() throws Exception {
        FSPathOrDirectory fspd = this.outputFSDH.getProvider().stat("_streamstate-" + this.sourceId + "-" + this.splitId + ".json");
        if (fspd == null) {
            return null;
        }
        try (InputStream is = this.outputFSDH.getProvider().read(fspd.path()).decompressedStream();){
            StreamSourceRecordedState ssrs = (StreamSourceRecordedState)JSON.parse((InputStream)is, StreamSourceRecordedState.class);
            String string = ssrs.state;
            return string;
        }
    }

    protected void detectFailureAndRecover(String sourceId) throws Exception {
        String backupPath = "_backup-streamstate-" + sourceId + "-" + this.splitId + ".json";
        String streamStateFile = "_streamstate-" + sourceId + "-" + this.splitId + ".json";
        FSProvider provider = this.outputFSDH.getProvider();
        if (provider.stat(backupPath) == null) {
            this.clearTempWriteFiles();
            return;
        }
        CheckpointBackup backup = null;
        try (InputStream is = provider.read(backupPath).rawStream();){
            backup = (CheckpointBackup)JSON.parse((InputStream)is, CheckpointBackup.class);
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid checkpoint backup, assuming checkpoint was in progress");
            this.clearTempWriteFiles();
        }
        if (backup != null) {
            StreamSourceRecordedState ssrs = new StreamSourceRecordedState();
            ssrs.state = backup.state;
            try (OutputStream os = provider.write(streamStateFile);){
                os.write(JSON.json((Object)ssrs).getBytes(StandardCharsets.UTF_8));
            }
            this.clearTempWriteFiles((List)JSON.parse((JsonElement)backup.writesInProgress, (TypeToken)new TypeToken<List<String>>(){}));
        }
        provider.deleteRecursive(backupPath);
    }

    protected abstract void clearTempWriteFiles() throws Exception;

    protected void clearTempWriteFiles(List<String> paths) throws IOException, CodedException, DKUSecurityException {
        logger.info((Object)("Found paths to clear : " + JSON.log(paths)));
        FSProvider provider = this.outputFSDH.getProvider();
        for (String path : paths) {
            if (provider.stat(path) == null) continue;
            provider.deleteRecursive(path);
        }
    }

    public static class StreamSourceRecordedState {
        String state;
    }

    public static class CheckpointBackup
    extends StreamSourceRecordedState {
        public JsonElement writesInProgress;
    }

    protected class FSBasedOpenOutputPartition
    extends StreamWriter.OpenOutputPartition {
        protected FSBasedOpenOutputPartition() {
            super(FSBasedStreamWriter.this);
        }

        @Override
        public void setupNewOpenOutputPartition(String partitionId) throws Exception {
            if (!FSBasedStreamWriter.this.outputDH.isParallelWritable() && FSBasedStreamWriter.this.splitId != 0) {
                throw new IllegalArgumentException("Cannot use splitId != 0");
            }
            this.partition = PartitionFactory.fromIdentifier(FSBasedStreamWriter.this.outputDH.getDataset().getPartitioningSchema(), partitionId);
            this.output = FSBasedStreamWriter.this.outputDH.buildOutput(this.partition, FSBasedStreamWriter.this.splitId, 1, new WarningsContext());
            this.writer = this.output.getWriter(Output.WriteMode.APPEND);
            if (this.writer instanceof TransactionalizableOutputWriter) {
                ((TransactionalizableOutputWriter)this.writer).withTransactionalMode();
            }
            if (this.writer instanceof OptionallyExtensible) {
                ((OptionallyExtensible)this.writer).withExtensible();
            }
            this.writer.init(FSBasedStreamWriter.this.cf);
        }
    }
}

