/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.streamwrite.CurrentTimestampTargetPartitionComputer;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.TargetPartitionComputer;
import com.dataiku.dip.security.AuthCtx;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiPartitionsStreamWriter
extends StreamWriter {
    private Map<String, StreamWriter.OpenOutputPartition> openPartitions = new HashMap<String, StreamWriter.OpenOutputPartition>();
    private final TargetPartitionComputer targetPartitionComputer;
    private final CurrentTimestampTargetPartitionComputer.ComputationTimezone computationTimezone = CurrentTimestampTargetPartitionComputer.ComputationTimezone.LOCAL;
    private static Logger logger = Logger.getLogger((String)"dip.stream.multipartition.writer");

    public MultiPartitionsStreamWriter(AuthCtx authCtx, DatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
        this.targetPartitionComputer = new CurrentTimestampTargetPartitionComputer(outputDH.getDataset().getPartitioningSchema(), this.computationTimezone);
    }

    private StreamWriter.OpenOutputPartition getOrOpenPartition(String partitionId) throws Exception {
        StreamWriter.OpenOutputPartition oop = this.openPartitions.get(partitionId);
        if (oop != null) {
            return oop;
        }
        oop = new StreamWriter.OpenOutputPartition(this);
        oop.setupNewOpenOutputPartition(partitionId);
        this.openPartitions.put(partitionId, oop);
        return oop;
    }

    @Override
    public void append(Row row) throws Exception {
        String partitionId = this.targetPartitionComputer.compute(row);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will write row to " + partitionId));
        }
        StreamWriter.OpenOutputPartition oop = this.getOrOpenPartition(partitionId);
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        for (StreamWriter.OpenOutputPartition oop : this.openPartitions.values()) {
            oop.lastRowEmitted();
        }
        this.openPartitions.clear();
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        for (StreamWriter.OpenOutputPartition oop : this.openPartitions.values()) {
            oop.cancel();
        }
        this.openPartitions.clear();
    }
}

