/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.SQLBasedStreamWriter;
import com.dataiku.dip.security.AuthCtx;
import org.apache.log4j.Logger;

public class UnpartitionedSQLBasedStreamWriter
extends SQLBasedStreamWriter {
    private SQLBasedStreamWriter.SQLBasedOpenOutputPartition openPartition = null;
    private static Logger logger = Logger.getLogger((String)"dip.stream.unpartitioned.sql.writer");

    public UnpartitionedSQLBasedStreamWriter(AuthCtx authCtx, AbstractSQLTableDatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
    }

    private SQLBasedStreamWriter.SQLBasedOpenOutputPartition getOrOpenPartition() throws Exception {
        SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop = this.openPartition;
        if (oop != null) {
            return oop;
        }
        oop = new SQLBasedStreamWriter.SQLBasedOpenOutputPartition();
        oop.setupNewOpenOutputPartition("NP");
        this.openPartition = oop;
        return oop;
    }

    @Override
    public void append(Row row) throws Exception {
        SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop = this.getOrOpenPartition();
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.lastRowEmitted();
            this.openPartition = null;
        }
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.cancel();
            this.openPartition = null;
        }
    }
}

