/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.db.FromH2Copier;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;

public class FromH2CopyUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.db.fromh2");

    public static void copyTable(AbstractDSSDBService involvedService, String sourceTableName, FromH2Copier fromH2Copier, DSSDBConnectionsManagementService targetConnectionsManagementService) throws Exception {
        SQLUtils.SQLTable targetTable = involvedService.resolveTable(sourceTableName);
        logger.debugV("Import internal H2 databases: %s", new Object[]{sourceTableName});
        try (DSSDBConnection targetConnection = targetConnectionsManagementService.acquire(involvedService.getDBRef());){
            try {
                fromH2Copier.copyToTarget(sourceTableName, targetTable, targetConnection, targetConnectionsManagementService.getDialect());
            }
            catch (Exception e) {
                logger.errorV("Could not import internal H2 database from %s.", new Object[]{sourceTableName});
                throw e;
            }
            logger.debugV("Internal H2 databases imported in: %s", new Object[]{targetTable.toString()});
        }
    }
}

