/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.k8s;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.k8s.K8SDeploymentComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.externalinfras.k8s.cli.GetDeploymentResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;

public class K8SDeploymentHealthReporter {
    private final String k8sDeploymentId;
    private final K8SAPIServiceDeployment expectedDeploymentSettings;
    private final GetDeploymentResponse actualDeploymentResponse;
    private final K8SAPIServiceDeployment.K8SDeploymentOverrideMask overrideSettings;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apideployer.datamodel.actual.k8s.k8s-deployment-health-reporter");

    public K8SDeploymentHealthReporter(String k8sDeploymentId, K8SAPIServiceDeployment expectedDeploymentSettings, GetDeploymentResponse actualDeploymentResponse) {
        this.k8sDeploymentId = k8sDeploymentId;
        this.expectedDeploymentSettings = expectedDeploymentSettings;
        this.actualDeploymentResponse = actualDeploymentResponse;
        this.overrideSettings = expectedDeploymentSettings.overrideSettings;
    }

    public Pair<DeploymentHealth, InfoMessage.InfoMessages> getDeploymentHealthReport(DKUtils.ExecutionResults rolloutCommandResults) {
        HashSet<String> outOfSyncMessages = new HashSet<String>();
        try {
            outOfSyncMessages.addAll(K8SDeploymentComparator.reportOutOfSyncFields(this.k8sDeploymentId, this.expectedDeploymentSettings, this.actualDeploymentResponse, this.overrideSettings));
        }
        catch (Exception e) {
            String errorMessage = "Out-of-sync fields couldn't be calculated";
            logger.warnV((Throwable)e, errorMessage, new Object[0]);
            outOfSyncMessages.add(String.format("%s for kubernetes deployment '%s': %s", errorMessage, this.k8sDeploymentId, e.getMessage()));
        }
        Pair<DeploymentHealth, InfoMessage.InfoMessages> outOfSyncReport = this.getOutOfSyncReport(outOfSyncMessages);
        Pair<DeploymentHealth, InfoMessage.InfoMessages> rolloutReport = this.getDeploymentRolloutReport(rolloutCommandResults);
        DeploymentHealth overallHealth = DeploymentHealth.getWithHighestSeverity(List.of((DeploymentHealth)((Object)outOfSyncReport.first), (DeploymentHealth)((Object)rolloutReport.first)));
        InfoMessage.InfoMessages aggregatedMessages = new InfoMessage.InfoMessages().withMessages((InfoMessage.InfoMessages)outOfSyncReport.second).withMessages((InfoMessage.InfoMessages)rolloutReport.second);
        return new Pair((Object)overallHealth, (Object)aggregatedMessages);
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getOutOfSyncReport(Set<String> outOfSyncMessages) {
        MutablePair report = new MutablePair((Object)DeploymentHealth.HEALTHY, (Object)new InfoMessage.InfoMessages());
        for (String message : outOfSyncMessages) {
            logger.warnV("actual kubernetes API service deployment '%s' is out of sync with DSS deployment settings: %s", new Object[]{this.expectedDeploymentSettings.id, message});
            ((InfoMessage.InfoMessages)report.right).withWarningV((InfoMessage.MessageCode)DeployerCodes.WARN_API_DEPLOYER_K8S_OUT_OF_SYNC_CONFIG, message, new Object[0]);
        }
        if (!((InfoMessage.InfoMessages)report.right).isEmpty()) {
            report.setLeft((Object)DeploymentHealth.OUT_OF_SYNC);
        }
        return new Pair((Object)((DeploymentHealth)((Object)report.left)), (Object)((InfoMessage.InfoMessages)report.right));
    }

    private Pair<DeploymentHealth, InfoMessage.InfoMessages> getDeploymentRolloutReport(DKUtils.ExecutionResults rolloutCommandResults) {
        if (rolloutCommandResults.rv != 0 && rolloutCommandResults.err.toLowerCase().startsWith("error:")) {
            return new Pair((Object)DeploymentHealth.ERROR, (Object)new InfoMessage.InfoMessages().withError((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_K8S_ROLLOUT_FAILED, rolloutCommandResults.err));
        }
        if (rolloutCommandResults.out.toLowerCase().contains("waiting for deployment \"" + this.k8sDeploymentId + "\" rollout to finish")) {
            return new Pair((Object)DeploymentHealth.WARNING, (Object)new InfoMessage.InfoMessages().withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_K8S_ROLLOUT_IN_PROGRESS, rolloutCommandResults.out));
        }
        return new Pair((Object)DeploymentHealth.HEALTHY, (Object)new InfoMessage.InfoMessages());
    }
}

