/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerResource;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.SageMakerDeploymentConfigManager;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Tag;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SageMakerModel
extends SageMakerResource<DescribeModelResponse> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.sagemaker.deployment-summary");

    public CreateModelRequest createCreateModelRequest() {
        CreateModelRequest.Builder createModelRequest = CreateModelRequest.builder();
        this.resourceDescription.ifPresent(modelDescription -> createModelRequest.modelName(this.name).primaryContainer(modelDescription.primaryContainer()).enableNetworkIsolation(modelDescription.enableNetworkIsolation()).vpcConfig(modelDescription.vpcConfig()).executionRoleArn(modelDescription.executionRoleArn()).tags(this.getSageMakerTags()));
        return (CreateModelRequest)createModelRequest.build();
    }

    public static class SageMakerModelBuilder {
        private SageMakerModelBuilder() {
        }

        public static SageMakerModel buildFromRemoteConfig_NT(SageMakerClient sageMaker, String modelName) {
            SageMakerModel sageMakerModel = new SageMakerModel();
            sageMakerModel.name = modelName;
            sageMakerModel.resourceShouldExist = StringUtils.isNotBlank((String)modelName);
            if (sageMakerModel.resourceShouldExist) {
                try {
                    Optional<DescribeModelResponse> deployedModelDescription = SageMakerUtils.retrieveCheckSageMakerModel_NT(sageMaker, modelName);
                    if (deployedModelDescription.isPresent()) {
                        sageMakerModel.resourceDescription = deployedModelDescription;
                        sageMakerModel.tags = SageMakerUtils.listTags_NT(sageMaker, deployedModelDescription.get().modelArn()).stream().collect(Collectors.toMap(Tag::key, Tag::value));
                    } else {
                        logger.warn((Object)String.format("Model '%s' is not present in SageMaker. Updating the deployment should create it.", modelName));
                    }
                }
                catch (SdkException e) {
                    logger.errorV("Error while retrieving SageMaker Model %s.", new Object[]{modelName});
                    throw e;
                }
            }
            return sageMakerModel;
        }

        public static SageMakerModel buildFromLocalConfig(SageMakerAPIDeployment deployment, SageMakerAPIDeploymentInfra infra, VariablesContext vc, String resourceName, String containerImageUri) {
            SageMakerDeploymentConfigManager deploymentConfigManager = new SageMakerDeploymentConfigManager(deployment, infra, vc);
            SageMakerModel sageMakerModel = new SageMakerModel();
            sageMakerModel.name = resourceName;
            sageMakerModel.isRemote = false;
            sageMakerModel.tags = deploymentConfigManager.prepareTags();
            DescribeModelResponse modelDescription = (DescribeModelResponse)DescribeModelResponse.builder().modelName(sageMakerModel.name).primaryContainer(deploymentConfigManager.getContainerDefinition(containerImageUri)).enableNetworkIsolation(deploymentConfigManager.getEnableNetworkIsolation()).vpcConfig(deploymentConfigManager.getVpcConfig()).executionRoleArn(deploymentConfigManager.getExecutionRoleArn()).build();
            sageMakerModel.resourceDescription = Optional.of(modelDescription);
            return sageMakerModel;
        }
    }
}

