/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedResourceWithTagsComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerEndpointConfig;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerModel;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CaptureMode;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CaptureOption;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class SageMakerEndpointConfigComparator
extends AbstractFullyManagedResourceWithTagsComparator {
    @Nonnull
    private final SageMakerEndpointConfig endpointConfig;

    public SageMakerEndpointConfigComparator(@Nonnull SageMakerEndpointConfig endpointConfig) {
        this.endpointConfig = endpointConfig;
    }

    @Override
    public Map<String, String> getStoredTags() {
        return this.endpointConfig.tags;
    }

    public boolean isOutOfSync(SageMakerEndpointConfig deployedEndpointConfig, SageMakerModel deployedModel) {
        boolean outOfSync = false;
        if (Objects.nonNull(deployedEndpointConfig) && deployedEndpointConfig.resourceDescription.isPresent() && this.endpointConfig.resourceDescription.isPresent()) {
            DescribeEndpointConfigResponse storedEndpointConfigDescription = (DescribeEndpointConfigResponse)((DescribeEndpointConfigResponse)this.endpointConfig.resourceDescription.get()).toBuilder().build();
            DescribeEndpointConfigResponse deployedEndpointConfigDescription = (DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get();
            ProductionVariant deployedProductionVariant = (ProductionVariant)deployedEndpointConfigDescription.productionVariants().get(0);
            ProductionVariant storedProductionVariant = (ProductionVariant)storedEndpointConfigDescription.productionVariants().get(0);
            if (((ProductionVariant)((DescribeEndpointConfigResponse)this.endpointConfig.resourceDescription.get()).productionVariants().get(0)).serverlessConfig() != null) {
                Integer deployedVolumeSizeInGB = deployedProductionVariant.volumeSizeInGB();
                ProductionVariant updatedStoredVariant = (ProductionVariant)storedProductionVariant.toBuilder().volumeSizeInGB(deployedVolumeSizeInGB).build();
                ArrayList<ProductionVariant> updatedVariants = new ArrayList<ProductionVariant>(storedEndpointConfigDescription.productionVariants());
                updatedVariants.set(0, updatedStoredVariant);
                storedEndpointConfigDescription = (DescribeEndpointConfigResponse)storedEndpointConfigDescription.toBuilder().productionVariants(updatedVariants).build();
            }
            outOfSync = !StringUtils.equalsOrBothBlank((String)deployedProductionVariant.modelName(), (String)deployedModel.name) ? true : (!StringUtils.equalsOrBothBlank((String)storedEndpointConfigDescription.endpointConfigName(), (String)deployedEndpointConfigDescription.endpointConfigName()) ? true : (!StringUtils.equalsOrBothBlank((String)((String)ObjectUtils.defaultIfNull((Object)storedEndpointConfigDescription.kmsKeyId(), (Object)"")), (String)((String)ObjectUtils.defaultIfNull((Object)deployedEndpointConfigDescription.kmsKeyId(), (Object)""))) ? true : (!Objects.equals(storedEndpointConfigDescription.productionVariants(), deployedEndpointConfigDescription.productionVariants()) ? true : !Objects.equals(storedEndpointConfigDescription.dataCaptureConfig(), deployedEndpointConfigDescription.dataCaptureConfig()))));
        }
        return outOfSync;
    }

    private Set<String> reportOutOfSyncProductionVariantFields(SageMakerEndpointConfig deployedEndpointConfig) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.endpointConfig.resourceDescription.isPresent() && deployedEndpointConfig.resourceDescription.isPresent()) {
            DescribeEndpointConfigResponse storedEndpointConfigDescription = (DescribeEndpointConfigResponse)this.endpointConfig.resourceDescription.get();
            DescribeEndpointConfigResponse deployedEndpointConfigDescription = (DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get();
            ProductionVariant deployedProductionVariant = (ProductionVariant)deployedEndpointConfigDescription.productionVariants().get(0);
            ProductionVariant storedProductionVariant = (ProductionVariant)storedEndpointConfigDescription.productionVariants().get(0);
            if (storedProductionVariant.serverlessConfig() != null) {
                Integer storedMemorySize;
                Integer deployedMemorySize;
                Integer storedMaxConcurrency;
                Integer deployedMaxConcurrency = deployedProductionVariant.serverlessConfig().maxConcurrency();
                if (!Objects.equals(deployedMaxConcurrency, storedMaxConcurrency = storedProductionVariant.serverlessConfig().maxConcurrency())) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Max concurrency", deployedMaxConcurrency, storedMaxConcurrency));
                }
                if (!Objects.equals(deployedMemorySize = deployedProductionVariant.serverlessConfig().memorySizeInMB(), storedMemorySize = storedProductionVariant.serverlessConfig().memorySizeInMB())) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Memory size in MB", deployedMemorySize, storedMemorySize));
                }
            } else {
                Integer storedStartupHealthCheck;
                Integer deployedStartupHealthCheck;
                Integer storedInitialInstanceCount;
                Integer deployedInitialInstanceCount;
                String storedInstanceType;
                String deployedInstanceType = deployedProductionVariant.instanceType().toString();
                if (!StringUtils.equalsOrBothBlank((String)deployedInstanceType, (String)(storedInstanceType = storedProductionVariant.instanceType().toString()))) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Instance type", deployedInstanceType, storedInstanceType));
                }
                if (!Objects.equals(deployedInitialInstanceCount = deployedProductionVariant.initialInstanceCount(), storedInitialInstanceCount = storedProductionVariant.initialInstanceCount())) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Initial instance count", deployedInitialInstanceCount, storedInitialInstanceCount));
                }
                if (!Objects.equals(deployedStartupHealthCheck = deployedProductionVariant.containerStartupHealthCheckTimeoutInSeconds(), storedStartupHealthCheck = storedProductionVariant.containerStartupHealthCheckTimeoutInSeconds())) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Startup health check timeout", deployedStartupHealthCheck, storedStartupHealthCheck));
                }
            }
        }
        return outOfSyncFields;
    }

    private Set<String> reportOutOfSyncDataCaptureFields(SageMakerEndpointConfig deployedEndpointConfig) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.endpointConfig.resourceDescription.isPresent() && deployedEndpointConfig.resourceDescription.isPresent()) {
            boolean storedDataCaptureIsEnabled;
            DescribeEndpointConfigResponse storedEndpointConfigDescription = (DescribeEndpointConfigResponse)this.endpointConfig.resourceDescription.get();
            DescribeEndpointConfigResponse deployedEndpointConfigDescription = (DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get();
            DataCaptureConfig storedDataCapture = storedEndpointConfigDescription.dataCaptureConfig();
            DataCaptureConfig deployedDataCapture = deployedEndpointConfigDescription.dataCaptureConfig();
            boolean deployedDataCaptureIsEnabled = deployedDataCapture != null;
            boolean bl = storedDataCaptureIsEnabled = storedDataCapture != null;
            if (storedDataCaptureIsEnabled && deployedDataCaptureIsEnabled) {
                Integer storedInitialSamplingPercentage;
                Integer deployedInitialSamplingPercentage;
                String storedDataCaptureKmsKeyId;
                String deployedDataCaptureKmsKeyId;
                boolean storedCaptureOutput;
                boolean deployedCaptureOutput;
                boolean storedCaptureInput;
                boolean deployedCaptureInput = deployedDataCapture.captureOptions().contains(CaptureOption.builder().captureMode(CaptureMode.INPUT).build());
                if (deployedCaptureInput != (storedCaptureInput = storedDataCapture.captureOptions().contains(CaptureOption.builder().captureMode(CaptureMode.INPUT).build()))) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capture input data", deployedCaptureInput, storedCaptureInput));
                }
                if ((deployedCaptureOutput = deployedDataCapture.captureOptions().contains(CaptureOption.builder().captureMode(CaptureMode.OUTPUT).build())) != (storedCaptureOutput = storedDataCapture.captureOptions().contains(CaptureOption.builder().captureMode(CaptureMode.OUTPUT).build()))) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capture output data", deployedCaptureOutput, storedCaptureOutput));
                }
                String storedDestinationS3Uri = storedDataCapture.destinationS3Uri();
                String deployedDestinationS3Uri = deployedDataCapture.destinationS3Uri();
                if (!StringUtils.equalsOrBothBlank((String)deployedDestinationS3Uri, (String)storedDestinationS3Uri)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Connection fields or S3 Base path", deployedDestinationS3Uri, storedDestinationS3Uri));
                }
                if (!StringUtils.equalsOrBothBlank((String)(deployedDataCaptureKmsKeyId = (String)ObjectUtils.defaultIfNull((Object)deployedDataCapture.kmsKeyId(), (Object)"")), (String)(storedDataCaptureKmsKeyId = (String)ObjectUtils.defaultIfNull((Object)storedDataCapture.kmsKeyId(), (Object)"")))) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Data capture AWS KMS Key", deployedDataCaptureKmsKeyId, storedDataCaptureKmsKeyId));
                }
                if (!Objects.equals(deployedInitialSamplingPercentage = deployedDataCapture.initialSamplingPercentage(), storedInitialSamplingPercentage = storedDataCapture.initialSamplingPercentage())) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Initial sampling percentage", deployedInitialSamplingPercentage, storedInitialSamplingPercentage));
                }
                HashSet deployedCsvContentTypes = new HashSet();
                HashSet storedCsvContentTypes = new HashSet();
                if (deployedDataCapture.captureContentTypeHeader().csvContentTypes() != null) {
                    deployedCsvContentTypes = new HashSet(deployedDataCapture.captureContentTypeHeader().csvContentTypes());
                }
                if (storedDataCapture.captureContentTypeHeader().csvContentTypes() != null) {
                    storedCsvContentTypes = new HashSet(storedDataCapture.captureContentTypeHeader().csvContentTypes());
                }
                if (!Objects.equals(deployedCsvContentTypes, storedCsvContentTypes)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capture CSV type headers", deployedCsvContentTypes, storedCsvContentTypes));
                }
                HashSet deployedJsonContentTypes = new HashSet();
                HashSet storedJsonContentTypes = new HashSet();
                if (deployedDataCapture.captureContentTypeHeader().jsonContentTypes() != null) {
                    deployedJsonContentTypes = new HashSet(deployedDataCapture.captureContentTypeHeader().jsonContentTypes());
                }
                if (storedDataCapture.captureContentTypeHeader().jsonContentTypes() != null) {
                    storedJsonContentTypes = new HashSet(storedDataCapture.captureContentTypeHeader().jsonContentTypes());
                }
                if (!Objects.equals(deployedJsonContentTypes, storedJsonContentTypes)) {
                    outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Capture JSON type headers", deployedJsonContentTypes, storedJsonContentTypes));
                }
            } else if (deployedDataCaptureIsEnabled != storedDataCaptureIsEnabled) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Enable data capture options", deployedDataCaptureIsEnabled, storedDataCaptureIsEnabled));
            }
        }
        return outOfSyncFields;
    }

    public Set<String> reportOutOfSyncFields(SageMakerEndpointConfig deployedEndpointConfig) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.endpointConfig.resourceDescription.isPresent() && deployedEndpointConfig.resourceDescription.isPresent()) {
            DescribeEndpointConfigResponse storedEndpointConfigDescription = (DescribeEndpointConfigResponse)this.endpointConfig.resourceDescription.get();
            DescribeEndpointConfigResponse deployedEndpointConfigDescription = (DescribeEndpointConfigResponse)deployedEndpointConfig.resourceDescription.get();
            String storedKmsKeyId = (String)ObjectUtils.defaultIfNull((Object)storedEndpointConfigDescription.kmsKeyId(), (Object)"");
            String deployedKmsKeyId = (String)ObjectUtils.defaultIfNull((Object)deployedEndpointConfigDescription.kmsKeyId(), (Object)"");
            if (!StringUtils.equalsOrBothBlank((String)deployedKmsKeyId, (String)storedKmsKeyId)) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("AWS KMS Key for instance volume", deployedKmsKeyId, storedKmsKeyId));
            }
            outOfSyncFields.addAll(this.reportOutOfSyncProductionVariantFields(deployedEndpointConfig));
            outOfSyncFields.addAll(this.reportOutOfSyncDataCaptureFields(deployedEndpointConfig));
            outOfSyncFields.addAll(this.reportOutOfSyncNonDSSTags(deployedEndpointConfig.tags));
            outOfSyncFields.addAll(this.reportMissingDSSTags(deployedEndpointConfig.tags));
        }
        return outOfSyncFields;
    }
}

