/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedResourceWithTagsComparator;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.sagemaker.SageMakerModel;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.utils.CollectionUtils;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class SageMakerModelComparator
extends AbstractFullyManagedResourceWithTagsComparator {
    @Nonnull
    private final SageMakerModel model;

    public SageMakerModelComparator(@Nonnull SageMakerModel model) {
        this.model = model;
    }

    @Override
    public Map<String, String> getStoredTags() {
        return this.model.tags;
    }

    private boolean vpcConfigEquals(VpcConfig config, VpcConfig otherConfig) {
        if (config != null && otherConfig != null) {
            HashSet securityGroupIds = new HashSet((Collection)ObjectUtils.defaultIfNull((Object)config.securityGroupIds(), new ArrayList()));
            HashSet otherSecurityGroupIds = new HashSet((Collection)ObjectUtils.defaultIfNull((Object)otherConfig.securityGroupIds(), new ArrayList()));
            HashSet subnets = new HashSet((Collection)ObjectUtils.defaultIfNull((Object)config.subnets(), new ArrayList()));
            HashSet otherSubnets = new HashSet((Collection)ObjectUtils.defaultIfNull((Object)otherConfig.subnets(), new ArrayList()));
            return CollectionUtils.equalsOrBothEmpty(securityGroupIds, otherSecurityGroupIds) && CollectionUtils.equalsOrBothEmpty(subnets, otherSubnets);
        }
        return config == otherConfig;
    }

    public boolean isOutOfSync(SageMakerModel deployedModel) {
        boolean outOfSync = false;
        if (Objects.nonNull(deployedModel) && deployedModel.resourceDescription.isPresent() && this.model.resourceDescription.isPresent()) {
            DescribeModelResponse modelDescription = (DescribeModelResponse)this.model.resourceDescription.get();
            DescribeModelResponse deployedModelDescription = (DescribeModelResponse)deployedModel.resourceDescription.get();
            outOfSync = !deployedModelDescription.modelName().equals(modelDescription.modelName()) ? true : (!Objects.equals(deployedModelDescription.primaryContainer(), modelDescription.primaryContainer()) ? true : (!StringUtils.equalsOrBothBlank((String)deployedModelDescription.executionRoleArn(), (String)modelDescription.executionRoleArn()) ? true : (!Objects.equals(deployedModelDescription.enableNetworkIsolation(), modelDescription.enableNetworkIsolation()) ? true : (!StringUtils.equalsOrBothBlank((String)((String)deployedModel.tags.get("dss_endpoint_id")), (String)((String)this.model.tags.get("dss_endpoint_id"))) ? true : !this.vpcConfigEquals(deployedModelDescription.vpcConfig(), modelDescription.vpcConfig())))));
        }
        return outOfSync;
    }

    private Set<String> reportOutOfSyncContainerDefinitionFields(SageMakerModel deployedSageMakerModel) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.model.resourceDescription.isPresent() && deployedSageMakerModel.resourceDescription.isPresent()) {
            String deployedModelImageName = ((DescribeModelResponse)deployedSageMakerModel.resourceDescription.get()).primaryContainer().image();
            String storedModelImageName = ((DescribeModelResponse)this.model.resourceDescription.get()).primaryContainer().image();
            outOfSyncFields.addAll(DeploymentResourceComparator.reportOutOfSyncImageNameFields(storedModelImageName, deployedModelImageName));
        }
        return outOfSyncFields;
    }

    private Set<String> reportOutOfSyncNetworkFields(SageMakerModel deployedSageMakerModel) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.model.resourceDescription.isPresent() && deployedSageMakerModel.resourceDescription.isPresent()) {
            Boolean storedEnabledNetworkIsolation;
            DescribeModelResponse deployedModelDescription = (DescribeModelResponse)deployedSageMakerModel.resourceDescription.get();
            DescribeModelResponse storedModelDescription = (DescribeModelResponse)this.model.resourceDescription.get();
            Boolean deployedEnabledNetworkIsolation = deployedModelDescription.enableNetworkIsolation();
            if (!Objects.equals(deployedEnabledNetworkIsolation, storedEnabledNetworkIsolation = storedModelDescription.enableNetworkIsolation())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Network isolation", deployedEnabledNetworkIsolation, storedEnabledNetworkIsolation));
            }
            HashSet deployedSecurityGroupIds = new HashSet();
            HashSet storedSecurityGroupIds = new HashSet();
            if (deployedModelDescription.vpcConfig() != null && deployedModelDescription.vpcConfig().securityGroupIds() != null) {
                deployedSecurityGroupIds = new HashSet(deployedModelDescription.vpcConfig().securityGroupIds());
            }
            if (storedModelDescription.vpcConfig() != null && storedModelDescription.vpcConfig().securityGroupIds() != null) {
                storedSecurityGroupIds = new HashSet(storedModelDescription.vpcConfig().securityGroupIds());
            }
            if (!Objects.equals(deployedSecurityGroupIds, storedSecurityGroupIds)) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Security Group Ids", deployedSecurityGroupIds, storedSecurityGroupIds));
            }
            HashSet deployedSubnets = new HashSet();
            HashSet storedSubnets = new HashSet();
            if (deployedModelDescription.vpcConfig() != null && deployedModelDescription.vpcConfig().subnets() != null) {
                deployedSubnets = new HashSet(deployedModelDescription.vpcConfig().subnets());
            }
            if (storedModelDescription.vpcConfig() != null && storedModelDescription.vpcConfig().subnets() != null) {
                storedSubnets = new HashSet(storedModelDescription.vpcConfig().subnets());
            }
            if (!Objects.equals(deployedSubnets, storedSubnets)) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Subnets", deployedSubnets, storedSubnets));
            }
        }
        return outOfSyncFields;
    }

    public Set<String> reportOutOfSyncFields(SageMakerModel deployedSageMakerModel) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (this.model.resourceDescription.isPresent() && deployedSageMakerModel.resourceDescription.isPresent()) {
            Map storedEnvVars;
            Map deployedEnvVars;
            String storedExecRole;
            DescribeModelResponse modelDescription = (DescribeModelResponse)this.model.resourceDescription.get();
            DescribeModelResponse deployedModelDescription = (DescribeModelResponse)deployedSageMakerModel.resourceDescription.get();
            String deployedExecRole = deployedModelDescription.executionRoleArn();
            if (!StringUtils.equalsOrBothBlank((String)deployedExecRole, (String)(storedExecRole = modelDescription.executionRoleArn()))) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Execution role ARN", deployedExecRole, storedExecRole));
            }
            if (!Objects.equals(deployedEnvVars = (Map)ObjectUtils.defaultIfNull((Object)deployedModelDescription.primaryContainer().environment(), new HashMap()), storedEnvVars = modelDescription.primaryContainer().environment())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Environment variables", DeploymentResourceComparator.censorValues(deployedEnvVars), DeploymentResourceComparator.censorValues(storedEnvVars)));
            }
            outOfSyncFields.addAll(this.reportOutOfSyncContainerDefinitionFields(deployedSageMakerModel));
            outOfSyncFields.addAll(this.reportOutOfSyncNetworkFields(deployedSageMakerModel));
            outOfSyncFields.addAll(this.reportOutOfSyncNonDSSTags(deployedSageMakerModel.tags));
            outOfSyncFields.addAll(this.reportOutOfSyncDSSTags(deployedSageMakerModel.tags));
            outOfSyncFields.addAll(this.reportMissingDSSTags(deployedSageMakerModel.tags));
        }
        return outOfSyncFields;
    }
}

