/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.audit.model.FsLikeTargetSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import java.util.Optional;
import javax.annotation.Nonnull;

@UIModel
public abstract class AbstractAPIDeploymentInfra
extends AbstractDeploymentInfra {
    public static final String FS_LIKE_API_NODE_LOGGING_FEATURE_FLAG = "fsLikeApiNodeLogging";
    public ActivityMonitoringSettings activityMonitoringSettings = new ActivityMonitoringSettings.Pull();
    public CarbonAPISettings carbonAPISettings = new CarbonAPISettings();

    AbstractAPIDeploymentInfra() {
    }

    AbstractAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
    }

    @Override
    public String getKey() {
        return "api+" + this.id;
    }

    public abstract ApiNodeInfraManager getInfraManager(DKULogger var1);

    public boolean shouldTrustAllCertificates() {
        return false;
    }

    @Nonnull
    public abstract APINodeLogging getNodeLogging();

    @Override
    public void encryptFields(PasswordEncryptionService passwordEncryptionService) {
        this.activityMonitoringSettings.encryptFields(passwordEncryptionService);
    }

    public static class CarbonAPISettings {
        public String carbonAPIURL;
    }

    public static class APINodeLogging {
        public boolean automaticallyConfigureFsLikeReporting;
        public boolean automaticallyConfigureEventServerReporting;
        public boolean nodesDirectoryManaged;
        public String eventServerURL;
        public String eventServerAuthKey;
        public boolean trustAllSSLCertificates = true;
        public boolean automaticallyConfigureKafkaReporting;
        public String kafkaConnectionName;
        public String kafkaTopic;
        public FsLikeSettings fsLikeSettings = new FsLikeSettings();

        public EventServerRef getEventServer() {
            Optional ref;
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            if (nd.enabled && (ref = nd.getById(nd.eventServerNodeId)).isPresent()) {
                return new EventServerRef(((NodesDirectory.NodeRef)ref.get()).url, ((NodesDirectory.NodeRef)ref.get()).eventServerAuthKey);
            }
            return new EventServerRef(this.eventServerURL, this.eventServerAuthKey);
        }

        public void checkNodesDirectoryLogManaged() {
            NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
            Optional ref = nd.getById(nd.eventServerNodeId);
            boolean bl = this.nodesDirectoryManaged = nd.enabled && ref.isPresent();
            if (this.nodesDirectoryManaged) {
                this.eventServerURL = ((NodesDirectory.NodeRef)ref.get()).externalUrl;
            }
        }

        public static class FsLikeSettings {
            public String connectionName;
            public String pathWithinConnection;
            public String bucket;
            public FsLikeTargetSettings.Period partitioningPeriod = FsLikeTargetSettings.Period.DAY;
            public long flushEveryBytes = 10000000L;
            public long flushEveryS = 900L;
            public boolean folderByTopic = true;
            public boolean folderByRoutingKey = true;
        }
    }

    public static class EventServerRef {
        private final String eventServerURL;
        private final String eventServerAuthKey;

        public EventServerRef(String eventServerURL, String eventServerAuthKey) {
            this.eventServerURL = eventServerURL;
            this.eventServerAuthKey = eventServerAuthKey;
        }

        public String getEventServerURL() {
            return this.eventServerURL;
        }

        public String getEventServerAuthKey() {
            return this.eventServerAuthKey;
        }
    }
}

