/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.externalinfras.azureml.AzureMLInputValidator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AzureMLAPIDeployment
extends AbstractFullyManagedAPIDeployment {
    public String azAuthMode = "Key";
    @Nonnull
    public AzureMLAPIDeploymentOverrideMask overrideSettings = new AzureMLAPIDeploymentOverrideMask();
    @Nullable
    private String customEndpointName;
    @Nonnull
    private String instanceType = "Standard_DS3_v2";
    private int instanceCount = 1;

    @Nullable
    public String getCustomEndpointName(AzureMLAPIDeploymentInfra infra) {
        if (infra.allowOverrideEndpointName) {
            return this.customEndpointName;
        }
        return null;
    }

    @Nonnull
    public String getInstanceType(AzureMLAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.instanceType;
        }
        return infra.instanceType;
    }

    public int getInstanceCount(AzureMLAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.instanceCount;
        }
        return infra.instanceCount;
    }

    private AzureMLAPIDeployment() {
    }

    protected AzureMLAPIDeployment(String id, AzureMLAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, boolean enabled, VersionTag creationTag) {
        super(id, infra.id, publishedServiceId, version, enabled, creationTag, endpointId);
    }

    protected AzureMLAPIDeployment(AbstractAPIServiceDeployment existingDeployment, List<AzureMLAPIDeployment> otherDeployments, String deploymentId, AzureMLAPIDeploymentInfra infra, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infra.id, enabled, creationTag, endpointId);
        if (existingDeployment instanceof AzureMLAPIDeployment) {
            AzureMLAPIDeployment azureMLExistingDeployment = (AzureMLAPIDeployment)existingDeployment;
            if (StringUtils.isNotBlank((CharSequence)azureMLExistingDeployment.customEndpointName)) {
                StringTransmogrifier transmogrifier = new StringTransmogrifier("-", 0, Integer.valueOf(32), true, false);
                for (AzureMLAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customEndpointName);
                }
                this.customEndpointName = transmogrifier.transmogrify(azureMLExistingDeployment.customEndpointName);
            }
            this.overrideSettings = azureMLExistingDeployment.overrideSettings;
            this.instanceType = azureMLExistingDeployment.instanceType;
            this.instanceCount = azureMLExistingDeployment.instanceCount;
            this.azAuthMode = azureMLExistingDeployment.azAuthMode;
        }
    }

    @Override
    public AbstractDeploymentBasicInfo.AzureMLDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.AzureMLDeploymentBasicInfo azureMLDeplBI = new AbstractDeploymentBasicInfo.AzureMLDeploymentBasicInfo();
        azureMLDeplBI.id = this.id;
        azureMLDeplBI.enabled = this.enabled;
        azureMLDeplBI.publishedServiceId = this.publishedServiceId;
        azureMLDeplBI.deployedServiceId = this.deployedServiceId;
        azureMLDeplBI.infraId = this.infraId;
        azureMLDeplBI.generationsMapping = this.generationsMapping;
        azureMLDeplBI.tags = this.tags;
        azureMLDeplBI.creationTag = this.creationTag;
        azureMLDeplBI.versionTag = this.versionTag;
        azureMLDeplBI.deploymentTag = this.deploymentTag;
        azureMLDeplBI.endpointId = this.endpointId;
        return azureMLDeplBI;
    }

    @Override
    @Nonnull
    public AzureMLAPIDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    private void verifyCustomEndpointNameFormat(AzureMLAPIDeploymentInfra infra) {
        String endpointName = this.getCustomEndpointName(infra);
        if (StringUtils.isBlank((CharSequence)endpointName)) {
            return;
        }
        AzureMLInputValidator.validateEndpointName(endpointName);
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        AzureMLAPIDeploymentInfra azAPIDeploymentInfra;
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (oldDeployment instanceof AzureMLAPIDeployment && infra instanceof AzureMLAPIDeploymentInfra) {
            azAPIDeploymentInfra = (AzureMLAPIDeploymentInfra)infra;
            AzureMLAPIDeployment azOldDeployment = (AzureMLAPIDeployment)oldDeployment;
            if (isDeployed) {
                AzureMLAPIDeployment.verifyImmutableField(azOldDeployment.getCustomEndpointName(azAPIDeploymentInfra), this.getCustomEndpointName(azAPIDeploymentInfra), "Custom endpoint name");
            }
        } else {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not an AzureML deployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        this.verifyCustomEndpointNameFormat(azAPIDeploymentInfra);
    }

    public static class AzureMLAPIDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        boolean sizeAndScaling;
    }
}

