/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDockerDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.StringTransmogrifier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksAPIDeployment
extends AbstractFullyManagedAPIDeployment {
    @Nonnull
    public DatabricksAPIDeploymentOverrideMask overrideSettings = new DatabricksAPIDeploymentOverrideMask();
    @Nullable
    public String customModelName;
    @Nullable
    public String customExperimentName;
    @Nullable
    private String customEndpointName;
    private boolean usesUnityCatalog = true;
    private DatabricksAPIDeploymentInfra.ServedEntitySettings customServedEntitySettings = new DatabricksAPIDeploymentInfra.ServedEntitySettings();

    private DatabricksAPIDeployment() {
    }

    protected DatabricksAPIDeployment(String id, DatabricksAPIDeploymentInfra infra, String publishedServiceId, String version, String endpointId, boolean enabled, VersionTag creationTag) {
        super(id, infra.id, publishedServiceId, version, enabled, creationTag, endpointId);
    }

    protected DatabricksAPIDeployment(AbstractAPIServiceDeployment existingDeployment, List<DatabricksAPIDeployment> otherDeployments, String deploymentId, DatabricksAPIDeploymentInfra infra, @Nullable String endpointId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infra.id, enabled, creationTag, endpointId);
        if (existingDeployment instanceof DatabricksAPIDeployment) {
            DatabricksAPIDeployment databricksExistingDeployment = (DatabricksAPIDeployment)existingDeployment;
            if (StringUtils.isNotBlank((String)databricksExistingDeployment.customEndpointName)) {
                StringTransmogrifier transmogrifier = new StringTransmogrifier("-", 0, Integer.valueOf(63), true, false);
                for (DatabricksAPIDeployment otherDeployment : otherDeployments) {
                    transmogrifier.addAlreadyTransmogrifiedAcceptDupes(otherDeployment.customEndpointName);
                }
                this.customEndpointName = transmogrifier.transmogrify(databricksExistingDeployment.customEndpointName);
            }
            this.customExperimentName = databricksExistingDeployment.customExperimentName;
            this.customModelName = databricksExistingDeployment.customModelName;
            this.usesUnityCatalog = databricksExistingDeployment.usesUnityCatalog;
            this.customServedEntitySettings = new DatabricksAPIDeploymentInfra.ServedEntitySettings(databricksExistingDeployment.customServedEntitySettings);
            this.overrideSettings = databricksExistingDeployment.overrideSettings;
        }
    }

    @Override
    public AbstractDeploymentBasicInfo.DatabricksDeploymentBasicInfo basicInfoUnsafe() {
        AbstractDeploymentBasicInfo.DatabricksDeploymentBasicInfo dbxDeplBI = new AbstractDeploymentBasicInfo.DatabricksDeploymentBasicInfo();
        dbxDeplBI.id = this.id;
        dbxDeplBI.enabled = this.enabled;
        dbxDeplBI.publishedServiceId = this.publishedServiceId;
        dbxDeplBI.deployedServiceId = this.deployedServiceId;
        dbxDeplBI.infraId = this.infraId;
        dbxDeplBI.generationsMapping = this.generationsMapping;
        dbxDeplBI.tags = this.tags;
        dbxDeplBI.creationTag = this.creationTag;
        dbxDeplBI.versionTag = this.versionTag;
        dbxDeplBI.deploymentTag = this.deploymentTag;
        dbxDeplBI.endpointId = this.endpointId;
        return dbxDeplBI;
    }

    @Override
    @Nonnull
    protected AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask getOverrideSettings() {
        return this.overrideSettings;
    }

    @Nullable
    public String getCustomEndpointName(DatabricksAPIDeploymentInfra infra) {
        if (infra.allowOverrideEndpointName) {
            return this.customEndpointName;
        }
        return null;
    }

    public boolean usesUnityCatalog(DatabricksAPIDeploymentInfra infra) {
        if (infra.allowOverrideUnityCatalogSettings && this.overrideSettings.unityCatalogSettings) {
            return this.usesUnityCatalog;
        }
        return infra.usesUnityCatalog;
    }

    @Nonnull
    public DatabricksAPIDeploymentInfra.ServedEntitySettings getServedEntitySettings(DatabricksAPIDeploymentInfra infra) {
        if (infra.allowOverrideSizeAndScaling && this.overrideSettings.sizeAndScaling) {
            return this.customServedEntitySettings;
        }
        return infra.servedEntitySettings;
    }

    @Override
    public void verifyFields(AbstractDeploymentInfra infra, AbstractDeployment oldDeployment, boolean isDeployed) {
        super.verifyFields(infra, oldDeployment, isDeployed);
        if (!(oldDeployment instanceof DatabricksAPIDeployment) || !(infra instanceof DatabricksAPIDeploymentInfra)) {
            throw ErrorContext.iaef((String)"Old deployment with id %s is not a Databricks deployment.", (Object)oldDeployment.id, (Object[])new Object[0]);
        }
        DatabricksAPIDeployment databricksOldAPIDeployment = (DatabricksAPIDeployment)oldDeployment;
        if (isDeployed) {
            DatabricksAPIDeployment.verifyImmutableField(databricksOldAPIDeployment.customEndpointName, this.customEndpointName, "Custom endpoint name");
        }
    }

    public static class DatabricksAPIDeploymentOverrideMask
    extends AbstractAPIServiceDockerDeployment.APIServiceDockerDeploymentOverrideMask {
        boolean unityCatalogSettings;
        boolean sizeAndScaling;
    }
}

