/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.infra.SnowparkInfraManager;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkMachineConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SnowparkAPIDeploymentInfra
extends AbstractFullyManagedAPIDeploymentInfra {
    @Nullable
    public String imageRepositoryPath;
    @Nullable
    public String databaseName;
    @Nullable
    public String schemaName;
    @Nullable
    public String roleName;
    @Nullable
    public String warehouseName;
    @Nullable
    public String computePoolName;
    @Nonnull
    public SnowparkMachineConfig machineConfig = new SnowparkMachineConfig();
    @Nullable
    public String eventTableLogLevel;
    public boolean publicEndpoint = true;
    public boolean allowOverrideResourcesNames = false;

    private SnowparkAPIDeploymentInfra() {
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.SCS;
        this.activityMonitoringSettings = new ActivityMonitoringSettings.Disabled();
    }

    SnowparkAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.SCS;
        this.activityMonitoringSettings = new ActivityMonitoringSettings.Disabled();
    }

    @Nullable
    public String getDatabaseName(SnowflakeConnection connection) {
        if (StringUtils.isNotBlank((CharSequence)this.databaseName)) {
            return this.databaseName;
        }
        return connection.getParams().db;
    }

    @Nullable
    public String getSchemaName(SnowflakeConnection connection) {
        if (StringUtils.isNotBlank((CharSequence)this.schemaName)) {
            return this.schemaName;
        }
        return connection.getParams().defaultSchema;
    }

    @Override
    public void trySetDefaultValues_NT() {
    }

    @Override
    AbstractFullyManagedAPIDeploymentInfra.EndpointType getEndpointType() {
        return AbstractFullyManagedAPIDeploymentInfra.EndpointType.REAL_TIME;
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.SNOWPARK;
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new SnowparkInfraManager(this);
    }

    @Nonnull
    public String getImageRepositoryURL() throws IllegalConfigurationException {
        if (StringUtils.isBlank((CharSequence)this.getRegistryHost())) {
            throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
        }
        if (StringUtils.isBlank((CharSequence)this.imageRepositoryPath)) {
            throw ErrorContext.ice((String)"The image repository path is not defined in the infrastructure settings.");
        }
        return String.format("%s/%s", StringUtils.stripEnd((String)this.getRegistryHost(), (String)"/"), StringUtils.stripStart((String)this.imageRepositoryPath, (String)"/")).toLowerCase();
    }

    @Override
    public void verifyFields(AuthCtx authCtx, AbstractDeploymentInfra oldInfra) throws IOException {
        super.verifyFields(authCtx, oldInfra);
        APIServiceDeploymentsService apiServiceDeploymentsService = (APIServiceDeploymentsService)SpringUtils.getBean(APIServiceDeploymentsService.class);
        if (oldInfra instanceof SnowparkAPIDeploymentInfra) {
            if (apiServiceDeploymentsService.hasDeploymentForInfra(this.id)) {
                SnowparkAPIDeploymentInfra oldSnowparkInfra = (SnowparkAPIDeploymentInfra)oldInfra;
                this.verifyFieldExistingDeployments(oldSnowparkInfra.authConnection, this.authConnection, "Connection");
                this.verifyFieldExistingDeployments(oldSnowparkInfra.databaseName, this.databaseName, "Database");
                this.verifyFieldExistingDeployments(oldSnowparkInfra.schemaName, this.schemaName, "Schema");
                this.verifyFieldExistingDeployments(oldSnowparkInfra.roleName, this.roleName, "Role");
                this.verifyFieldExistingDeployments(oldSnowparkInfra.warehouseName, this.warehouseName, "Warehouse");
                this.verifyFieldExistingDeployments(oldSnowparkInfra.computePoolName, this.computePoolName, "Compute pool");
            }
        } else {
            throw ErrorContext.iaef((String)"Old infra with id %s is not a Snowpark infra.", (Object)oldInfra.id, (Object[])new Object[0]);
        }
    }
}

