/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.APINodeDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.K8SDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.deployments.ApiServiceDeployerKeysCRUDService;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.LambdaAPIClient;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class APINodeDeploymentQuerier {
    private static final int MAX_ATTEMPTS = 3;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployments.querier.apinode");

    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean trustAllSSLCertificates, boolean forTest) throws IOException {
        List<String> urls = ((APINodeDeploymentHeavyStatus)heavyStatus).getPublicURLs();
        if (!(heavyStatus instanceof K8SDeploymentHeavyStatus) || ((K8SDeploymentHeavyStatus)heavyStatus).shouldAddPublicApiPath) {
            urls.replaceAll(url -> url + "/public/api/v1");
        }
        if (forTest) {
            switch (lightStatus.authMethod) {
                case PUBLIC: {
                    return this.runAPINodeQueries_NT(urls, deployedServiceId, endpoint, "", allQueries, trustAllSSLCertificates);
                }
                case API_KEYS: {
                    if (lightStatus.apiKeys.size() == 0) {
                        throw new IllegalArgumentException("Security is enabled, but no API key is available");
                    }
                    PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                    String apiKey = passwordEncryptionService.decryptIfEncrypted(lightStatus.apiKeys.get((int)0).key);
                    return this.runAPINodeQueries_NT(urls, deployedServiceId, endpoint, apiKey, allQueries, trustAllSSLCertificates);
                }
                case OAUTH2: {
                    throw new IllegalStateException("Querying endpoints in OAuth2 context is not available.");
                }
            }
            throw new IllegalArgumentException("Auth method " + String.valueOf((Object)lightStatus.authMethod) + " not supported.");
        }
        ApiServiceDeployerKeysCRUDService apiServiceDeployerKeysCRUDService = (ApiServiceDeployerKeysCRUDService)SpringUtils.getBean(ApiServiceDeployerKeysCRUDService.class);
        String deployerKey = apiServiceDeployerKeysCRUDService.get(lightStatus.deploymentBasicInfo.id);
        if (StringUtils.isBlank((String)deployerKey)) {
            throw new IllegalArgumentException("Deployment is not setup for query through the deployer. Please adjust authorizations on deployment '%s' and update it.".formatted(lightStatus.deploymentBasicInfo.id));
        }
        return this.runAPINodeQueries_NT(urls, deployedServiceId, endpoint, deployerKey, allQueries, trustAllSSLCertificates);
    }

    private BaseLambdaAPIClient.ApiEndpointResponses runAPINodeQueries_NT(List<String> urls, String serviceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, String apiKey, List<ApiEndpointQuery> allQueries, boolean trustAllSSLCertificates) throws Error {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("No URLs for API deployment");
        }
        ArrayList<String> candidates = new ArrayList<String>(urls);
        Collections.shuffle(candidates);
        int remainingAttempts = Math.min(3, candidates.size());
        for (String url : candidates) {
            try {
                return LambdaAPIClient.runQueries(url, apiKey, serviceId, endpoint, allQueries, trustAllSSLCertificates);
            }
            catch (IOException e) {
                logger.warnV((Throwable)e, "Queries failed on API node %s due to an I/O error.", new Object[]{url});
                if (--remainingAttempts != 0) continue;
                logger.warn((Object)"All API nodes failed to reply to the queries.");
                return BaseLambdaAPIClient.ApiEndpointResponses.allErrors(allQueries.size(), e);
            }
        }
        throw new Error("Unreachable");
    }
}

