/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class ApiServiceDeployerKeysCRUDService {
    public static final String DEPLOYMENT_DEPLOYER_KEY_ROTATION_THRESHOLD_DAYS = "dku.apideployer.deployment.deployerKeyRotationThresholdDays";
    public static final String DEPLOYER_KEYS_FILENAME = "deployer-keys.json";
    private Map<String, DeployerKey> deploymentIdToDeployerKey = new HashMap<String, DeployerKey>();
    private static final DKULogger logger;

    protected File deployerKeysFile() {
        return DKUApp.getFile((String[])new String[]{"api-deployer", DEPLOYER_KEYS_FILENAME});
    }

    @PostConstruct
    private void init() {
        File deployerKeysFile = this.deployerKeysFile();
        try {
            if (deployerKeysFile.exists() && deployerKeysFile.isFile()) {
                this.deploymentIdToDeployerKey = (Map)JSON.parseFile((File)deployerKeysFile, (TypeToken)new TypeToken<Map<String, DeployerKey>>(){});
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not load the deployer keys of the api deployer", (Throwable)e);
        }
    }

    @Nullable
    public synchronized String get(String deploymentId) throws IOException {
        DeployerKey deployerKey = this.deploymentIdToDeployerKey.getOrDefault(deploymentId, null);
        if (deployerKey == null) {
            return null;
        }
        return deployerKey.deployerKey;
    }

    public synchronized void createIfNeeded(String deploymentId) throws IOException {
        DeployerKey deployerKey = this.deploymentIdToDeployerKey.getOrDefault(deploymentId, null);
        int rotationThresholdDays = DKUApp.getProperty((String)DEPLOYMENT_DEPLOYER_KEY_ROTATION_THRESHOLD_DAYS, (int)7);
        if (deployerKey != null) {
            if (DKUDateUtils.daysBetweenLocal((long)deployerKey.timestamp, (long)System.currentTimeMillis()) > rotationThresholdDays) {
                logger.traceV("The deployer key for %s is older than %s days, recreating one", new Object[]{deploymentId, rotationThresholdDays});
                this.save(deploymentId, ApiKeyUtils.generateApiKeySecret());
            }
        } else {
            this.save(deploymentId, ApiKeyUtils.generateApiKeySecret());
        }
    }

    public synchronized void save(String deploymentId, @Nullable String deployerKey) throws IOException {
        if (deployerKey == null) {
            this.deploymentIdToDeployerKey.remove(deploymentId);
        } else {
            this.deploymentIdToDeployerKey.put(deploymentId, new DeployerKey(deployerKey));
        }
        JSON.prettyToFile(this.deploymentIdToDeployerKey, (File)this.deployerKeysFile());
    }

    static {
        JSON.registerAdapter(DeployerKey.class, (Object)new JSON.Adapter<DeployerKey>(){

            public JsonElement serialize(DeployerKey deployerKey, Type type, JsonSerializationContext ctx) {
                JsonObject ret = new JsonObject();
                ret.add("timestamp", ctx.serialize((Object)deployerKey.timestamp));
                ret.add("deployerKey", ctx.serialize((Object)((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class)).encryptIfNotEncryptedOrEmpty(deployerKey.deployerKey)));
                return ret;
            }

            public DeployerKey deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                long timestamp = (Long)ctx.deserialize(jsonObj.get("timestamp"), Long.class);
                String deployerKey = ((PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class)).decryptIfEncrypted((String)ctx.deserialize(jsonObj.get("deployerKey"), String.class));
                return new DeployerKey(deployerKey, timestamp);
            }
        });
        logger = DKULogger.getLogger((String)"dku.features.apideployer.deployerkeysservice");
    }

    public static class DeployerKey {
        String deployerKey;
        long timestamp;

        public DeployerKey(String deployerKey) {
            this.deployerKey = deployerKey;
            this.timestamp = System.currentTimeMillis();
        }

        public DeployerKey(String deployerKey, long timestamp) {
            this.deployerKey = deployerKey;
            this.timestamp = timestamp;
        }
    }
}

