/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.connections.AzureMLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureMLDeploymentConfigManager
extends FullyManagedAPIServiceDeploymentConfigManager {
    private final AzureMLAPIDeployment deployment;
    private final AzureMLAPIDeploymentInfra infra;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ConnectionsDAO connectionsDAO;

    public AzureMLDeploymentConfigManager(AzureMLAPIDeployment deployment, AzureMLAPIDeploymentInfra infra, VariablesContext vc) {
        super(vc);
        this.deployment = deployment;
        this.infra = infra;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected AzureMLAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected AzureMLAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    public String generateModelName() {
        return this.generateDeploymentConfigName(255, "dss", "-");
    }

    public String generateEnvironmentName() {
        return this.generateDeploymentConfigName(255, "dss", "-");
    }

    public String generateOnlineEndpointName() {
        return this.generateDeploymentConfigName(32, "dss", "-");
    }

    public String generateOnlineDeploymentName() {
        return this.generateDeploymentConfigName(16, "dss", "");
    }

    public String getMappedPublicInboundNetworkAccess() {
        return this.infra.publicInboundNetworkAccess ? "Enabled" : "Disabled";
    }

    public String getAuthMode() {
        return this.deployment.azAuthMode;
    }

    public String getInstanceType() {
        return this.deployment.getInstanceType(this.infra);
    }

    public int getInstanceCount() {
        return this.deployment.getInstanceCount(this.infra);
    }

    public boolean getAppInsightsEnabled() {
        return this.infra.appInsightsEnabled;
    }

    public String getMappedPublicOutboundNetworkAccess() {
        return this.infra.publicOutboundNetworkAccess ? "enabled" : "disabled";
    }

    public AzureMLOnlineDeployment.ProbeSettings getLivenessProbe() {
        return this.infra.livenessProbe;
    }

    public AzureMLOnlineDeployment.ProbeSettings getReadinessProbe() {
        return this.infra.readinessProbe;
    }

    public AzureMLConnection getAuthAzureConnection(AuthCtx authCtx) throws DKUSecurityException, IOException {
        AzureMLConnection connection;
        String azConnection = this.infra.authConnection;
        if (StringUtils.isBlank((String)azConnection)) {
            throw ErrorContext.iae((String)"Azure connection not specified in the infrastructure.");
        }
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            connection = this.connectionsDAO.getMandatoryConnectionAs(authCtx, azConnection, AzureMLConnection.class);
            if (!connection.isFreelyUsableBy(authCtx)) {
                throw new DKUSecurityException("User is not allowed to access connection " + azConnection);
            }
        }
        return connection;
    }
}

