/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.externalinfras.databricks.DatabricksInputValidator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DatabricksDeploymentConfigManager
extends FullyManagedAPIServiceDeploymentConfigManager {
    private static final int MODEL_NAME_MAX_LENGTH = 61;
    private static final int ENDPOINT_NAME_MAX_LENGTH = 63;
    private static final int EXPERIMENT_NAME_MAX_LENGTH = 500;
    private final DatabricksAPIDeployment deployment;
    private final DatabricksAPIDeploymentInfra infra;

    public DatabricksDeploymentConfigManager(DatabricksAPIDeployment deployment, DatabricksAPIDeploymentInfra infra, VariablesContext vc) {
        super(vc);
        this.deployment = deployment;
        this.infra = infra;
    }

    @Override
    protected AbstractFullyManagedAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected AbstractFullyManagedAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Nonnull
    public String generateModelName(@Nonnull BundledSMVersion smVersion, boolean usesUnityCatalog, @Nullable String catalogName, @Nullable String schemaName) throws IllegalConfigurationException {
        String modelName = this.deployment.customModelName;
        if (StringUtils.isBlank((String)modelName)) {
            if (usesUnityCatalog) {
                catalogName = DatabricksInputValidator.validateCatalogName(catalogName);
                schemaName = DatabricksInputValidator.validateSchemaName(schemaName);
                int generatedNameLength = 61 - catalogName.length() - schemaName.length();
                modelName = String.format("%s.%s.%s", catalogName, schemaName, DatabricksDeploymentConfigManager.generateDefaultNameWithoutTimestamp(smVersion.originalSavedModelName, generatedNameLength));
            } else {
                modelName = DatabricksDeploymentConfigManager.generateDefaultNameWithoutTimestamp(smVersion.originalSavedModelName, 61);
            }
        }
        if (usesUnityCatalog) {
            DatabricksInputValidator.validateUnityCatalogModelName(modelName);
        } else {
            DatabricksInputValidator.validateWorkspaceRegistryModelName(modelName);
        }
        return modelName;
    }

    public String generateExperimentName() {
        String experimentName = this.deployment.customExperimentName;
        if (StringUtils.isBlank((String)experimentName)) {
            if (StringUtils.isBlank((String)this.infra.defaultExperimentLocation)) {
                throw ErrorContext.ice((String)String.format("Experiment location is not set in the '%s' infrastructure settings", this.infra.id));
            }
            String experimentBaseName = this.generateDeploymentConfigNameWithoutTimestamp(500);
            return PathUtils.concatLNT((String[])new String[]{this.infra.defaultExperimentLocation, experimentBaseName});
        }
        return experimentName;
    }

    public String generateEndpointName() {
        String customEndpointName = this.deployment.getCustomEndpointName(this.infra);
        if (StringUtils.isBlank((String)customEndpointName)) {
            return this.generateDeploymentConfigName(63, "dss", "-");
        }
        return customEndpointName;
    }
}

