/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.variables.VariablesContext;
import org.apache.commons.lang3.StringUtils;

public class SnowparkDeploymentConfigManager
extends FullyManagedAPIServiceDeploymentConfigManager {
    private final SnowparkAPIDeployment deployment;
    private final SnowparkAPIDeploymentInfra infra;

    public SnowparkDeploymentConfigManager(SnowparkAPIDeployment deployment, SnowparkAPIDeploymentInfra infra, VariablesContext vc) {
        super(vc);
        this.deployment = deployment;
        this.infra = infra;
    }

    @Override
    protected SnowparkAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected SnowparkAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    public String generateUdfName(String serviceName) {
        return serviceName + "_UDF";
    }

    @Override
    public String getImageName() throws IllegalConfigurationException {
        String prefixAndName = super.getImageName();
        return String.format("%s/%s", StringUtils.strip((String)this.infra.imageRepositoryPath, (String)"/"), StringUtils.stripStart((String)prefixAndName, (String)"/")).toLowerCase();
    }

    @Override
    public String generateImageVersion() throws IllegalConfigurationException {
        return super.generateImageVersion().toLowerCase();
    }

    @Override
    public String getCodeEnvImageName() {
        String prefixAndName = super.getCodeEnvImageName();
        return String.format("%s/%s", StringUtils.strip((String)this.infra.imageRepositoryPath, (String)"/"), StringUtils.stripStart((String)prefixAndName, (String)"/")).toLowerCase();
    }
}

