/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SnowflakeConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.DeploymentStatusReport;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDataModelBuilder;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentLocalSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentRemoteSummary;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark.SnowparkDeploymentStatusReporter;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.SnowparkDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deployments.APIDeployerImageBuilderService;
import com.dataiku.dip.deployer.apideployer.deployments.AbstractFullyManagedAPIServiceDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.FullyManagedAPIServiceDeploymentConfigManager;
import com.dataiku.dip.deployer.apideployer.deployments.SnowparkDeploymentConfigManager;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.common.infra.AbstractInfrasService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.externalinfras.snowpark.SnowparkYamlTemplateFiller;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkService;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.security.audit.model.Log4JTargetSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.client.SnowparkLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.yaml.snakeyaml.Yaml;

public class SnowparkDeploymentManager
extends AbstractFullyManagedAPIServiceDeploymentManager {
    private static final int SNOWFLAKE_ID_MAX_LENGTH = 255;
    private static final String SNOWFLAKE_RESOURCE_SEPARATOR = "_";
    private final SnowparkAPIDeployment deployment;
    private final SnowparkAPIDeploymentInfra infra;
    private final SnowparkDeploymentConfigManager deploymentConfigManager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.snowpark.manager");

    public SnowparkDeploymentManager(AuthCtx authCtx, SnowparkAPIDeployment deployment, SnowparkAPIDeploymentInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.deployment = deployment;
        this.deployment.overrideSettings.applyToDeployment(this.deployment, infra);
        this.infra = infra;
        this.deploymentConfigManager = new SnowparkDeploymentConfigManager(deployment, infra, this.getVariablesContext());
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected SnowparkAPIDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected SnowparkAPIDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    protected SnowparkDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new SnowparkDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    protected int numberOfDeploymentSteps() {
        return this.deployment.enabled ? 7 : 1;
    }

    @Override
    @Nonnull
    protected FuturePayload getDeploymentPayload() {
        return FuturePayload.newSimple((String)"sync_snowpark_api_deployment", (String)("Sync Snowpark deployment: " + this.deployment.id));
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "Snowpark Container Services";
    }

    @Override
    protected FullyManagedAPIServiceDeploymentConfigManager getConfigManager() {
        return this.deploymentConfigManager;
    }

    @Override
    protected SnowparkDeploymentStatusReporter getDeploymentStatusReporter() {
        return new SnowparkDeploymentStatusReporter(this.infra.id, this.deployment.id);
    }

    @Override
    public void enrichLambdaServerConfig(RegularPasswordEncryptionService dockerImagePasswordEncryptionService, LambdaServerConfig lsc) throws CodedException {
        super.enrichLambdaServerConfig(dockerImagePasswordEncryptionService, lsc);
        LambdaServerConfig.AuditLog auditLog = lsc.auditLog;
        if (auditLog.logQueries) {
            logger.info((Object)"Configuring logging of apinode-query and authfail audit events to log4j");
            Log4JTargetSettings l4jts = new Log4JTargetSettings();
            l4jts.routingKeysFiltering = RoutingKeyFiltering.ALL;
            l4jts.topicsFiltering = TopicsFiltering.SELECTED;
            l4jts.topics.add("apinode-query");
            l4jts.topics.add("authfail");
            auditLog.settings.targets.add(l4jts);
        }
    }

    @Override
    public DeploymentStatusReport getFullCheckReport_NT() throws IOException, DKUSecurityException, InterruptedException, SQLException {
        SnowparkDeploymentRemoteSummary remoteSummary;
        SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        if (connection == null) {
            throw ErrorContext.icef((String)"Connection '%s' not found.", (Object)this.infra.authConnection, (Object[])new Object[0]);
        }
        SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        SnowparkDeploymentLocalSummary localSummary = SnowparkDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper = SnowparkUtils.createSQLWrapper_NT(connection, this.authCtx, this.infra, this.connectTimeout, this.socketTimeout);){
            remoteSummary = SnowparkDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, sqlConnectionWrapper);
        }
        return this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
    }

    @Override
    public void deleteResources_NT() throws CodedException, IOException, SQLException, InterruptedException {
        SnowflakeConnection connection;
        SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        }
        catch (DKUSecurityException e) {
            String message = "Error while accessing connection details";
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), message, (Throwable)e);
        }
        if (connection == null) {
            throw ErrorContext.ice((String)"No connection defined in the infrastructure.");
        }
        try (SQLConnectionProvider.SQLConnectionWrapper sqlWrapper = SnowparkUtils.createSQLWrapper_NT(connection, this.authCtx, this.infra, this.connectTimeout, this.socketTimeout);){
            this.deleteUdf(sqlWrapper, deploymentInfo.snowparkUdfName, null);
            this.deleteService(sqlWrapper, deploymentInfo.snowparkServiceName, null);
            this.deploymentInfoCRUDService.delete(this.deployment.infraId, this.deployment.id);
        }
        catch (DKUSecurityException e) {
            throw new IOException("Unable to connect to snowflake", e);
        }
    }

    @Override
    @Nonnull
    protected InfoMessage.InfoMessages doDeployment(@Nonnull DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Prepare sync of deployment %s", new Object[]{this.deployment.id});
        logger.info((Object)"Summary of the DSS resources used to update the deployment:");
        logger.infoV("Snowpark infra: %s", new Object[]{JSON.log((Object)this.infra)});
        logger.infoV("Snowpark deployment: %s", new Object[]{JSON.log((Object)this.deployment)});
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"api_deployer", (String)this.deployment.id, (boolean)true);){
            SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
            SnowflakeConnection connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
            if (connection == null) {
                throw ErrorContext.ice((String)"No connection defined in the infrastructure.");
            }
            try (SQLConnectionProvider.SQLConnectionWrapper sqlWrapper = SnowparkUtils.createSQLWrapper_NT(connection, this.authCtx, this.infra, this.connectTimeout, this.socketTimeout);){
                String endpointUrl;
                FutureProgress.AutocloseableFutureProgressState ignored;
                String udfName;
                SnowparkDetailedService service;
                if (!this.deployment.enabled) {
                    this.disableDeployment(sqlWrapper, deploymentInfo, logTailBuilder);
                    FutureProgress.incrementState((double)1.0);
                    InfoMessage.InfoMessages infoMessages = ret;
                    return infoMessages;
                }
                this.deployment.verifyPackageCompatibility(this.getPackageInfo_NT());
                SnowparkDeploymentLocalSummary localSummary = SnowparkDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
                this.createDeployerKeyIfAuthorizationToQueryThroughDeployer(this.deployment, ret);
                File contextDir = this.apiDeployerImageBuilderService.prepareDockerImageContext(this.authCtx, this.infra, this.deployment, this.deployment.getTargetId(), (File)tmpDir);
                HashMap<String, String> additionalEnv = new HashMap<String, String>();
                FutureProgress.incrementState((double)1.0);
                ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
                APIDeployerImageBuilderService.ImageNameTags imageNameTags = new APIDeployerImageBuilderService.ImageNameTags(this.infra, this.deployment, this.getVariablesContext());
                String buildMessage = "Building Docker image" + (DKUApp.isDataikuCloud() ? " and pushing it to registry" : "");
                try (FutureProgress.AutocloseableFutureProgressState ignored2 = FutureProgress.pushAutoCloseableState((String)buildMessage);){
                    if (DKUApp.isDataikuCloud()) {
                        this.apiDeployerImageBuilderService.executePrePushScript(this.authCtx, this.infra, imageNameTags, proxySettings, additionalEnv, logTailBuilder);
                        additionalEnv.putAll(this.apiDeployerImageBuilderService.getCraneAuthToken(this.infra.getRegistryHost(), additionalEnv));
                    }
                    this.apiDeployerImageBuilderService.buildDockerImage(this.infra, imageNameTags, logTailBuilder, this.rebuildCodeEnv, contextDir, additionalEnv);
                }
                FutureProgress.incrementState((double)1.0);
                if (!DKUApp.isDataikuCloud()) {
                    ignored2 = FutureProgress.pushAutoCloseableState((String)"Pushing image to repository");
                    try {
                        if (StringUtils.isBlank((String)this.getInfra().getRegistryHost())) {
                            throw ErrorContext.ice((String)"The 'Registry host' is not defined in the infrastructure settings.");
                        }
                        this.apiDeployerImageBuilderService.tagAndPushImage(this.authCtx, this.infra, logTailBuilder, imageNameTags, proxySettings, additionalEnv);
                    }
                    finally {
                        if (ignored2 != null) {
                            ignored2.close();
                        }
                    }
                }
                FutureProgress.incrementState((double)1.0);
                neverEverDeployed.remove(this.getDeployment().id);
                String containerImageUri = this.infra.getImageAliasInRegistryHost(imageNameTags.imageName, imageNameTags.imageVersion);
                try (FutureProgress.AutocloseableFutureProgressState ignored3 = FutureProgress.pushAutoCloseableState((String)"Creating Snowpark Service");){
                    logTailBuilder.appendLine("Creating/Updating Snowpark Service...");
                    service = this.createOrReplaceService(sqlWrapper, localSummary.service, connection, containerImageUri);
                    logTailBuilder.appendLine(String.format("Snowpark Service created/updated with name %s", service.name));
                }
                FutureProgress.incrementState((double)1.0);
                try (FutureProgress.AutocloseableFutureProgressState ignored4 = FutureProgress.pushAutoCloseableState((String)"Creating Snowpark UDF");){
                    logTailBuilder.appendLine("Creating/Updating Snowpark UDF...");
                    udfName = this.createOrReplaceUdf(sqlWrapper, service, localSummary.udfName);
                    logTailBuilder.appendLine(String.format("Snowpark UDF created/updated with name %s", udfName));
                }
                catch (Exception e) {
                    this.deleteServiceAfterFailure(sqlWrapper, service);
                    throw e;
                }
                FutureProgress.incrementState((double)1.0);
                try {
                    ignored = FutureProgress.pushAutoCloseableState((String)"Waiting for Snowpark endpoint to be ready");
                    try {
                        logTailBuilder.appendLine("Waiting for Snowpark endpoint to be ready...");
                        String string = service.name;
                        Objects.requireNonNull(service);
                        endpointUrl = SnowparkUtils.getPublicEndpointUrl_NT(sqlWrapper, string, "prediction-endpoint");
                        SnowparkUtils.waitABitUntilServiceIsReady_NT(sqlWrapper, service.name);
                        logTailBuilder.appendLine(String.format("Snowpark endpoint URL received: %s", endpointUrl));
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (Exception e) {
                    this.deleteUdfAfterFailure(sqlWrapper, udfName);
                    this.deleteServiceAfterFailure(sqlWrapper, service);
                    throw e;
                }
                FutureProgress.incrementState((double)1.0);
                ignored = FutureProgress.pushAutoCloseableState((String)"Saving changes");
                try {
                    logTailBuilder.appendLine("Updating deployment changes...");
                    SnowparkDeploymentInfo newDeploymentInfo = new SnowparkDeploymentInfo(this.infra, this.deployment, containerImageUri, service, udfName, endpointUrl);
                    this.deploymentInfoCRUDService.save(newDeploymentInfo);
                    logTailBuilder.appendLine(String.format("Changes saved for deployment with id %s.", this.deployment.id));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
                FutureProgress.incrementState((double)1.0);
            }
        }
        return ret;
    }

    @Override
    public APIServiceDeploymentHeavyStatus getStatus_Unsafe_NT(boolean withPackageExtraInfo, @Nullable String overridingConnectionName) throws IOException, InterruptedException, DKUSecurityException, URISyntaxException, AzureMLUtils.AzureAuthenticationException, SQLException {
        SnowparkDeploymentRemoteSummary remoteSummary;
        SnowflakeConnection connection;
        SnowparkDeploymentHeavyStatus status = new SnowparkDeploymentHeavyStatus(this.deployment.id, this.deployment.infraId);
        String usedConnection = overridingConnectionName != null ? overridingConnectionName : this.infra.authConnection;
        try {
            status.packages = this.publishedAPIServicesService.listPublishedPackages_Check_Unsafe_NT(this.deployment.publishedServiceId, this.authCtx);
            status.endpoints = status.summarizeEndpoints_NT(this.deployment, withPackageExtraInfo);
            connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, usedConnection);
        }
        catch (Exception e) {
            String message = "Unable to retrieve deployment status. Error is: " + e.getLocalizedMessage();
            logger.warn((Object)message, (Throwable)e);
            status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_ERROR, (String)message), DeploymentHealth.ERROR);
            return status;
        }
        if (connection == null) {
            String message = "No connection defined in the infrastructure.";
            logger.warn((Object)message);
            status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_INVALID_CONNECTION, (String)message), DeploymentHealth.ERROR);
            return status;
        }
        SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        SnowparkDeploymentLocalSummary localSummary = SnowparkDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        try (SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper = SnowparkUtils.createSQLWrapper_NT(connection, this.authCtx, this.infra, this.connectTimeout, this.socketTimeout);){
            remoteSummary = SnowparkDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, sqlConnectionWrapper);
        }
        catch (Exception e) {
            String message = "Unable to retrieve deployment status. Error is: " + e.getLocalizedMessage();
            logger.warn((Object)message, (Throwable)e);
            status.setMessageAndHealthWithSeverity(InfoMessage.error((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_ERROR, (String)message), DeploymentHealth.ERROR);
            return status;
        }
        status.checkEndpointHealth(localSummary, remoteSummary, this.deployment.enabled);
        return status;
    }

    @Override
    protected String diagnosisInternal(File tmpDir, String fileFriendlyLocalNow, FutureThreadBase<?> future) throws Exception {
        SnowparkDeploymentRemoteSummary remoteSummary;
        SnowflakeConnection connection;
        logger.infoV("Generating diagnostic of  %s...", new Object[]{this.deployment.id});
        SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        try {
            connection = (SnowflakeConnection)ExternalInfrasUtils.getAndCheckConnection(this.authCtx, this.infra.authConnection);
        }
        catch (DKUSecurityException e) {
            String message = "Error while accessing connection details";
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)(e.getCode() != null ? e.getCode() : DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_INVALID_CONNECTION), message, (Throwable)e);
        }
        if (connection == null) {
            throw ErrorContext.ice((String)"No connection defined in the infrastructure.");
        }
        JSON.prettyToFile((Object)this.deployment, (File)new File(tmpDir, "deployment.json"));
        JSON.prettyToFile((Object)deploymentInfo, (File)new File(tmpDir, "deployment-info.json"));
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.infoV("Diagnosis requested by a user with admin permissions on infra. Including %s configuration file.", new Object[]{"infra.json"});
            JSON.prettyToFile((Object)this.infra, (File)new File(tmpDir, "infra.json"));
        } else {
            logger.infoV("Diagnosis requested by a user without admin permissions on infra. Not including configuration file %s.", new Object[]{"infra.json"});
        }
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch summaries of Snowpark resources");
        SnowparkDeploymentLocalSummary localSummary = SnowparkDeploymentLocalSummary.buildFromLocalConfig(this.deployment, this.infra, this.getVariablesContext(), deploymentInfo);
        try (SQLConnectionProvider.SQLConnectionWrapper sqlWrapper = SnowparkUtils.createSQLWrapper_NT(connection, this.authCtx, this.infra, this.connectTimeout, this.socketTimeout);){
            remoteSummary = SnowparkDeploymentRemoteSummary.buildFromRemoteConfig_NT(deploymentInfo, sqlWrapper);
        }
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"Diagnosis requested by a user with admin permissions on infra. Including local and remote summary files.");
            JSON.prettyToFile((Object)localSummary, (File)new File(tmpDir, "local-summary.json"));
            JSON.prettyToFile((Object)remoteSummary, (File)new File(tmpDir, "remote-summary.json"));
        } else {
            logger.info((Object)"Diagnosis requested by a user without admin permissions on infra. Not including local and remote summary files.");
        }
        DeploymentStatusReport statusReport = this.getDeploymentStatusReporter().computeFullCheck(localSummary, remoteSummary, this.deployment.enabled);
        JSON.prettyToFile((Object)statusReport, (File)new File(tmpDir, "status-report.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        logger.info((Object)"Fetch versions");
        JsonObject versions = new JsonObject();
        versions.addProperty("dss-version", DKUApp.getDSSVersion().product_version);
        JSON.prettyToFile((Object)versions, (File)new File(tmpDir, "versions.json"));
        if (future.isAborted()) {
            throw new InterruptedException("Diagnosis aborted");
        }
        FutureProgress.incrementState((double)1.0);
        if (AbstractInfrasService.hasAdminPermission(this.infra, this.authCtx)) {
            logger.info((Object)"User has infra admin permissions ; adding deployment logs");
            File logsDir = DKUFileUtils.getWithin((File)tmpDir, (String[])new String[]{"deployment-logs"});
            DKUFileUtils.mkdirs((File)logsDir);
            for (Path path : this.apiServiceDeploymentsService.listLogFiles(this.deployment)) {
                FileUtils.copyFileToDirectory((File)path.toFile(), (File)logsDir);
            }
        } else {
            logger.info((Object)"User does not have infra admin permissions ; not adding deployment logs");
        }
        return tmpDir.getName();
    }

    @Nonnull
    private SnowparkDeploymentInfo getDeploymentInfo() throws IOException {
        SnowparkDeploymentInfo existingReferences = this.deploymentInfoCRUDService.get(this.getInfra().id, this.getDeployment().id, SnowparkDeploymentInfo.class);
        return (SnowparkDeploymentInfo)ObjectUtils.defaultIfNull((Object)existingReferences, (Object)new SnowparkDeploymentInfo(this.infra, this.deployment));
    }

    @Override
    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, APIServiceDeploymentHeavyStatus.EndpointSummary endpoint, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> allQueries, boolean forTest) throws IOException, DKUSecurityException, SQLException, InterruptedException {
        SnowparkDeploymentInfo deploymentInfo = this.getDeploymentInfo();
        return SnowparkLambdaAPIClient.runQueries_NT(this.authCtx, this.infra, deploymentInfo.snowparkUdfName, allQueries, forTest);
    }

    private SnowparkDetailedService createOrReplaceService(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable SnowparkService storedService, SnowflakeConnection connection, String containerImageUri) throws SQLException, IOException {
        if (storedService == null) {
            String serviceName;
            logger.debug((Object)"Snowpark Service name not found. Creating a new one.");
            String customServiceName = this.deployment.getCustomServiceName(this.infra);
            if (StringUtils.isNotBlank((String)customServiceName)) {
                serviceName = customServiceName;
                logger.debugV("Using customServiceName with value %s", new Object[]{serviceName});
            } else {
                serviceName = this.getConfigManager().generateDeploymentConfigName(255, "dss", SNOWFLAKE_RESOURCE_SEPARATOR, SNOWFLAKE_RESOURCE_SEPARATOR).toUpperCase();
                logger.debugV("New serviceName generated with value %s", new Object[]{serviceName});
            }
            return this.createService(sqlWrapper, connection, containerImageUri, serviceName);
        }
        String serviceName = storedService.name;
        logger.infoV("Service %s will be recreated. Deleting the old one then recreating a new one with same name.", new Object[]{serviceName});
        SnowparkUtils.dropService_NT(sqlWrapper, serviceName);
        return this.createService(sqlWrapper, connection, containerImageUri, serviceName);
    }

    @Nonnull
    private SnowparkDetailedService createService(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, SnowflakeConnection connection, String containerImageUri, String serviceName) throws SQLException, IOException {
        String databaseName = this.infra.getDatabaseName(connection);
        String schemaName = this.infra.getSchemaName(connection);
        if (StringUtils.isBlank((String)databaseName)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_DATABASE, "Database should be defined in the connection or in the infrastructure.");
        }
        if (StringUtils.isBlank((String)schemaName)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_SNOWPARK_MISSING_SCHEMA, "Schema should be defined in the connection or in the infrastructure.");
        }
        SnowparkDetailedService detailedService = SnowparkDataModelBuilder.buildDetailedService(this.deployment, this.infra, this.getVariablesContext(), serviceName, databaseName, schemaName, containerImageUri);
        String specification = this.getServiceSpecYaml(detailedService);
        logger.infoV("New Snowpark service YAML specification:\n%s", new Object[]{specification});
        this.verifyIfYamlIsValid(specification);
        SnowparkUtils.createService_NT(sqlWrapper, detailedService, specification);
        return SnowparkUtils.getService_NT(sqlWrapper, serviceName);
    }

    @Nonnull
    private String getServiceSpecYaml(SnowparkDetailedService detailedService) throws IOException {
        SnowparkDetailedService.YamlSpecHolder yamlSpecHolder = detailedService.createYamlSpecHolder();
        String unexpandedSpec = SnowparkYamlTemplateFiller.getSpecificationsFromTemplate(yamlSpecHolder.spec);
        VariablesContext vc = this.getVariablesContext();
        return vc.expandAllowUnresolved(unexpandedSpec);
    }

    private void verifyIfYamlIsValid(String yamlSpec) throws IllegalConfigurationException {
        Yaml yaml = new Yaml();
        try {
            yaml.load(yamlSpec);
        }
        catch (Exception e) {
            String message = "Snowpark service YAML is malformed. See logs.";
            logger.error((Object)message, (Throwable)e);
            throw ErrorContext.ice((String)message);
        }
    }

    private String createOrReplaceUdf(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nonnull SnowparkDetailedService service, @Nullable String storedUdfName) throws SQLException {
        if (StringUtils.isBlank((String)storedUdfName)) {
            String functionName;
            logger.debug((Object)"Snowpark UDF name not found. Creating a new one.");
            String customUdfName = this.deployment.getCustomUdfName(this.infra);
            if (StringUtils.isNotBlank((String)customUdfName)) {
                functionName = customUdfName;
                logger.debugV("Using custom Udf name with value %s", new Object[]{functionName});
            } else {
                functionName = this.deploymentConfigManager.generateUdfName(service.name);
                logger.debugV("New UDF name generated with value %s", new Object[]{functionName});
            }
            this.createUdf(sqlWrapper, service, functionName);
            return functionName;
        }
        logger.infoV("Udf %s will be recreated. Deleting the old one then recreating a new one with same name.", new Object[]{storedUdfName});
        SnowparkUtils.dropUdf_NT(sqlWrapper, storedUdfName);
        this.createUdf(sqlWrapper, service, storedUdfName);
        return storedUdfName;
    }

    private void createUdf(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nonnull SnowparkDetailedService service, @Nonnull String functionName) throws SQLException {
        String dssServiceId = this.deployment.basicInfoUnsafe().getDeployedItemId();
        String udfRoute = String.format("/public/api/v1/snowpark/%s/%s/predict", dssServiceId, this.deployment.endpointId);
        String string = service.name;
        Objects.requireNonNull(service);
        SnowparkUtils.createUdf_NT(sqlWrapper, functionName, string, "prediction-endpoint", udfRoute);
    }

    private void disableDeployment(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, SnowparkDeploymentInfo deploymentInfo, DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException, IOException {
        String disablingMessage = String.format("Deployment %s disabled, removing deployed service and UDF.", this.deployment.id);
        logger.info((Object)disablingMessage);
        logTailBuilder.appendLine(disablingMessage);
        this.deleteUdf(sqlWrapper, deploymentInfo.snowparkUdfName, logTailBuilder);
        this.deleteService(sqlWrapper, deploymentInfo.snowparkServiceName, logTailBuilder);
        logTailBuilder.appendLine("Saving deployment changes...");
        deploymentInfo.snowparkEndpointUrl = null;
        this.deploymentInfoCRUDService.save(deploymentInfo);
        logTailBuilder.appendLine(String.format("Changes saved for deployment %s.", this.deployment.id));
    }

    private void deleteService(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String serviceName, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        if (StringUtils.isBlank((String)serviceName)) {
            String noDeleteMessage = "No Snowpark service found so nothing to delete.";
            logger.info((Object)noDeleteMessage);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(noDeleteMessage);
            }
            return;
        }
        try {
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Deleting Snowpark service " + serviceName);
            }
            SnowparkUtils.dropService_NT(sqlWrapper, serviceName);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Snowpark service " + serviceName + " deleted.");
            }
        }
        catch (Exception e) {
            String message = String.format("Error deleting Snowpark service '%s' on the deployment '%s'.", serviceName, this.deployment.id);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(message);
            }
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteUdf(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nullable String udfName, @Nullable DKUtils.SmartLogTailBuilder logTailBuilder) throws CodedException {
        if (StringUtils.isBlank((String)udfName)) {
            String noDeleteMessage = "No Snowpark UDF found so nothing to delete.";
            logger.info((Object)noDeleteMessage);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(noDeleteMessage);
            }
            return;
        }
        try {
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Deleting Snowpark UDF " + udfName);
            }
            SnowparkUtils.dropUdf_NT(sqlWrapper, udfName);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine("Snowpark UDF " + udfName + " deleted.");
            }
        }
        catch (Exception e) {
            String message = String.format("Error deleting Snowpark UDF '%s' on the deployment '%s'.", udfName, this.deployment.id);
            if (logTailBuilder != null) {
                logTailBuilder.appendLine(message);
            }
            logger.error((Object)message, (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_FULLY_MANAGED_DELETE_RESOURCE, message + " " + e.getMessage());
        }
    }

    private void deleteServiceAfterFailure(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nonnull SnowparkDetailedService newService) {
        String newServiceName = newService.name;
        try {
            logger.debugV("Deployment failed. Deleting unused service %s", new Object[]{newServiceName});
            SnowparkUtils.dropService_NT(sqlWrapper, newServiceName);
            logger.debug((Object)"Service successfully deleted.");
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error deleting service %s", new Object[]{newServiceName});
        }
    }

    private void deleteUdfAfterFailure(SQLConnectionProvider.SQLConnectionWrapper sqlWrapper, @Nonnull String udfName) {
        try {
            logger.debugV("Deployment failed. Deleting unused UDF %s", new Object[]{udfName});
            SnowparkUtils.dropUdf_NT(sqlWrapper, udfName);
            logger.debug((Object)"UDF successfully deleted.");
        }
        catch (Exception rollbackException) {
            logger.errorV((Throwable)rollbackException, "Error deleting UDF %s", new Object[]{udfName});
        }
    }
}

