/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.deployer.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.deployer.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.Archive;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.Header;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdToolkit;
import org.rrd4j.core.Sample;

public class RrdUtils {
    public static final int STEP = 1;
    public static final double XFF = 0.999;
    public static final int RRD_METRIC_VERSION = 3;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.rrd");

    public static void createActivityMetricsRrdFile(File rrdFile, boolean forCopy) throws DKUSecurityException, IOException {
        ActivityMetric.Type[] metricsToCreate;
        PathUtils.ensurePathStaysWithinRoot((String)rrdFile.getAbsolutePath());
        DKUFileUtils.mkdirsParent((File)rrdFile);
        RrdDef rrdDef = new RrdDef(rrdFile.getAbsolutePath());
        int heartbeatInSeconds = DKUApp.getParams().getIntParam("dku.deployer.rrdHeartbeatInSeconds", Integer.valueOf(10800));
        rrdDef.setStep(1L);
        if (forCopy) {
            rrdDef.setStartTime(0L);
            metricsToCreate = ActivityMetric.Type.values();
        } else {
            rrdDef.setStartTime(Instant.now().minus(Duration.ofDays(1L)).getEpochSecond());
            metricsToCreate = ActivityMetric.Type.rrdMetrics.toArray(new ActivityMetric.Type[0]);
        }
        for (ActivityMetric.Type metricType : metricsToCreate) {
            rrdDef.addDatasource(metricType.getRrdFieldName(), DsType.GAUGE, (long)heartbeatInSeconds, 0.0, Double.MAX_VALUE);
        }
        for (MetricsAggregation aggregation : MetricsAggregation.activityMetricsAggregations) {
            rrdDef.addArchive(ConsolFun.AVERAGE, 0.999, (int)aggregation.getIntervalInSeconds() / 1, (int)(aggregation.getDurationInSeconds() / aggregation.getIntervalInSeconds()));
            rrdDef.addArchive(ConsolFun.TOTAL, 0.999, (int)aggregation.getIntervalInSeconds() / 1, (int)(aggregation.getDurationInSeconds() / aggregation.getIntervalInSeconds()));
        }
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());){
            try (RrdDb rrdDb = RrdDb.of((RrdDef)rrdDef);){
                if (!forCopy) {
                    logger.infoV("Activity file created: " + rrdFile.getAbsolutePath(), new Object[0]);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Can't create activity file: " + rrdFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    public static int getRrdActivityMetricsVersion_NT(File rrdFile) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());){
            int n;
            block12: {
                RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());
                try {
                    n = RrdUtils.getRrdActivityMetricsVersion(rrdDb);
                    if (rrdDb == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rrdDb != null) {
                        try {
                            rrdDb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rrdDb.close();
            }
            return n;
        }
    }

    private static int getRrdActivityMetricsVersion(RrdDb rrdDb) throws IOException {
        if (rrdDb.containsDs(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS.getRrdFieldName()) && rrdDb.containsDs(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName())) {
            return 3;
        }
        if (rrdDb.containsDs(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName())) {
            return 2;
        }
        return 1;
    }

    public static void updateActivityRrdFile_NT(File rrdFile) throws DKUSecurityException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());){
            Set<String> existingMetrics;
            File backupRrdFile = new File(String.format("%s.bak", rrdFile.getAbsolutePath()));
            logger.infoV("Updating RRD file '%s' to take into account new fields. Creating backup at '%s'", new Object[]{rrdFile.getAbsolutePath(), backupRrdFile.getAbsolutePath()});
            if (backupRrdFile.exists()) {
                logger.warnV("Backup RRD file '%s' already exists, deleting it to start the update anew from '%s'", new Object[]{backupRrdFile.getAbsolutePath(), rrdFile.getAbsolutePath()});
                FileUtils.forceDelete((File)backupRrdFile);
            }
            FileUtils.copyFile((File)rrdFile, (File)backupRrdFile);
            int rrdFileVersion = 0;
            try (RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());){
                existingMetrics = Arrays.stream(rrdDb.getDsNames()).collect(Collectors.toSet());
                rrdFileVersion = RrdUtils.getRrdActivityMetricsVersion(rrdDb);
            }
            logger.infoV("Updating RRD file '%s' from v%s to v%s", new Object[]{rrdFile.getAbsolutePath(), rrdFileVersion, 3});
            if (rrdFileVersion < 2) {
                RrdUtils.migrateV1ToV2(rrdFile, existingMetrics);
            }
            if (rrdFileVersion < 3) {
                RrdUtils.migrateV2ToV3(rrdFile);
            }
            FileUtils.forceDelete((File)backupRrdFile);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Could not update the RRD file '%s'. Backup file was kept. Creating a new empty RRD file at '%s'", new Object[]{rrdFile.getAbsolutePath(), rrdFile.getAbsolutePath()});
            RrdUtils.createActivityMetricsRrdFile(rrdFile, false);
        }
    }

    private static void migrateV1ToV2(File rrdFile, Set<String> existingMetrics) throws IOException {
        if (!existingMetrics.contains(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName())) {
            logger.infoV("Updating RRD file '%s'. Will add metrics: %s", new Object[]{rrdFile.getAbsolutePath(), ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST});
            int heartbeatInSeconds = DKUApp.getParams().getIntParam("dku.deployer.rrdHeartbeatInSeconds", Integer.valueOf(10800));
            DsDef p95Ds = new DsDef(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName(), DsType.GAUGE, (long)heartbeatInSeconds, 0.0, Double.MAX_VALUE);
            RrdToolkit.addDatasource((String)rrdFile.getAbsolutePath(), (DsDef)p95Ds, (boolean)false);
        }
    }

    private static void migrateV2ToV3(File rrdFile) throws IOException, DKUSecurityException {
        int oldStep = 60;
        int newStep = 1;
        File newRrdFile = new File(String.format("%s.new", rrdFile.getAbsolutePath()));
        if (newRrdFile.exists()) {
            FileUtils.forceDelete((File)newRrdFile);
        }
        RrdUtils.createActivityMetricsRrdFile(newRrdFile, true);
        try (RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());
             RrdDb newRrdDb = RrdDb.of((String)newRrdFile.getAbsolutePath());){
            Field robinsFromArc = Archive.class.getDeclaredField("robins");
            robinsFromArc.setAccessible(true);
            Method setHeaderLastUpdateTime = Header.class.getDeclaredMethod("setLastUpdateTime", Long.TYPE);
            setHeaderLastUpdateTime.setAccessible(true);
            int ratesIndex = newRrdDb.getDsIndex(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
            int errorIndex = newRrdDb.getDsIndex(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
            int avgLatencyIndex = newRrdDb.getDsIndex(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName());
            int avgP95Index = newRrdDb.getDsIndex(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName());
            int totalLatencyIndex = newRrdDb.getDsIndex(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS.getRrdFieldName());
            int totalP95Index = newRrdDb.getDsIndex(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName());
            long oldLastUpdateTime = rrdDb.getLastUpdateTime();
            setHeaderLastUpdateTime.invoke((Object)newRrdDb.getHeader(), oldLastUpdateTime);
            for (MetricsAggregation aggregation : MetricsAggregation.activityMetricsAggregations) {
                int oldAvgArcIndex = rrdDb.getArcIndex(ConsolFun.AVERAGE, (int)aggregation.getIntervalInSeconds() / oldStep);
                Archive oldAvgArc = rrdDb.getArchive(oldAvgArcIndex);
                Robin[] oldAvgRobins = (Robin[])robinsFromArc.get(oldAvgArc);
                Robin oldRatesRobin = oldAvgRobins[ratesIndex];
                Robin oldErrorsRobin = oldAvgRobins[errorIndex];
                Robin oldAvgLatencyRobin = oldAvgRobins[avgLatencyIndex];
                Robin oldAvgP95Robin = oldAvgRobins[avgP95Index];
                double[] oldRates = oldRatesRobin.getValues();
                double[] oldErrors = oldErrorsRobin.getValues();
                double[] oldAvgLatencies = oldAvgLatencyRobin.getValues();
                double[] oldAvgP95s = oldAvgP95Robin.getValues();
                int newAvgArcIndex = newRrdDb.getArcIndex(ConsolFun.AVERAGE, (int)aggregation.getIntervalInSeconds() / newStep);
                Archive newAvgArc = newRrdDb.getArchive(newAvgArcIndex);
                Robin[] newAvgRobins = (Robin[])robinsFromArc.get(newAvgArc);
                Robin newRatesRobin = newAvgRobins[ratesIndex];
                Robin newErrorsRobin = newAvgRobins[errorIndex];
                Robin newAvgLatencyRobin = newAvgRobins[avgLatencyIndex];
                Robin newAvgP95Robin = newAvgRobins[avgP95Index];
                newRatesRobin.update(oldRates);
                newErrorsRobin.update(oldErrors);
                newAvgLatencyRobin.update(oldAvgLatencies);
                newAvgP95Robin.update(oldAvgP95s);
                int totalArcIndex = newRrdDb.getArcIndex(ConsolFun.TOTAL, (int)aggregation.getIntervalInSeconds() / newStep);
                Archive totalArc = newRrdDb.getArchive(totalArcIndex);
                Robin[] robins = (Robin[])robinsFromArc.get(totalArc);
                Robin totalLatencyRobin = robins[totalLatencyIndex];
                Robin totalP95Robin = robins[totalP95Index];
                double[] totalLatencies = new double[oldRates.length];
                double[] totalP95 = new double[oldRates.length];
                for (int i = 0; i < oldRates.length; ++i) {
                    double rateOrZero = Double.isNaN(oldRates[i]) ? 0.0 : oldRates[i];
                    double volumeOverAStepOrZero = rateOrZero * (double)aggregation.getIntervalInSeconds();
                    double oldAverageOrZero = Double.isNaN(oldAvgLatencies[i]) ? 0.0 : oldAvgLatencies[i];
                    double oldP95OrZero = Double.isNaN(oldAvgP95s[i]) ? 0.0 : oldAvgP95s[i];
                    totalLatencies[i] = oldAverageOrZero * volumeOverAStepOrZero;
                    totalP95[i] = oldP95OrZero * volumeOverAStepOrZero;
                }
                totalLatencyRobin.update(totalLatencies);
                totalP95Robin.update(totalP95);
            }
        }
        catch (Exception e1) {
            logger.warnV((Throwable)e1, "Could not migrate %s using reflection. Trying with a slower method. This will be slow, expect ~10s per file.", new Object[]{rrdFile.getAbsolutePath()});
            if (newRrdFile.exists()) {
                FileUtils.forceDelete((File)newRrdFile);
            }
            RrdUtils.createActivityMetricsRrdFile(newRrdFile, true);
            long now = System.currentTimeMillis() / 1000L;
            try (RrdDb rrdDb2 = RrdDb.of((String)rrdFile.getAbsolutePath());
                 RrdDb newRrdDb2 = RrdDb.of((String)newRrdFile.getAbsolutePath());){
                List aggregationsDecreasing = Arrays.stream(MetricsAggregation.values()).sorted((a1, a2) -> (int)(a2.getDurationInSeconds() - a1.getDurationInSeconds())).collect(Collectors.toList());
                for (int aggregationIndex = 0; aggregationIndex <= aggregationsDecreasing.size() - 1; ++aggregationIndex) {
                    MetricsAggregation aggregation = (MetricsAggregation)((Object)aggregationsDecreasing.get(aggregationIndex));
                    long lastTimestampToFetch = aggregation == MetricsAggregation.ONE_MINUTE_FOR_A_WEEK ? now : now - ((MetricsAggregation)((Object)aggregationsDecreasing.get(aggregationIndex + 1))).getDurationInSeconds();
                    FetchData averages = rrdDb2.createFetchRequest(ConsolFun.AVERAGE, now - aggregation.getDurationInSeconds(), lastTimestampToFetch, aggregation.getIntervalInSeconds()).fetchData();
                    long[] timestamps = averages.getTimestamps();
                    double[] rates = averages.getValues(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
                    double[] errors = averages.getValues(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S.getRrdFieldName());
                    double[] oldLatencies = averages.getValues(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName());
                    double[] oldP95s = averages.getValues(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName());
                    for (int i = 0; i < timestamps.length - 1; ++i) {
                        Sample sample = newRrdDb2.createSample(timestamps[i]);
                        double rateOrZero = Double.isNaN(rates[i]) ? 0.0 : rates[i];
                        double volumeOverAStepOrZero = rateOrZero * 1.0;
                        double oldAverageOrZero = Double.isNaN(oldLatencies[i]) ? 0.0 : oldLatencies[i];
                        double oldP95OrZero = Double.isNaN(oldP95s[i]) ? 0.0 : oldP95s[i];
                        sample.setValue(ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName(), rateOrZero);
                        sample.setValue(ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S.getRrdFieldName(), errors[i]);
                        sample.setValue(ActivityMetric.Type.TOTAL_PROCESSING_TIME_IN_MS.getRrdFieldName(), oldAverageOrZero * volumeOverAStepOrZero);
                        sample.setValue(ActivityMetric.Type.TOTAL_P95_PROCESSING_TIME_IN_MS.getRrdFieldName(), oldP95OrZero * volumeOverAStepOrZero);
                        sample.setValue(ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName(), oldAverageOrZero);
                        sample.setValue(ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName(), oldP95OrZero);
                        try {
                            sample.update();
                            continue;
                        }
                        catch (Exception e) {
                            if (e.getClass() == IllegalArgumentException.class && e.getMessage().startsWith("Bad sample time")) continue;
                            logger.warnV((Throwable)e, "Couldn't write activity metrics to file %s for time %d", new Object[]{rrdFile.getAbsolutePath(), timestamps[i]});
                        }
                    }
                }
            }
        }
        FileUtils.forceDelete((File)rrdFile);
        FileUtils.moveFile((File)newRrdFile, (File)rrdFile);
    }
}

