/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.actual;

import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.AzureMLDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.DatabricksDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.SageMakerDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.SnowparkDeploymentInfo;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.VertexAIDeploymentInfo;
import com.dataiku.dip.deployer.common.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PolyJSON(value={@Mapping(type="AZURE_ML", value=AzureMLDeploymentBasicInfo.class), @Mapping(type="DATABRICKS", value=DatabricksDeploymentBasicInfo.class), @Mapping(type="SAGEMAKER", value=SageMakerDeploymentBasicInfo.class), @Mapping(type="SNOWPARK", value=SnowparkDeploymentBasicInfo.class), @Mapping(type="VERTEX_AI", value=VertexAIDeploymentBasicInfo.class), @Mapping(type="API_SERVICE", value=APIServiceDeploymentBasicInfo.class), @Mapping(type="PROJECT", value=ProjectDeploymentBasicInfo.class)})
public abstract class AbstractDeploymentBasicInfo {
    public String id;
    public String infraId;
    public Set<String> tags;
    public VersionTag creationTag;
    public String createdByDisplayName;
    public VersionTag versionTag;
    public String lastModifiedByDisplayName;
    public VersionTag deploymentTag;
    public String deployedByDisplayName;
    public List<TypeBadge> typeBadges = new ArrayList<TypeBadge>();

    public abstract String getDeployedItemId();

    public String getId() {
        return this.id;
    }

    public static class VertexAIDeploymentBasicInfo
    extends FullyManagedDeploymentBasicInfo<VertexAIDeploymentInfo> {
    }

    public static class SnowparkDeploymentBasicInfo
    extends FullyManagedDeploymentBasicInfo<SnowparkDeploymentInfo> {
    }

    public static class SageMakerDeploymentBasicInfo
    extends FullyManagedDeploymentBasicInfo<SageMakerDeploymentInfo> {
    }

    public static class DatabricksDeploymentBasicInfo
    extends FullyManagedDeploymentBasicInfo<DatabricksDeploymentInfo> {
    }

    public static class AzureMLDeploymentBasicInfo
    extends FullyManagedDeploymentBasicInfo<AzureMLDeploymentInfo> {
    }

    public static abstract class FullyManagedDeploymentBasicInfo<T extends AbstractDeploymentInfo>
    extends AbstractAPIServiceDeploymentBasicInfo {
        public T deploymentInfo;
        @Nullable
        public String endpointId;
    }

    public static class APIServiceDeploymentBasicInfo
    extends AbstractAPIServiceDeploymentBasicInfo {
    }

    public static abstract class AbstractAPIServiceDeploymentBasicInfo
    extends AbstractDeploymentBasicInfo {
        public boolean enabled;
        public GenerationsMapping generationsMapping;
        public String publishedServiceId;
        public String deployedServiceId;

        @Override
        public String getDeployedItemId() {
            return StringUtils.isBlank((String)this.deployedServiceId) ? this.publishedServiceId : this.deployedServiceId;
        }
    }

    public static class ProjectDeploymentBasicInfo
    extends AbstractDeploymentBasicInfo {
        public String bundleId;
        public String publishedProjectKey;
        @Nullable
        public String deployedProjectKey;
        public String deployedAsDisplayName;

        @Override
        public String getDeployedItemId() {
            return StringUtils.isBlank((String)this.deployedProjectKey) ? this.publishedProjectKey : this.deployedProjectKey;
        }
    }

    public static class DeploymentBasicInfoList {
        public List<? extends AbstractDeploymentBasicInfo> deployments;
    }
}

