/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.actual;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.deployer.projectdeployer.deployments.AbstractProjectDeploymentManager;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.OAuth2Config;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

@PartOfPublicAPI
public abstract class AbstractDeploymentLightStatus {
    public AbstractInfraBasicInfo infraBasicInfo;
    public AbstractDeploymentBasicInfo deploymentBasicInfo;
    public List<PublishedPackageInfo> packages;
    private boolean neverEverDeployed;
    public boolean hasFullDeployPermissions;
    public boolean isInfraAdmin;
    public List<TypeBadge> typeBadges;

    AbstractDeploymentLightStatus(AbstractDeploymentBasicInfo deploymentBasicInfo, AbstractInfraBasicInfo infraBasicInfo, List<PublishedPackageInfo> packageInfoList, boolean neverEverDeployed, boolean hasFullDeployPermissions, boolean isInfraAdmin) {
        this.infraBasicInfo = infraBasicInfo;
        this.deploymentBasicInfo = deploymentBasicInfo;
        this.packages = packageInfoList;
        this.neverEverDeployed = neverEverDeployed;
        this.hasFullDeployPermissions = hasFullDeployPermissions;
        this.isInfraAdmin = isInfraAdmin;
        this.typeBadges = deploymentBasicInfo.typeBadges;
    }

    public AbstractDeploymentBasicInfo getDeploymentBasicInfo() {
        return this.deploymentBasicInfo;
    }

    @UIModel
    @PartOfPublicAPI
    public static class ProjectDeploymentLightStatus
    extends AbstractDeploymentLightStatus {
        AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo projectBasicInfo;

        public ProjectDeploymentLightStatus(AbstractDeploymentBasicInfo deploymentBasicInfo, AbstractInfraBasicInfo infraBasicInfo, List<PublishedPackageInfo> packageInfoList, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo projectBasicInfo, boolean hasFullDeployPermissions, boolean isInfraAdmin) {
            super(deploymentBasicInfo, infraBasicInfo, packageInfoList, AbstractProjectDeploymentManager.neverEverDeployed.contains(deploymentBasicInfo.id), hasFullDeployPermissions, isInfraAdmin);
            this.projectBasicInfo = projectBasicInfo;
        }
    }

    public static class APIServiceDeploymentLightStatusInherited {
        public LambdaAuthMethod authMethod;
        public List<APIServiceDeploymentLightStatus.APIKeyBasicInfo> apiKeys;
        public OAuth2Config oauth2Config;
    }

    @UIModel
    @PartOfPublicAPI
    public static class APIServiceDeploymentLightStatus
    extends AbstractDeploymentLightStatus {
        AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo serviceBasicInfo;
        public LambdaAuthMethod authMethod;
        public List<APIKeyBasicInfo> apiKeys;
        public OAuth2Config oauth2Config;
        public APIServiceDeploymentLightStatusInherited authorizationInherited;

        public APIServiceDeploymentLightStatus(AbstractDeploymentBasicInfo deploymentBasicInfo, AbstractInfraBasicInfo infraBasicInfo, List<PublishedPackageInfo> packageInfoList, boolean neverEverDeployed, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo serviceBasicInfo, boolean hasFullDeployPermissions, boolean isInfraAdmin) {
            super(deploymentBasicInfo, infraBasicInfo, packageInfoList, neverEverDeployed, hasFullDeployPermissions, isInfraAdmin);
            this.serviceBasicInfo = serviceBasicInfo;
            this.apiKeys = new ArrayList<APIKeyBasicInfo>();
        }

        public boolean isSingleGeneration() {
            GenerationsMapping generationsMapping = ((AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)this.deploymentBasicInfo).generationsMapping;
            return GenerationsMapping.GenerationsMappingMode.SINGLE_GENERATION.equals((Object)generationsMapping.getMode());
        }

        public BundledSMVersion getSMVersion(String endpointId) {
            Preconditions.checkArgument((boolean)this.isSingleGeneration(), (Object)"The deployment must be with a single generation mode.");
            GenerationsMapping generationsMapping = ((AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)this.deploymentBasicInfo).generationsMapping;
            List<GenerationsMapping.MappingEntry> entries = generationsMapping.getEntries();
            String serviceVersionId = entries.get((int)0).generation;
            PublishedPackageInfo publishedPackageInfo = this.packages.stream().filter(pkg -> serviceVersionId.equals(pkg.id)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No package was found with service version id %s", serviceVersionId)));
            LambdaEndpointConfig lambdaEndpointConfig = ((PublishedApiServicePackageInfo)publishedPackageInfo).endpoints.stream().filter(endpoint -> endpointId.equals(endpoint.id)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No endpoint with id %s was found in the published package information", endpointId)));
            if (!(lambdaEndpointConfig instanceof PredictionEndpointConfig)) {
                throw new IllegalArgumentException(String.format("The endpoint %s is not a prediction endpoint. %s endpoints are not supported for automated monitoring", new Object[]{endpointId, lambdaEndpointConfig.type}));
            }
            String smId = ((PredictionEndpointConfig)lambdaEndpointConfig).modelId;
            return ((PublishedApiServicePackageInfo)publishedPackageInfo).stdModels.stream().filter(stdModel -> smId.equals(stdModel.id)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No saved model version was found for the model %s in the published package", smId)));
        }

        public static class APIKeyBasicInfo {
            public String label;
            public String key;
        }
    }
}

