/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.datamodel.actual;

import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PolyJSON(value={@Mapping(type="STATIC", value=StaticAPIDeploymentInfraBasicInfo.class), @Mapping(type="K8S", value=K8SAPIDeploymentInfraBasicInfo.class), @Mapping(type="AZURE_ML", value=AzureMLAPIDeploymentInfraBasicInfo.class), @Mapping(type="DATABRICKS", value=DatabricksAPIDeploymentInfraBasicInfo.class), @Mapping(type="SAGEMAKER", value=SageMakerAPIDeploymentInfraBasicInfo.class), @Mapping(type="SNOWPARK", value=SnowparkAPIDeploymentInfraBasicInfo.class), @Mapping(type="VERTEX_AI", value=VertexAIAPIDeploymentInfraBasicInfo.class), @Mapping(type="AUTOMATION_NODE", value=SingleAutomationNodeInfraBasicInfo.class), @Mapping(type="MULTI_AUTOMATION_NODE", value=MultiAutomationNodeInfraBasicInfo.class)})
public abstract class AbstractInfraBasicInfo {
    public String id;
    public String stage;
    public AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy;
    public final boolean canListHeavyStatus;

    protected AbstractInfraBasicInfo() {
        this.canListHeavyStatus = false;
    }

    protected AbstractInfraBasicInfo(boolean canListHeavyStatus) {
        this.canListHeavyStatus = canListHeavyStatus;
    }

    protected AbstractInfraBasicInfo(AbstractDeploymentInfra infra, boolean canListHeavyStatus) {
        this.id = infra.id;
        this.stage = infra.stage;
        this.governCheckPolicy = infra.governCheckPolicy;
        this.canListHeavyStatus = canListHeavyStatus;
    }

    public abstract AbstractDeploymentInfra.InfraType getInfraType();

    public String getId() {
        return this.id;
    }

    public String getStage() {
        return this.stage;
    }

    @UIModel
    public static class DeploymentInfraBasicInfoList {
        public List<? extends AbstractInfraBasicInfo> infras;
    }

    public static class MultiAutomationNodeInfraBasicInfo
    extends AbstractProjectDeploymentInfraBasicInfo {
        List<AutomationNodeBasicInfo> automationNodes = new ArrayList<AutomationNodeBasicInfo>();
        String loadBalancerResourceUrl;

        private MultiAutomationNodeInfraBasicInfo() {
        }

        public MultiAutomationNodeInfraBasicInfo(MultiAutomationNodeInfra infra) {
            super(infra);
            if (infra.autoconfigureFromNodesDirectory) {
                this.loadBalancerResourceUrl = infra.loadBalancerResourceUrl;
            }
            infra.getOptionalNodeConnections().forEach((automationNodeId, nodeConnectionOptional) -> {
                if (nodeConnectionOptional.isPresent()) {
                    NodeConnection nodeConnection = (NodeConnection)nodeConnectionOptional.get();
                    String extUrl = nodeConnection.externalUrl == null ? nodeConnection.url : nodeConnection.externalUrl;
                    this.automationNodes.add(new AutomationNodeBasicInfo((String)automationNodeId, nodeConnection.url, extUrl, nodeConnection.nodeDirectoryStatus));
                } else {
                    this.automationNodes.add(new AutomationNodeBasicInfo((String)automationNodeId, "", "", null));
                    DKULogger.getLogger((String)"dku.apideployer.infra").warn((Object)("Invalid node configuration for automation node " + automationNodeId));
                }
            });
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.MULTI_AUTOMATION_NODE;
        }
    }

    public static class AutomationNodeBasicInfo {
        final String automationNodeId;
        final String automationNodeUrl;
        final String automationNodeExternalUrl;
        final NodesDirectory.NodeStatus status;

        public AutomationNodeBasicInfo(String automationNodeId, String automationNodeUrl, String automationNodeExternalUrl, NodesDirectory.NodeStatus status) {
            this.automationNodeId = automationNodeId;
            this.automationNodeUrl = automationNodeUrl;
            this.automationNodeExternalUrl = automationNodeExternalUrl;
            this.status = status;
        }
    }

    public static class SingleAutomationNodeInfraBasicInfo
    extends AbstractProjectDeploymentInfraBasicInfo {
        String automationNodeUrl;
        String automationNodeExternalUrl;

        private SingleAutomationNodeInfraBasicInfo() {
        }

        public SingleAutomationNodeInfraBasicInfo(SingleAutomationNodeInfra infra) {
            super(infra);
            try {
                NodeConnection nodeConnection = infra.getConnectionInfo();
                if (nodeConnection != null) {
                    this.automationNodeUrl = nodeConnection.url;
                    String extUrl = nodeConnection.externalUrl;
                    this.automationNodeExternalUrl = extUrl == null ? this.automationNodeUrl : extUrl;
                } else {
                    this.automationNodeUrl = "";
                    this.automationNodeExternalUrl = "";
                }
            }
            catch (IllegalArgumentException e) {
                this.automationNodeUrl = "";
                this.automationNodeExternalUrl = "";
                DKULogger.getLogger((String)"dku.apideployer.infra").warn((Object)"Invalid node configuration", (Throwable)e);
            }
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.AUTOMATION_NODE;
        }
    }

    public static abstract class AbstractProjectDeploymentInfraBasicInfo
    extends AbstractInfraBasicInfo {
        List<ProjectRemappingSettings.ConnectionRemapping> defaultConnectionRemapping;
        List<ProjectRemappingSettings.ContainerExecRemapping> defaultContainerExecRemapping;
        public boolean enableContainerExecRemapping;
        public boolean setDeployAsUser;
        public boolean mandatoryDeployAsUser;
        public boolean overrideRunAsUser;
        public AbstractProjectDeploymentInfra.ProjectStandardsPolicy projectStandardsPolicy;

        protected AbstractProjectDeploymentInfraBasicInfo() {
        }

        protected AbstractProjectDeploymentInfraBasicInfo(AbstractProjectDeploymentInfra infra) {
            super(infra, false);
            this.defaultConnectionRemapping = infra.defaultConnectionRemapping == null ? ImmutableList.of() : ImmutableList.copyOf(infra.defaultConnectionRemapping);
            this.defaultContainerExecRemapping = infra.defaultContainerExecRemapping == null ? ImmutableList.of() : ImmutableList.copyOf(infra.defaultContainerExecRemapping);
            this.enableContainerExecRemapping = infra.enableContainerExecRemapping;
            this.setDeployAsUser = infra.setDeployAsUser;
            this.mandatoryDeployAsUser = infra.mandatoryDeployAsUser;
            this.overrideRunAsUser = infra.overrideRunAsUser;
            this.projectStandardsPolicy = infra.projectStandardsPolicy;
        }
    }

    public static class VertexAIAPIDeploymentInfraBasicInfo
    extends FullyManagedAPIDeploymentInfraBasicInfo {
        boolean allowOverrideEndpointId;

        private VertexAIAPIDeploymentInfraBasicInfo() {
            super(true);
        }

        public VertexAIAPIDeploymentInfraBasicInfo(VertexAIAPIDeploymentInfra infra) {
            super(infra, true);
            this.allowOverrideEndpointId = infra.allowOverrideEndpointId;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.VERTEX_AI;
        }
    }

    public static class SnowparkAPIDeploymentInfraBasicInfo
    extends FullyManagedAPIDeploymentInfraBasicInfo {
        boolean allowOverrideResourcesNames;

        private SnowparkAPIDeploymentInfraBasicInfo() {
            super(false);
        }

        public SnowparkAPIDeploymentInfraBasicInfo(SnowparkAPIDeploymentInfra infra) {
            super(infra, false);
            this.allowOverrideResourcesNames = infra.allowOverrideResourcesNames;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.SNOWPARK;
        }

        @Override
        public boolean isActivityMonitoringSupported() {
            return false;
        }
    }

    public static class SageMakerAPIDeploymentInfraBasicInfo
    extends FullyManagedAPIDeploymentInfraBasicInfo {
        boolean allowOverrideEndpointName;
        AbstractFullyManagedAPIDeploymentInfra.EndpointType endpointType;

        private SageMakerAPIDeploymentInfraBasicInfo() {
            super(true);
        }

        public SageMakerAPIDeploymentInfraBasicInfo(SageMakerAPIDeploymentInfra infra) {
            super(infra, true);
            this.allowOverrideEndpointName = infra.allowOverrideEndpointName;
            this.endpointType = infra.endpointType;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.SAGEMAKER;
        }
    }

    public static class DatabricksAPIDeploymentInfraBasicInfo
    extends FullyManagedAPIDeploymentInfraBasicInfo {
        boolean allowOverrideEndpointName;
        boolean allowOverrideUnityCatalogSettings;
        boolean usesUnityCatalog;
        @Nullable
        String defaultExperimentLocation;
        @Nullable
        String defaultCatalogName;
        @Nullable
        String defaultSchemaName;

        private DatabricksAPIDeploymentInfraBasicInfo() {
            super(true);
        }

        public DatabricksAPIDeploymentInfraBasicInfo(DatabricksAPIDeploymentInfra infra) {
            super(infra, true);
            this.allowOverrideEndpointName = infra.allowOverrideEndpointName;
            this.allowOverrideUnityCatalogSettings = infra.allowOverrideUnityCatalogSettings;
            this.usesUnityCatalog = infra.usesUnityCatalog;
            this.defaultExperimentLocation = infra.defaultExperimentLocation;
            this.defaultCatalogName = infra.defaultCatalogName;
            this.defaultSchemaName = infra.defaultSchemaName;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.DATABRICKS;
        }
    }

    public static class AzureMLAPIDeploymentInfraBasicInfo
    extends FullyManagedAPIDeploymentInfraBasicInfo {
        boolean allowOverrideEndpointName;

        private AzureMLAPIDeploymentInfraBasicInfo() {
            super(true);
        }

        public AzureMLAPIDeploymentInfraBasicInfo(AzureMLAPIDeploymentInfra infra) {
            super(infra, true);
            this.allowOverrideEndpointName = infra.allowOverrideEndpointName;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.AZURE_ML;
        }
    }

    public static abstract class FullyManagedAPIDeploymentInfraBasicInfo
    extends AbstractAPIDockerDeploymentInfraBasicInfo {
        boolean allowOverrideSizeAndScaling;
        boolean allowOverrideTags;
        @Nullable
        String connectionName;

        FullyManagedAPIDeploymentInfraBasicInfo(boolean canListHeavyStatus) {
            super(canListHeavyStatus);
        }

        FullyManagedAPIDeploymentInfraBasicInfo(AbstractFullyManagedAPIDeploymentInfra infra, boolean canListHeavyStatus) {
            super(infra, canListHeavyStatus);
            this.allowOverrideSizeAndScaling = infra.allowOverrideSizeAndScaling;
            this.allowOverrideTags = infra.allowOverrideTags;
            this.connectionName = infra.authConnection;
        }
    }

    public static class StaticAPIDeploymentInfraBasicInfo
    extends AbstractAPIDeploymentInfraBasicInfo {
        List<APINodeBasicInfo> apiNodeUrls = new ArrayList<APINodeBasicInfo>();

        private StaticAPIDeploymentInfraBasicInfo() {
        }

        public StaticAPIDeploymentInfraBasicInfo(StaticAPIDeploymentInfra infra) {
            super(infra, false);
            for (StaticAPIDeploymentInfra.APINodeRef node : infra.apiNodes) {
                this.apiNodeUrls.add(new APINodeBasicInfo(node.url, node.externalUrl));
            }
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.STATIC;
        }
    }

    public static class APINodeBasicInfo {
        public String url;
        public String externalUrl;

        public APINodeBasicInfo(String url, @Nullable String externalUrl) {
            this.url = url;
            this.externalUrl = externalUrl;
        }
    }

    public static class K8SAPIDeploymentInfraBasicInfo
    extends AbstractAPIDockerDeploymentInfraBasicInfo {
        public String k8sContext;
        public String k8sNamespace = "default";
        public String k8sConfigPath;
        public List<SimpleKeyValue> k8sProperties = new ArrayList<SimpleKeyValue>();
        public boolean allowAdditionalEnvVarsInDeployments;
        public boolean allowAdditionalLabelsInDeployments;
        public boolean allowAdditionalAnnotationsInDeployments;
        public boolean allowOverridingServiceAccountNameInDeployments;

        private K8SAPIDeploymentInfraBasicInfo() {
        }

        public K8SAPIDeploymentInfraBasicInfo(K8SAPIDeploymentInfra infra) {
            super(infra, false);
            this.k8sContext = infra.k8sContext;
            this.k8sNamespace = infra.getK8sNamespace();
            this.k8sConfigPath = infra.k8sConfigPath;
            this.k8sProperties = infra.k8sProperties;
            this.allowAdditionalEnvVarsInDeployments = infra.allowAdditionalEnvVarsInDeployments;
            this.allowAdditionalLabelsInDeployments = infra.allowAdditionalLabelsInDeployments;
            this.allowAdditionalAnnotationsInDeployments = infra.allowAdditionalAnnotationsInDeployments;
            this.allowOverridingServiceAccountNameInDeployments = infra.allowOverridingServiceAccountNameInDeployments;
        }
    }

    public static abstract class AbstractAPIDockerDeploymentInfraBasicInfo
    extends AbstractAPIDeploymentInfraBasicInfo {
        public String baseImageTag;
        public ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.NONE;
        public String prePushScript;
        boolean buildIntermediateImageWithCodeEnvs;

        private AbstractAPIDockerDeploymentInfraBasicInfo() {
        }

        private AbstractAPIDockerDeploymentInfraBasicInfo(boolean canListHeavyStatus) {
            super(canListHeavyStatus);
        }

        protected AbstractAPIDockerDeploymentInfraBasicInfo(AbstractAPIDockerDeploymentInfra infra, boolean canListHeavyStatus) {
            super(infra, canListHeavyStatus);
            this.baseImageTag = infra.baseImageTag;
            this.prePushMode = infra.prePushMode;
            this.prePushScript = infra.prePushScript;
            this.buildIntermediateImageWithCodeEnvs = infra.buildIntermediateImageWithCodeEnvs;
        }

        @Override
        public AbstractDeploymentInfra.InfraType getInfraType() {
            return AbstractDeploymentInfra.InfraType.K8S;
        }
    }

    public static abstract class AbstractAPIDeploymentInfraBasicInfo
    extends AbstractInfraBasicInfo {
        public boolean carbonAPIEnabled;
        public boolean activityMonitoringEnabled;

        AbstractAPIDeploymentInfraBasicInfo() {
        }

        AbstractAPIDeploymentInfraBasicInfo(boolean canListHeavyStatus) {
            super(canListHeavyStatus);
        }

        AbstractAPIDeploymentInfraBasicInfo(AbstractAPIDeploymentInfra infra, boolean canListHeavyStatus) {
            super(infra, canListHeavyStatus);
            this.carbonAPIEnabled = StringUtils.isNotBlank((String)infra.carbonAPISettings.carbonAPIURL);
            this.activityMonitoringEnabled = infra.activityMonitoringSettings.mode != ActivityMonitoringSettings.Mode.DISABLED;
        }

        public boolean isActivityMonitoringSupported() {
            return true;
        }
    }
}

