/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.deployments.actions;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeployment;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentDeletion;
import com.dataiku.dip.deployer.common.deployments.actions.DeploymentUpdate;
import com.dataiku.dip.deployer.common.deployments.actions.FullDeploymentUpdate;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(type="UPDATE", value=DeploymentUpdate.class), @Mapping(type="FULL_UPDATE", value=FullDeploymentUpdate.class), @Mapping(type="DELETE", value=DeploymentDeletion.class)})
public abstract class DeploymentAction {
    protected boolean inProgress;
    protected long startTimestamp;
    @Nullable
    protected Long endTimestamp;
    protected PublicUser requester;
    protected InfoMessage.Severity status;
    protected AbstractDeploymentInfra infra;
    protected AbstractDeployment deployment;

    protected DeploymentAction() {
    }

    protected DeploymentAction(boolean inProgress, long startTimestamp, @Nullable Long endTimestamp, PublicUser requester, @Nullable InfoMessage.Severity status, AbstractDeploymentInfra infra, AbstractDeployment deployment) {
        this.inProgress = inProgress;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.requester = requester;
        this.status = status;
        this.infra = infra;
        this.deployment = deployment;
    }

    @Nullable
    protected FutureResponse<Object> asFutureResponse() {
        FutureResponse futureResponse = new FutureResponse();
        futureResponse.hasResult = true;
        futureResponse.result = this.getReport();
        return futureResponse;
    }

    protected abstract DeploymentAction completeAction(Object var1, long var2);

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean value) {
        this.inProgress = value;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public PublicUser getRequester() {
        return this.requester;
    }

    public InfoMessage.Severity getStatus() {
        return this.status;
    }

    public AbstractDeploymentInfra getInfra() {
        return this.infra;
    }

    public AbstractDeployment getDeployment() {
        return this.deployment;
    }

    @Nullable
    public abstract Object getReport();

    public abstract String getType();
}

