/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.engine;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.kernel.master.locking.BalancedPrioritizationStrategy;
import com.dataiku.dip.dataflow.kernel.master.locking.ConstrainedLock;
import com.dataiku.dip.dataflow.kernel.master.locking.Permit;
import com.dataiku.dip.dataflow.kernel.master.locking.PermitStatus;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentHook;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHook;
import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHookResult;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksKernelProtocol;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunLimiter;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunRequest;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunner;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.recipes.code.python.PythonRecipeStatusComputerBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeploymentHooksService {
    public static final String KERNEL_MAX_PER_INFRA = "dku.deployer.hooks.kernels.defaultMaxPerInfra";
    public static final int KERNEL_DEFAULT_MAX_PER_INFRA = 3;
    public static final String KERNEL_MAX_TOTAL = "dku.deployer.hooks.kernels.maxTotal";
    public static final int KERNEL_DEFAULT_MAX_TOTAL = 100;
    public static final String EXECUTION_TIMEOUT_MINUTES_CONFIG_KEY = "dku.deployer.hooks.execute.timeoutMn";
    private static final int EXECUTION_DEFAULT_TIMEOUT_MINUTES = 30;
    public static final String PRE_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS_CONFIG_KEY = "dku.deployer.hooks.kernels.preKernelWaitTimeoutSeconds";
    private static final int PRE_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS = 10;
    public static final String POST_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS_CONFIG_KEY = "dku.deployer.hooks.kernels.postKernelWaitTimeoutSeconds";
    private static final int POST_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS = 60;
    private static final long WAITING_CHUNKS_DURATION_MS = 10000L;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.hooks.service");
    @Autowired
    private UsersService usersService;
    private final int executionTimeoutMinutes;
    private final long preKernelWaitTimeoutMs;
    private final long postKernelWaitTimeoutMs;
    ConstrainedLock<DeploymentHooksRunRequest> deploymentHookConstrainedLock = new ConstrainedLock();

    public DeploymentHooksService() {
        Params p = DKUApp.getParams();
        int kernelMaxTotal = p.getIntParam(KERNEL_MAX_TOTAL, Integer.valueOf(100));
        this.executionTimeoutMinutes = p.getIntParam(EXECUTION_TIMEOUT_MINUTES_CONFIG_KEY, Integer.valueOf(30));
        this.preKernelWaitTimeoutMs = 1000L * (long)p.getIntParam(PRE_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS_CONFIG_KEY, Integer.valueOf(10));
        this.postKernelWaitTimeoutMs = 1000L * (long)p.getIntParam(POST_DEPLOYMENT_HOOKS_WAIT_TIMEOUT_SECONDS_CONFIG_KEY, Integer.valueOf(60));
        this.deploymentHookConstrainedLock.setPrioritizationStrategy(new BalancedPrioritizationStrategy(10));
        this.deploymentHookConstrainedLock.setSchedulingConstraintPolicy(new DeploymentHooksRunLimiter(kernelMaxTotal));
    }

    public static void registerAdapters() {
        DeploymentHookResult.registerJsonAdapters();
    }

    public DeploymentHooksRunner acquireRunner(DSSAuthCtx user, AbstractDeploymentInfra infra, boolean preHooks) throws InterruptedException, CodedException, IOException, DKUSecurityException {
        String waitReason;
        long elapsed;
        PermitStatus result;
        long waitTimeoutMs = preHooks ? this.preKernelWaitTimeoutMs : this.postKernelWaitTimeoutMs;
        logger.infoV("Requesting a permit to create a deployment hook kernel for infra %s, will wait at most %d ms", new Object[]{infra.id, waitTimeoutMs});
        DeploymentHooksRunRequest request = new DeploymentHooksRunRequest(infra);
        Permit<DeploymentHooksRunRequest> permit = this.deploymentHookConstrainedLock.newPermit(request);
        long timeout = Math.min(waitTimeoutMs, 10000L);
        Stopwatch stopwatch = Stopwatch.createStarted();
        permit.acquire();
        do {
            result = permit.await(timeout);
            elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
            timeout = Math.min(waitTimeoutMs - elapsed, 10000L);
            if (PermitStatus.PermitState.WAITING.equals((Object)result.getState()) && timeout > 0L) {
                waitReason = permit.getWaitReason();
                logger.infoV("Could not get a permit for a deployment hook kernel for infra %s after %d ms. Will continue to wait %d ms and check. Reason was: %s", new Object[]{infra.id, elapsed, timeout, waitReason});
                continue;
            }
            stopwatch.stop();
        } while (stopwatch.isRunning());
        if (PermitStatus.PermitState.WAITING.equals((Object)result.getState())) {
            waitReason = permit.getWaitReason();
            logger.errorV("Could not get a permit for a deployment hook kernel for infra %s after %d ms. Reason was: %s", new Object[]{infra.id, elapsed, waitReason});
            permit.release();
            throw new RuntimeException(waitReason);
        }
        logger.infoV("Waited %d ms before acquiring a permit for a deployment hook kernel", new Object[]{elapsed});
        stopwatch.reset().start();
        logger.infoV("Creating deployment hook kernel for user %s and code env %s", new Object[]{user, infra.deploymentHookSettings.hookCodeEnvName});
        try {
            SimplePythonKernel kernel = SimplePythonKernelFactory.prepareKernel(user, "deploymentHooks", GeneralSettingsDAO.CGrouppableProcessType.DEPLOYMENT_HOOK, infra.deploymentHookSettings.hookCodeEnvName, "dataiku.deployer.hooks.server", true, null, "deployment_hooks");
            DeploymentHooksKernelProtocol protocol = new DeploymentHooksKernelProtocol(kernel);
            return new DeploymentHooksRunner(protocol, this.executionTimeoutMinutes, permit, stopwatch);
        }
        catch (Throwable t) {
            permit.release();
            throw t;
        }
    }

    public InfoMessage.InfoMessages checkPythonCompile(AbstractDeploymentInfra infra) throws Exception {
        InfoMessage.InfoMessages hookMessages;
        DeploymentHook inlineHook;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (AbstractDeploymentHook hook : infra.deploymentHookSettings.preDeploymentHooks) {
            if (!(hook instanceof DeploymentHook)) continue;
            inlineHook = (DeploymentHook)hook;
            hookMessages = new InfoMessage.InfoMessages();
            PythonRecipeStatusComputerBase.checkPythonCompile(hookMessages, inlineHook.code, infra.deploymentHookSettings.hookCodeEnvName, null);
            hookMessages.addCodePositionToDetails();
            hookMessages.prefixMessageDetails(String.format("For pre deployment hook \"%s\" - ", inlineHook.name));
            messages.mergeFrom(hookMessages);
        }
        for (AbstractDeploymentHook hook : infra.deploymentHookSettings.postDeploymentHooks) {
            if (!(hook instanceof DeploymentHook)) continue;
            inlineHook = (DeploymentHook)hook;
            hookMessages = new InfoMessage.InfoMessages();
            PythonRecipeStatusComputerBase.checkPythonCompile(hookMessages, inlineHook.code, infra.deploymentHookSettings.hookCodeEnvName, null);
            hookMessages.addCodePositionToDetails();
            hookMessages.prefixMessageDetails(String.format("For post deployment hook \"%s\" - ", inlineHook.name));
            messages.mergeFrom(hookMessages);
        }
        return messages;
    }

    public InfoMessage.InfoMessages checkCodeCompiles_NT_Check(AuthCtx user, String code, String codeEnvName) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        user.failIfNoSafeCode("validate deployment hook code");
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        PythonRecipeStatusComputerBase.checkPythonCompile(messages, code, codeEnvName, null);
        return messages;
    }

    public DSSAuthCtx getHooksRunningUser_Check(AuthCtx authCtx, AbstractDeploymentInfra infra) throws IOException, UnauthorizedException {
        String failMsg;
        DSSAuthCtx dssAuthCtx;
        TransactionContext.assertAttachedTransaction();
        if (StringUtils.isEmpty((String)infra.deploymentHookSettings.runHooksAsUser)) {
            dssAuthCtx = (DSSAuthCtx)authCtx;
            failMsg = "deployment hooks are defined on this infrastructure, so you need the permission to run code. Aborting deployment. Please contact your administrator.";
        } else {
            dssAuthCtx = DSSAuthCtx.forUserLogin(this.usersService.getInternalMandatoryUnsafe(infra.deploymentHookSettings.runHooksAsUser));
            failMsg = "deployment hooks are defined on this infrastructure, and the user specified to run them does not have the permission to run code. Aborting deployment. Please contact your administrator.";
        }
        dssAuthCtx.failIfNoSafeCode(failMsg);
        return dssAuthCtx;
    }

    public boolean hookSettingAreEmpty(AbstractDeploymentInfra deploymentInfra) {
        return ListUtils.emptyIfNull(deploymentInfra.deploymentHookSettings.preDeploymentHooks).isEmpty() && ListUtils.emptyIfNull(deploymentInfra.deploymentHookSettings.postDeploymentHooks).isEmpty() && StringUtils.isEmpty((String)deploymentInfra.deploymentHookSettings.hookCodeEnvName) && StringUtils.isEmpty((String)deploymentInfra.deploymentHookSettings.runHooksAsUser) && deploymentInfra.deploymentHookSettings.maxHooksKernels == AbstractDeploymentInfra.DeploymentHookSettings.DEFAULT_MAX_HOOKS_KERNELS;
    }
}

