/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.infra;

import com.dataiku.common.server.APIError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.AbstractProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.SingleNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsDAO;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAutomationNodeInfraManager {
    final AuthCtx authCtx;
    final int connectTimeout;
    final int socketTimeout;
    static final DKULogger logger = DKULogger.getLogger((String)"dku.projectdeployer.infras.manager");

    protected AbstractAutomationNodeInfraManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        this.authCtx = authCtx;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Nonnull
    public abstract AbstractProjectDeploymentInfra getInfra();

    @Nullable
    public abstract ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchy() throws IOException, CodedException;

    @Nonnull
    public abstract InfoMessage.InfoMessages checkInfraStatus();

    @Nonnull
    public abstract List<? extends AbstractProjectDeploymentHeavyStatus> listHeavyStatus(List<AbstractProjectDeployment> var1);

    @Nonnull
    public abstract List<String> getProjectKeys() throws IOException, CodedException;

    @Nullable
    public abstract List<String> listUserLogins() throws IOException, CodedException;

    @Nullable
    public abstract List<String> listConnectionsNames(@Nullable String var1) throws IOException, URISyntaxException, CodedException;

    @Nonnull
    public abstract List<String> listContainerExecNames(@Nullable String var1) throws IOException, URISyntaxException, CodedException;

    @Nonnull
    public abstract List<NodeConnection> getNodeConnections();

    public abstract void openAutomationNodeClientConnections();

    public abstract void closeAutomationNodeClientConnections();

    @Nullable
    protected ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchyOnNode(NodeConnection nodeConnection) throws IOException, CodedException {
        try (AutomationNodeClient client = AutomationNodeClient.automationNodeProxyUserClient(this.authCtx, this.getInfra(), nodeConnection, this.connectTimeout, this.socketTimeout);){
            ProjectFoldersService.ProjectFolderSummary projectFolderSummary = client.getProjectFolderHierarchy();
            return projectFolderSummary;
        }
    }

    @Nonnull
    protected InfoMessage.InfoMessages checkInfraStatusOnNode(NodeConnection nodeConnection) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (!nodeConnection.canOpenClient()) {
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_NOT_REACHABLE, String.format("The automation node %s cannot be reached (%s).", nodeConnection.automationNodeId, nodeConnection.nodeDirectoryStatus));
            return messages;
        }
        try (AutomationNodeClient client = AutomationNodeClient.automationNodeClient(nodeConnection, null, this.connectTimeout, this.socketTimeout);){
            String nodeType = client.getNodeType();
            if (!StringUtils.equalsIgnoreCase((CharSequence)"AUTOMATION", (CharSequence)nodeType)) {
                String details = nodeConnection.automationNodeId == null ? "This node is of type " + nodeType + ". Only Automation nodes are supported." : "The node " + nodeConnection.automationNodeId + " is of type " + nodeType + ". Only Automation nodes are supported.";
                messages.withWarning((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_INFRA_WRONG_TYPE, details);
            }
        }
        catch (APIError.APIErrorException e) {
            logger.warnV((Throwable)e, "Failed to get node type on infra %s, node %s", new Object[]{this.getInfra().id, nodeConnection.url});
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_REMOTE_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to get a response from infra %s, node %s", new Object[]{this.getInfra().id, nodeConnection.url});
            messages.withError((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_ERROR, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return messages;
    }

    @Nonnull
    protected List<String> getProjectKeysOnNode(NodeConnection nodeConnection) throws IOException, CodedException {
        try (AutomationNodeClient client = AutomationNodeClient.automationNodeProxyUserClient(this.authCtx, this.getInfra(), nodeConnection, this.connectTimeout, this.socketTimeout);){
            List<String> list = client.getProjectKeys();
            return list;
        }
    }

    @Nullable
    protected List<String> listUserLoginsOnNode(NodeConnection nodeConnection) throws IOException, CodedException {
        try (AutomationNodeClient client = AutomationNodeClient.automationNodeClient(nodeConnection, null, this.connectTimeout, this.socketTimeout);){
            List<UsersService.APIUser> apiUsers = client.listUsers();
            if (apiUsers == null) {
                List<String> list = null;
                return list;
            }
            List<String> list = apiUsers.stream().map(apiUser -> apiUser.login).collect(Collectors.toList());
            return list;
        }
    }

    @Nullable
    protected List<String> listConnectionsNamesOnNode(NodeConnection nodeConnection, @Nullable String deploymentId) throws IOException, URISyntaxException, CodedException {
        try (AutomationNodeClient client = this.getClient(this.authCtx, deploymentId, nodeConnection, this.getInfra());){
            List<String> list = client.listConnectionsNames();
            return list;
        }
    }

    @Nonnull
    protected List<String> listContainerExecNamesOnNode(NodeConnection nodeConnection, @Nullable String deploymentId) throws IOException, URISyntaxException, CodedException {
        try (AutomationNodeClient client = this.getClient(this.authCtx, deploymentId, nodeConnection, this.getInfra());){
            List<String> list = client.listContainerExecNames();
            return list;
        }
    }

    @Nonnull
    private AutomationNodeClient getClient(AuthCtx authCtx, @Nullable String deploymentId, NodeConnection nodeConnection, AbstractProjectDeploymentInfra infra) throws IOException, CodedException {
        if (StringUtils.isNotBlank((CharSequence)deploymentId)) {
            String targetProjectKey;
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            ProjectDeploymentsDAO deploymentsDAO = (ProjectDeploymentsDAO)SpringUtils.getBean(ProjectDeploymentsDAO.class);
            try (Transaction ignored = transactionService.retrieveOrBeginRead();){
                AbstractProjectDeployment deployment = (AbstractProjectDeployment)deploymentsDAO.getMandatory(deploymentId);
                targetProjectKey = deployment.getTargetProjectKey();
            }
            return AutomationNodeClient.automationNodeOverridableProxyUserClient(authCtx, infra, nodeConnection, targetProjectKey, this.connectTimeout, this.socketTimeout);
        }
        return AutomationNodeClient.automationNodeProxyUserClient(authCtx, infra, nodeConnection, this.connectTimeout, this.socketTimeout);
    }

    protected List<SingleNodeProjectDeploymentHeavyStatus> listHeavyStatusOnNode(NodeConnection nodeConnection, List<AbstractProjectDeployment> allDeployments) {
        ArrayList<SingleNodeProjectDeploymentHeavyStatus> ret = new ArrayList<SingleNodeProjectDeploymentHeavyStatus>();
        HashMultimap deployAsUserToProjects = HashMultimap.create();
        if (!nodeConnection.canOpenClient()) {
            String errorMessage = String.format("Automation node (infra id: %s, %s) cannot be reached (%s).", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection), nodeConnection.nodeDirectoryStatus);
            ret.addAll(AbstractAutomationNodeInfraManager.heavyStatusListWithError(allDeployments, DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_NOT_REACHABLE, errorMessage));
            return ret;
        }
        for (AbstractProjectDeployment deployment : allDeployments) {
            try {
                deployAsUserToProjects.put((Object)this.getInfra().getProxyUserForTargetProject(this.authCtx, deployment.getTargetProjectKey()), (Object)deployment);
            }
            catch (Exception e) {
                SingleNodeProjectDeploymentHeavyStatus heavyStatus = new SingleNodeProjectDeploymentHeavyStatus(deployment.id, deployment.infraId);
                heavyStatus.setMessageAndHealthWithSeverity(InfoMessage.errorV((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_INFRA_CONFIG_REQUIRED, (String)e.getLocalizedMessage(), (Object[])new Object[0]), DeploymentHealth.ERROR);
                ret.add(heavyStatus);
            }
        }
        for (String curUser : deployAsUserToProjects.keySet()) {
            String errorMessage;
            ArrayList<AbstractProjectDeployment> deployment = new ArrayList<AbstractProjectDeployment>(deployAsUserToProjects.get((Object)curUser));
            List<String> projectKeys = deployment.stream().map(d -> d.getTargetProjectKey()).collect(Collectors.toList());
            try {
                AutomationNodeClient userClient = AutomationNodeClient.automationNodeProxyUserClient(curUser, nodeConnection, this.connectTimeout, this.socketTimeout);
                try {
                    Map<String, AbstractProjectDeploymentHeavyStatus.Info> infoMap = userClient.listHeavyStatus(projectKeys).map;
                    ret.addAll(this.createStatusList(infoMap, deployment, nodeConnection));
                }
                finally {
                    if (userClient == null) continue;
                    userClient.close();
                }
            }
            catch (APIError.APIErrorException e) {
                logger.warn((Object)String.format("Automation infra (id: %s, %s) returned an error when trying to list the project status", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection)), (Throwable)e);
                errorMessage = String.format("Automation node (infra id: %s, %s) returned an error when trying to retrieve the project status: %s", this.getInfra().id, this.nodeConnectionExternalUrlAndId(nodeConnection), ExceptionUtils.getMessageWithCauses((Throwable)e).replace("%", "%%"));
                ret.addAll(AbstractAutomationNodeInfraManager.heavyStatusListWithError(deployment, DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_REMOTE_ERROR, errorMessage));
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Failed to list project status on automation infra (id: %s, %s)", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection)), (Throwable)e);
                errorMessage = String.format("Failed to get project status on automation infra (id: %s, %s): %s", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection), ExceptionUtils.getMessageWithCauses((Throwable)e).replace("%", "%%"));
                ret.addAll(AbstractAutomationNodeInfraManager.heavyStatusListWithError(deployment, DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_ERROR, errorMessage));
            }
        }
        return ret;
    }

    private List<SingleNodeProjectDeploymentHeavyStatus> createStatusList(Map<String, AbstractProjectDeploymentHeavyStatus.Info> infoMap, List<AbstractProjectDeployment> deployments, NodeConnection nodeConnection) {
        ArrayList<SingleNodeProjectDeploymentHeavyStatus> heavyStatusList = new ArrayList<SingleNodeProjectDeploymentHeavyStatus>();
        block0: for (AbstractProjectDeployment deployment : deployments) {
            String message;
            String message2;
            SingleNodeProjectDeploymentHeavyStatus heavyStatus = new SingleNodeProjectDeploymentHeavyStatus(deployment.id, deployment.infraId);
            heavyStatusList.add(heavyStatus);
            String projectKey = deployment.getTargetProjectKey();
            AbstractProjectDeploymentHeavyStatus.Info info = infoMap.get(projectKey);
            if (info == null) {
                String message22 = String.format("Automation infra (id: %s, %s) did not return information on project %s in the expected format. You may need to upgrade your automation node.", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection), projectKey);
                heavyStatus.setMessageAndHealthWithSeverity(InfoMessage.warningV((InfoMessage.MessageCode)DeployerCodes.WARN_DEPLOYER_UNEXPECTED_NON_FATAL_ERROR, (String)message22, (Object[])new Object[0]), DeploymentHealth.WARNING);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)info.errorMessage)) {
                message2 = String.format("Automation infra (id: %s, %s) returned an error when trying to list the project status: %s", this.getInfra().id, this.nodeConnectionUrlAndId(nodeConnection), info.errorMessage);
                heavyStatus.setMessageAndHealthWithSeverity(InfoMessage.errorV((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_REMOTE_ERROR, (String)message2, (Object[])new Object[0]), DeploymentHealth.ERROR);
                continue;
            }
            if (!info.projectExists) {
                message2 = nodeConnection.automationNodeId == null ? String.format("Project %s does not exist on infra %s, or you may not be able to view it", projectKey, deployment.infraId) : String.format("Project %s does not exist on infra %s for node %s, or you may not be able to view it", projectKey, nodeConnection.automationNodeId, deployment.infraId);
                logger.warn((Object)message2);
                heavyStatus.setOutOfSync(message2, DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_PROJECT_DOES_NOT_EXIST);
                continue;
            }
            String activeBundleId = info.activeBundleId;
            if (StringUtils.isBlank((CharSequence)deployment.bundleId)) {
                heavyStatus.setMessageAndHealthWithSeverity(InfoMessage.warning((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_DEPLOYMENT_INCOMPLETE, (String)"Project deployment has no bundle configured"), DeploymentHealth.WARNING);
            } else if (deployment.bundleId.equals(activeBundleId)) {
                heavyStatus.setHealthWithSeverity(DeploymentHealth.HEALTHY);
            } else {
                String message3;
                String string = activeBundleId = activeBundleId == null ? "none currently" : activeBundleId;
                if (nodeConnection.automationNodeId == null) {
                    String message32 = String.format("Active bundle (%s) on automation project %s does not match configured bundle (%s)", activeBundleId, projectKey, deployment.bundleId);
                } else {
                    message3 = String.format("Active bundle (%s) on automation project %s for node %s does not match configured bundle (%s)", activeBundleId, projectKey, nodeConnection.automationNodeId, deployment.bundleId);
                }
                logger.warn((Object)message3);
                heavyStatus.setOutOfSync(message3);
            }
            if (info.isProjectAdmin) {
                BundleContainerSettings bundleContainerSettings = deployment.getBundleContainerSettings(this.getInfra());
                if (!info.codeEnvsBehavior.equals(bundleContainerSettings.codeEnvsBehavior)) {
                    heavyStatus.setOutOfSync("Code environment import behavior on deployed automation project node does not match configured behavior");
                }
                if (!CollectionUtils.isEqualCollection(info.connectionRemappings, bundleContainerSettings.remapping.connections)) {
                    heavyStatus.setOutOfSync("Connection remapping on deployed automation node project does not match configured remapping");
                }
                if (!CollectionUtils.isEqualCollection(info.containerExecRemappings, bundleContainerSettings.remapping.containerExecs)) {
                    heavyStatus.setOutOfSync("Containerized execution remapping on deployed automation node project does not match configured remapping");
                }
            }
            ArrayList<String> mismatchedVariables = new ArrayList<String>();
            for (String string : deployment.localVariables.keySet()) {
                if (deployment.localVariables.get(string).equals(info.localVariables.get(string))) continue;
                mismatchedVariables.add(string);
            }
            if (!mismatchedVariables.isEmpty()) {
                message = nodeConnection.automationNodeId == null ? String.format("Project local variable%s '%s' on deployed automation node project do%s not match configured variables", mismatchedVariables.size() == 1 ? "" : "s", String.join((CharSequence)"', '", mismatchedVariables), mismatchedVariables.size() == 1 ? "es" : "") : String.format("Project local variable%s '%s' on deployed automation node project for node %s do%s not match configured variables", mismatchedVariables.size() == 1 ? "" : "s", nodeConnection.automationNodeId, String.join((CharSequence)"', '", mismatchedVariables), mismatchedVariables.size() == 1 ? "es" : "");
                heavyStatus.setOutOfSync(message);
            }
            if (info.disabledAutomaticTriggers != deployment.disableAutomaticTriggers) {
                message = nodeConnection.automationNodeId == null ? String.format("Disabling automatic triggers is set to %s on deployed automation node project while it is configured to be %s", info.disabledAutomaticTriggers, deployment.disableAutomaticTriggers) : String.format("Disabling automatic triggers is set to %s on deployed automation node project for node %s while it is configured to be %s", info.disabledAutomaticTriggers, nodeConnection.automationNodeId, deployment.disableAutomaticTriggers);
                heavyStatus.setOutOfSync(message);
            }
            heavyStatus.monitoring = info.monitoring;
            heavyStatus.name = info.name;
            if (!info.webappBackendInfoList.isEmpty()) {
                heavyStatus.webappBackendInfoList = info.webappBackendInfoList;
            }
            for (Map.Entry entry : deployment.scenariosToActivate.entrySet()) {
                String message4;
                String scenarioId = (String)entry.getKey();
                Boolean shouldBeActivated = (Boolean)entry.getValue();
                if (shouldBeActivated == null) continue;
                Boolean activeOnAutomation = info.scenarioActiveState.get(scenarioId);
                if (activeOnAutomation == null) {
                    String message5;
                    String enabledVerb;
                    String string = enabledVerb = shouldBeActivated != false ? "enabled" : "disabled";
                    if (nodeConnection.automationNodeId == null) {
                        String message42 = String.format("Scenario %s does not exist on automation project %s, whereas configured as %s on deployment %s", scenarioId, projectKey, enabledVerb, deployment.id);
                    } else {
                        message5 = String.format("Scenario %s does not exist on automation project %s for node %s, whereas configured as %s on deployment %s", scenarioId, projectKey, nodeConnection.automationNodeId, enabledVerb, deployment.id);
                    }
                    heavyStatus.healthMessages.withInfo((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_PROJECT_INCOMPLETE, message5);
                    continue;
                }
                if (Objects.equals(activeOnAutomation, shouldBeActivated)) continue;
                if (nodeConnection.automationNodeId == null) {
                    String message5 = String.format("Scenario %s is %s on deployed automation project %s  whereas %s as such on deployment %s", scenarioId, (activeOnAutomation != false ? "" : "not ") + "active", projectKey, (shouldBeActivated != false ? "" : "not ") + "configured", deployment.id);
                } else {
                    message4 = String.format("Scenario %s is %s on deployed automation project %s for node %s  whereas %s as such on deployment %s", scenarioId, (activeOnAutomation != false ? "" : "not ") + "active", projectKey, nodeConnection.automationNodeId, (shouldBeActivated != false ? "" : "not ") + "configured", deployment.id);
                }
                heavyStatus.setOutOfSync(message4);
                continue block0;
            }
        }
        return heavyStatusList;
    }

    private static List<SingleNodeProjectDeploymentHeavyStatus> heavyStatusListWithError(List<AbstractProjectDeployment> deployments, DeployerCodes code, String message) {
        ArrayList<SingleNodeProjectDeploymentHeavyStatus> heavyStatusList = new ArrayList<SingleNodeProjectDeploymentHeavyStatus>();
        for (AbstractProjectDeployment deployment : deployments) {
            SingleNodeProjectDeploymentHeavyStatus heavyStatus = new SingleNodeProjectDeploymentHeavyStatus(deployment.id, deployment.infraId);
            heavyStatus.setMessageAndHealthWithSeverity(InfoMessage.errorV((InfoMessage.MessageCode)code, (String)message, (Object[])new Object[0]), DeploymentHealth.ERROR);
            heavyStatusList.add(heavyStatus);
        }
        return heavyStatusList;
    }

    private String nodeConnectionUrlAndId(NodeConnection nodeConnection) {
        if (nodeConnection.automationNodeId == null) {
            return String.format("node URL: %s", nodeConnection.url);
        }
        return String.format("node URL: %s, node ID: %s", nodeConnection.url, nodeConnection.automationNodeId);
    }

    private String nodeConnectionExternalUrlAndId(NodeConnection nodeConnection) {
        if (nodeConnection.automationNodeId == null) {
            return String.format("URL: %s", nodeConnection.externalUrl);
        }
        return String.format("URL: %s, node ID: %s", nodeConnection.externalUrl, nodeConnection.automationNodeId);
    }
}

