/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.projectdeployer.infra;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.MultiNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.SingleNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.infra.AbstractAutomationNodeInfraManager;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.model.PersonalPublicAPIKey;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpHostConnectException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MultiAutomationNodeInfraManager
extends AbstractAutomationNodeInfraManager {
    @Nonnull
    final MultiAutomationNodeInfra infra;
    @Nonnull
    public final List<NodeConnection> nodeConnections;
    Map<NodeConnection, AutomationNodeClient> automationNodeClients = new HashMap<NodeConnection, AutomationNodeClient>();

    public MultiAutomationNodeInfraManager(AuthCtx authCtx, @Nonnull MultiAutomationNodeInfra infra, int connectTimeout, int socketTimeout) {
        super(authCtx, connectTimeout, socketTimeout);
        this.infra = infra;
        this.nodeConnections = infra.getConnectionInfos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonalPublicAPIKeyOnAllNodes createPersonalAPIKey(AuthCtx requestingUser, String label, String description, @Nullable String forUser) throws CodedException {
        logger.infoV("Creating a personal API key for user %s with the same secret on all automation nodes of infra %s", new Object[]{requestingUser.getIdentifier(), this.infra.id});
        PersonalPublicAPIKeyOnAllNodes personalPublicAPIKeyOnAllNodes = new PersonalPublicAPIKeyOnAllNodes(requestingUser, forUser);
        PersonalPublicAPIKey key = new PersonalPublicAPIKey();
        key.label = label;
        key.description = description;
        key.user = personalPublicAPIKeyOnAllNodes.user;
        key.key = ApiKeyUtils.generateApiKeySecret();
        this.openAutomationNodeClientConnections();
        try {
            for (Object nodeConnection : this.nodeConnections) {
                if (!nodeConnection.canOpenClient()) {
                    logger.errorV("The automation node %s cannot be reached (%s)", new Object[]{nodeConnection.automationNodeId, nodeConnection.nodeDirectoryStatus});
                    throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_PROJECT_DEPLOYER_AUTOMATION_NODE_NOT_REACHABLE, String.format("The automation node %s cannot be reached (%s)", nodeConnection.automationNodeId, nodeConnection.nodeDirectoryStatus));
                }
                AutomationNodeClient automationNodeClient = this.getAutomationNodeClientOrNull((NodeConnection)nodeConnection);
                if (automationNodeClient == null) {
                    throw new IllegalStateException("The automation node client should not be null");
                }
                try {
                    Object info;
                    UserAuthenticationService.UserAuthInfo user = automationNodeClient.userExists(key.user);
                    if (!user.exists) {
                        info = new PersonalPublicAPIKeyOnAllNodes.NonExistingUserOnNodeInfo();
                        ((PersonalPublicAPIKeyOnAllNodes.NonExistingUserOnNodeInfo)info).id = automationNodeClient.automationNodeId;
                        ((PersonalPublicAPIKeyOnAllNodes.NonExistingUserOnNodeInfo)info).url = automationNodeClient.externalUrl;
                        ((PersonalPublicAPIKeyOnAllNodes.NonExistingUserOnNodeInfo)info).provisioningAtLogin = user.provisioningAtLogin;
                        personalPublicAPIKeyOnAllNodes.nodesWhereUserDoesNotExist.add((PersonalPublicAPIKeyOnAllNodes.NonExistingUserOnNodeInfo)info);
                        continue;
                    }
                    if (user.enabled) continue;
                    info = new PersonalPublicAPIKeyOnAllNodes.DisabledUserOnNodeInfo();
                    ((PersonalPublicAPIKeyOnAllNodes.DisabledUserOnNodeInfo)info).id = automationNodeClient.automationNodeId;
                    ((PersonalPublicAPIKeyOnAllNodes.DisabledUserOnNodeInfo)info).url = automationNodeClient.externalUrl;
                    personalPublicAPIKeyOnAllNodes.nodesWhereUserIsDisabled.add((PersonalPublicAPIKeyOnAllNodes.DisabledUserOnNodeInfo)info);
                }
                catch (HttpHostConnectException e) {
                    logger.errorV((Throwable)e, "Unable to connect to automation node id %s", new Object[]{automationNodeClient.automationNodeId});
                    throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PERSONAL_API_KEY_CREATION, String.format("Unable to connect to automation node id %s: %s", automationNodeClient.automationNodeId, e.getMessage()));
                }
                catch (IOException e) {
                    logger.errorV((Throwable)e, "An unexpected error occurred while checking user details on automation node id %s", new Object[]{automationNodeClient.automationNodeId});
                    throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_DEPLOYER_PERSONAL_API_KEY_CREATION, String.format("An unexpected error occurred while checking user details on automation node id %s: %s", automationNodeClient.automationNodeId, e.getMessage()));
                }
            }
            if (!personalPublicAPIKeyOnAllNodes.nodesWhereUserDoesNotExist.isEmpty()) {
                Object nodeConnection;
                String missingNodes = personalPublicAPIKeyOnAllNodes.nodesWhereUserDoesNotExist.stream().map(n -> n.id).collect(Collectors.joining(", "));
                logger.errorV("The user %s requested the creation of a personal API key%s on the multi automation node infra %s, but does not exist on automation node ids %s", new Object[]{requestingUser.getIdentifier(), StringUtils.isNotBlank((String)forUser) ? " for user " + forUser : "", this.infra.id, missingNodes});
                nodeConnection = personalPublicAPIKeyOnAllNodes;
                return nodeConnection;
            }
            for (AutomationNodeClient automationNodeClient : this.automationNodeClients.values()) {
                PersonalPublicAPIKey createdKey = null;
                IOException creationError = null;
                try {
                    createdKey = automationNodeClient.createPersonalKey(key);
                    if (createdKey == null) {
                        logger.errorV("The creation of the personal API key on automation node %s returned a null response. Considering this as a failure.", new Object[]{automationNodeClient.automationNodeId});
                    }
                }
                catch (IOException e) {
                    creationError = e;
                    logger.errorV((Throwable)e, "An unexpected error occurred during the creation of the personal API key on automation node id %s", new Object[]{automationNodeClient.automationNodeId});
                }
                if (createdKey == null) {
                    String errorMessage = creationError != null ? ". The error was: " + creationError.getMessage() : "";
                    personalPublicAPIKeyOnAllNodes.error = personalPublicAPIKeyOnAllNodes.nodesAndKeys.isEmpty() ? String.format("An unexpected error occurred while creating a personal API key on automation node id: %s. The key has not been created on any automation node%s", automationNodeClient.automationNodeId, errorMessage) : String.format("An unexpected error occurred while creating a personal API key on automation node id: %s. The key has been created on automation nodes: %s%s", automationNodeClient.automationNodeId, personalPublicAPIKeyOnAllNodes.nodesAndKeys.stream().map(n -> String.format("%s (with key id %s)", n.automationNodeId, n.keyId)).collect(Collectors.joining(", ")), errorMessage);
                    PersonalPublicAPIKeyOnAllNodes personalPublicAPIKeyOnAllNodes2 = personalPublicAPIKeyOnAllNodes;
                    return personalPublicAPIKeyOnAllNodes2;
                }
                personalPublicAPIKeyOnAllNodes.addNodeAndKeyId(automationNodeClient.automationNodeId, automationNodeClient.externalUrl, createdKey.id);
                personalPublicAPIKeyOnAllNodes.secret = key.key;
                logger.infoV("Successfully created a new personal API key with id %s for user %s in multi automation nodes infra %s, on automation node id %s", new Object[]{createdKey.id, requestingUser.getIdentifier(), this.infra.id, automationNodeClient.automationNodeId});
            }
        }
        finally {
            this.closeAutomationNodeClientConnections();
        }
        logger.infoV("Successfully created a personal API key for user %s with the same secret on all automation nodes of infra %s", new Object[]{requestingUser.getIdentifier(), this.infra.id});
        personalPublicAPIKeyOnAllNodes.createdOnAllNodes = true;
        return personalPublicAPIKeyOnAllNodes;
    }

    @Override
    @Nonnull
    public AbstractProjectDeploymentInfra getInfra() {
        return this.infra;
    }

    @Override
    @Nullable
    public ProjectFoldersService.ProjectFolderSummary getProjectFolderHierarchy() {
        return new ProjectFoldersService.ProjectFolderSummary();
    }

    @Override
    @Nonnull
    public InfoMessage.InfoMessages checkInfraStatus() {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (NodeConnection nodeConnection : this.nodeConnections) {
            messages.mergeFrom(this.checkInfraStatusOnNode(nodeConnection));
        }
        return messages;
    }

    @Nonnull
    public List<MultiNodeProjectDeploymentHeavyStatus> listHeavyStatus(List<AbstractProjectDeployment> allDeployments) {
        HashMap<String, MultiNodeProjectDeploymentHeavyStatus> heavyStatuses = new HashMap<String, MultiNodeProjectDeploymentHeavyStatus>();
        if (this.nodeConnections.isEmpty()) {
            return allDeployments.stream().map(d -> {
                MultiNodeProjectDeploymentHeavyStatus status = new MultiNodeProjectDeploymentHeavyStatus(d.id, this.infra.id);
                status.setHealthWithSeverity(DeploymentHealth.HEALTHY);
                return status;
            }).collect(Collectors.toUnmodifiableList());
        }
        for (NodeConnection nodeConnection : this.nodeConnections) {
            List<SingleNodeProjectDeploymentHeavyStatus> heavyStatusesOnNode = this.listHeavyStatusOnNode(nodeConnection, allDeployments);
            for (SingleNodeProjectDeploymentHeavyStatus heavyStatusOnNode : heavyStatusesOnNode) {
                MultiNodeProjectDeploymentHeavyStatus heavyStatus = (MultiNodeProjectDeploymentHeavyStatus)heavyStatuses.get(heavyStatusOnNode.deploymentId);
                if (heavyStatus == null) {
                    heavyStatus = new MultiNodeProjectDeploymentHeavyStatus(heavyStatusOnNode.deploymentId, heavyStatusOnNode.infraId);
                    heavyStatuses.put(heavyStatusOnNode.deploymentId, heavyStatus);
                }
                heavyStatus.mergeMessagesAndHealthWithSeverity(heavyStatusOnNode.healthMessages, heavyStatusOnNode.getHealth());
                heavyStatus.heavyStatusPerNode.put(nodeConnection.automationNodeId, heavyStatusOnNode);
                if (StringUtils.isNotBlank((String)heavyStatus.name) && StringUtils.isNotBlank((String)heavyStatusOnNode.name)) {
                    heavyStatus.name = heavyStatusOnNode.name;
                }
                if (heavyStatus.monitoring == null && heavyStatusOnNode.monitoring != null) {
                    heavyStatus.monitoring = heavyStatusOnNode.monitoring.copy();
                    continue;
                }
                if (heavyStatusOnNode.monitoring == null) continue;
                heavyStatus.monitoring.mergeFrom(heavyStatusOnNode.monitoring);
            }
        }
        return new ArrayList<MultiNodeProjectDeploymentHeavyStatus>(heavyStatuses.values());
    }

    @Override
    @Nonnull
    public List<String> getProjectKeys() throws IOException, CodedException {
        HashSet<String> allProjectKeys = new HashSet<String>();
        for (NodeConnection nodeConnection : this.nodeConnections) {
            allProjectKeys.addAll(this.getProjectKeysOnNode(nodeConnection));
        }
        return new ArrayList<String>(allProjectKeys);
    }

    @Override
    @Nullable
    public List<String> listUserLogins() throws IOException, CodedException {
        List<String> allUserLogins = null;
        for (NodeConnection nodeConnection : this.nodeConnections) {
            List<String> userLoginsOnNode = this.listUserLoginsOnNode(nodeConnection);
            if (allUserLogins == null) {
                allUserLogins = userLoginsOnNode;
                continue;
            }
            if (userLoginsOnNode == null) continue;
            allUserLogins = allUserLogins.stream().filter(userLoginsOnNode::contains).collect(Collectors.toList());
        }
        return allUserLogins;
    }

    @Override
    @Nullable
    public List<String> listConnectionsNames(@Nullable String deploymentId) throws IOException, URISyntaxException, CodedException {
        List<String> allConnectionNames = null;
        for (NodeConnection nodeConnection : this.nodeConnections) {
            List<String> connectionsNamesOnNode = this.listConnectionsNamesOnNode(nodeConnection, deploymentId);
            if (allConnectionNames == null) {
                allConnectionNames = connectionsNamesOnNode;
                continue;
            }
            if (connectionsNamesOnNode == null) continue;
            allConnectionNames = allConnectionNames.stream().filter(connectionsNamesOnNode::contains).collect(Collectors.toList());
        }
        return allConnectionNames;
    }

    @Override
    @Nonnull
    public List<String> listContainerExecNames(@Nullable String deploymentId) throws RuntimeException {
        return this.nodeConnections.stream().map(nc -> {
            try {
                return this.listContainerExecNamesOnNode((NodeConnection)nc, deploymentId);
            }
            catch (CodedException | IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).reduce((list1, list2) -> {
            ArrayList intersection = new ArrayList(list1);
            intersection.retainAll((Collection<?>)list2);
            return intersection;
        }).orElse(List.of());
    }

    @Override
    @Nonnull
    public List<NodeConnection> getNodeConnections() {
        return this.nodeConnections;
    }

    @Nullable
    public AutomationNodeClient getAutomationNodeClientOrNull(NodeConnection nodeConnection) {
        return this.automationNodeClients.getOrDefault(nodeConnection, null);
    }

    @Override
    public void openAutomationNodeClientConnections() {
        for (NodeConnection nodeConnection : this.nodeConnections) {
            try {
                this.automationNodeClients.put(nodeConnection, AutomationNodeClient.automationNodeClient(nodeConnection, null, this.connectTimeout, this.socketTimeout));
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Could not open automation node connection for node connection: url [%s], id [%s]", new Object[]{nodeConnection.url, nodeConnection.automationNodeId});
            }
        }
    }

    @Override
    public void closeAutomationNodeClientConnections() {
        this.automationNodeClients.values().forEach(InternalAPIClient::close);
    }

    public static class PersonalPublicAPIKeyOnAllNodes {
        public final String user;
        public String secret;
        public String error;
        public boolean createdOnAllNodes = false;
        public List<NodeInfoAndKey> nodesAndKeys = new ArrayList<NodeInfoAndKey>();
        public List<NonExistingUserOnNodeInfo> nodesWhereUserDoesNotExist = new ArrayList<NonExistingUserOnNodeInfo>();
        public List<DisabledUserOnNodeInfo> nodesWhereUserIsDisabled = new ArrayList<DisabledUserOnNodeInfo>();

        public PersonalPublicAPIKeyOnAllNodes(AuthCtx requestingUser, @Nullable String forUser) {
            this.user = StringUtils.isNotBlank((String)forUser) ? forUser : requestingUser.getIdentifier();
        }

        public void addNodeAndKeyId(String automationNodeId, String url, String keyId) {
            NodeInfoAndKey nodeInfoAndKey = new NodeInfoAndKey();
            nodeInfoAndKey.automationNodeId = automationNodeId;
            nodeInfoAndKey.url = url;
            nodeInfoAndKey.keyId = keyId;
            this.nodesAndKeys.add(nodeInfoAndKey);
        }

        public static class NodeInfoAndKey {
            String automationNodeId;
            String url;
            String keyId;
        }

        public static class DisabledUserOnNodeInfo {
            String id;
            String url;
        }

        public static class NonExistingUserOnNodeInfo {
            String id;
            String url;
            boolean provisioningAtLogin;
        }
    }
}

