/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.discussions;

import com.dataiku.dip.server.services.ITaggingService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class Discussion {
    public String id;
    public String projectKey;
    @Nullable
    public String workspaceKey;
    public String objectId;
    public ITaggingService.TaggableType objectType;
    @Nullable
    public String objectDisplayName;
    public String topic;
    public long lastReplyTime;
    public Map<String, User> users = new HashMap<String, User>();
    public long closedOn;
    public String closedBy;
    private List<DiscussionReply> replies = new ArrayList<DiscussionReply>();

    public Discussion() {
    }

    public Discussion(String id, String projectKey, @Nullable String workspaceKey, String objectId, ITaggingService.TaggableType objectType, String topic, long closedOn, String closedBy, long lastReplyTime) {
        this.id = id;
        this.projectKey = projectKey;
        this.workspaceKey = workspaceKey;
        this.objectId = objectId;
        this.objectType = objectType;
        this.topic = topic;
        this.closedOn = closedOn;
        this.closedBy = closedBy;
        this.lastReplyTime = lastReplyTime;
        if (closedOn > 0L && !StringUtils.isBlank((String)closedBy) && !this.users.containsKey(closedBy)) {
            User user = new User(closedBy, null, 0L, 0L);
            this.users.put(closedBy, user);
        }
    }

    public Discussion(String id, String projectKey, @Nullable String workspaceKey, String objectId, ITaggingService.TaggableType objectType, String topic) {
        this(id, projectKey, workspaceKey, objectId, objectType, topic, 0L, null, 0L);
    }

    public List<DiscussionReply> getReplies() {
        return this.replies;
    }

    public DiscussionReply getReply(String replyId) {
        if (replyId != null && this.replies != null) {
            for (DiscussionReply reply : this.replies) {
                if (!replyId.equals(reply.id)) continue;
                return reply;
            }
        }
        return null;
    }

    public void addReply(DiscussionReply reply) {
        this.replies.add(reply);
        String login = reply.author;
        if (this.users.containsKey(login)) {
            User user = this.users.get(login);
            if (reply.time > user.lastReplyTime) {
                user.lastReplyTime = reply.time;
            }
        } else {
            User user = new User(login, reply.authorDisplayName, reply.time, reply.time);
            this.users.put(login, user);
        }
    }

    public void resetRepliesUnsafe() {
        this.replies = null;
    }

    public void addLastReadTime(String login, long time) {
        if (this.users.containsKey(login)) {
            User user = this.users.get(login);
            if (time > user.lastReadTime) {
                user.lastReadTime = time;
            }
        } else {
            User user = new User(login, null, 0L, time);
            this.users.put(login, user);
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean hasRepliesFrom(String login) {
        for (DiscussionReply r : this.replies) {
            if (!login.equals(r.author)) continue;
            return true;
        }
        return false;
    }

    public void sortReplies() {
        Collections.sort(this.replies, new Comparator<DiscussionReply>(){

            @Override
            public int compare(DiscussionReply r1, DiscussionReply r2) {
                return Long.compare(r1.time, r2.time);
            }
        });
    }

    public static class User {
        public final String login;
        public String displayName;
        public long lastReplyTime;
        public long lastReadTime;

        public User(String login, String displayName, long lastReplyTime, long lastReadTime) {
            this.login = login;
            this.displayName = displayName;
            this.lastReplyTime = lastReplyTime;
            this.lastReadTime = lastReadTime;
        }
    }

    public static class DiscussionReply {
        public final String id;
        public final String text;
        public final String author;
        public final long time;
        public final long editedOn;
        public String authorDisplayName;

        public DiscussionReply(String id, String text, String author, long time, long editedOn) {
            this.id = id;
            this.text = text;
            this.author = author;
            this.time = time;
            this.editedOn = editedOn;
        }

        public DiscussionReply(String id, String text, String author) {
            this.id = id;
            this.text = text;
            this.author = author;
            this.time = 0L;
            this.editedOn = 0L;
        }

        public String getText() {
            return this.text;
        }

        public long getTime() {
            return this.time;
        }

        public String getAuthor() {
            return this.author;
        }
    }

    public static class DiscussionRef {
        public final String projectKey;
        public final ITaggingService.TaggableType objectType;
        public final String objectId;
        public final String discussionId;

        public DiscussionRef(String projectKey, ITaggingService.TaggableType objectType, String objectId, String discussionId) {
            this.projectKey = projectKey;
            this.objectType = objectType;
            this.objectId = objectId;
            this.discussionId = discussionId;
        }

        public DiscussionRef(Discussion c2) {
            this.projectKey = c2.projectKey;
            this.objectType = c2.objectType;
            this.objectId = c2.objectId;
            this.discussionId = c2.id;
        }
    }
}

