/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.docextraction.DocExtractionUtils;
import com.dataiku.dip.docextraction.PdfConverter;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.util.LibreOfficeUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PDFConverterService {
    private Boolean hasLibreOfficeBin = null;
    public static final long LIBREOFFICE_TIMEOUT_IN_MS = DKUApp.getParams().getLongParam("dku.docextraction.pdfconversion.libreOfficeProcessTimeoutSeconds", 1800L) * 1000L;
    public static final int MAX_LIBREOFFICE_INSTANCES = DKUApp.getParams().getIntParam("dku.docextraction.pdfconversion.maxLibreOfficeInstances", Integer.valueOf(1));
    public AtomicInteger currentLibreOfficeInstance = new AtomicInteger(0);
    public ConcurrentMap<Integer, ReentrantLock> locks = new ConcurrentHashMap<Integer, ReentrantLock>();
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.pdfConverter");

    public boolean isLibreOfficeInstalled() {
        if (this.hasLibreOfficeBin == null) {
            this.hasLibreOfficeBin = LibreOfficeUtil.hasLibreOfficeBin();
        }
        return this.hasLibreOfficeBin;
    }

    private int getLibreOfficeInstance() {
        return this.currentLibreOfficeInstance.getAndUpdate(i -> (i + 1) % MAX_LIBREOFFICE_INSTANCES) + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public PdfConverter.LibreOfficeExecutionResults convertFileToPDFWithLibreOffice(String inputFilePath, String outputDirPath, String originalFileName, AuthCtx authCtx, String projectKey) {
        if (!this.isLibreOfficeInstalled()) {
            String message = "LibreOffice must be installed in order to convert  files to PDFs. A Dataiku administrator needs to run the following command to install it: " + DKUApp.getInstallFile((String[])new String[]{"scripts", "install", "install-deps.sh"}).getAbsolutePath() + " -with-libreoffice";
            logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, message));
            return PdfConverter.LibreOfficeExecutionResults.fromError(new UnsupportedOperationException(message));
        }
        int libreOfficeInstance = this.getLibreOfficeInstance();
        ReentrantLock lock = this.locks.computeIfAbsent(libreOfficeInstance, k -> new ReentrantLock());
        lock.lock();
        try {
            DKUtils.ExecutionResults executionResults;
            String userProfileDirectoryPath = outputDirPath + "/instance_" + libreOfficeInstance;
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Using LibreOffice user profile in : " + userProfileDirectoryPath));
            ArrayList cmd = Lists.newArrayList();
            cmd.add("soffice");
            cmd.add("-env:UserInstallation=file://" + userProfileDirectoryPath);
            cmd.add("--headless");
            cmd.add("--convert-to");
            cmd.add("pdf");
            cmd.add(inputFilePath);
            cmd.add("--outdir");
            cmd.add(outputDirPath);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            try {
                executionResults = PDFConverterService.executeProcess(outputDirPath, authCtx, projectKey, libreOfficeInstance, pb);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Interrupted while waiting for LibreOffice execution results"), (Throwable)e);
                PdfConverter.LibreOfficeExecutionResults libreOfficeExecutionResults = PdfConverter.LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            catch (IOException e) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Failed to convert file to PDF using LibreOffice"), (Throwable)e);
                PdfConverter.LibreOfficeExecutionResults libreOfficeExecutionResults = PdfConverter.LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stdout: " + executionResults.out));
            if (StringUtils.isNotBlank((String)executionResults.err)) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stderr: " + executionResults.err));
            }
            String outputFileName = FilenameUtils.getBaseName((String)inputFilePath) + ".pdf";
            File convertedFile = new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName}));
            if (!convertedFile.exists()) {
                StringBuilder message = new StringBuilder();
                message.append("Conversion to pdf using LibreOffice was not successful, it did not fail but did not create the converted pdf for file: ").append(originalFileName);
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, message.toString()));
                message.append(". Libreoffice stout was: ").append(executionResults.out).append(", Libreoffice stderr was: ").append(executionResults.err);
                PdfConverter.LibreOfficeExecutionResults libreOfficeExecutionResults = PdfConverter.LibreOfficeExecutionResults.fromMissingOutputFile(executionResults, message.toString());
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Converted file to PDF: " + outputFileName));
            PdfConverter.LibreOfficeExecutionResults libreOfficeExecutionResults = PdfConverter.LibreOfficeExecutionResults.fromSuccess(new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName})), executionResults);
            return libreOfficeExecutionResults;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DKUtils.ExecutionResults executeProcess(String outputDirPath, AuthCtx authCtx, String projectKey, int libreOfficeInstance, ProcessBuilder pb) throws IOException, InterruptedException {
        DKUtils.ExecutionResults executionResults = new DKUtils.ExecutionResults();
        DKUtils.ByteCollectingSubscription outputCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ByteCollectingSubscription errorCollector = new DKUtils.ByteCollectingSubscription();
        DKUtils.ExecOutputConsumer outputConsumer = new DKUtils.ExecOutputConsumer().withThreadsBaseName("libreOffice-converter-" + libreOfficeInstance);
        outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)outputCollector);
        outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)errorCollector);
        RegularProcess rp = new RegularProcess(pb, new File(outputDirPath), GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, authCtx, projectKey);
        rp.start();
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook(() -> {
            try {
                rp.evilKillWholeTree();
            }
            catch (IOException e) {
                logger.error((Object)"Failed to stop LibreOffice conversion process", (Throwable)e);
            }
        });){
            outputConsumer.start(rp.getInputStream(), rp.getErrorStream(), rp.getOutputStream());
            int rv = rp.waitFor(LIBREOFFICE_TIMEOUT_IN_MS);
            logger.info((Object)("LibreOffice conversion process done with code " + rv));
            if (rv == -1) {
                logger.warn((Object)("LibreOffice conversion process has timed out after " + LIBREOFFICE_TIMEOUT_IN_MS / 1000L + " seconds"));
                rp.evilKillWholeTree();
                throw new InterruptedException("LibreOffice conversion process has timed out");
            }
            outputConsumer.finish();
            executionResults.rv = rv;
            executionResults.out = new String(outputCollector.getCollected(), StandardCharsets.UTF_8);
            executionResults.err = new String(errorCollector.getCollected(), StandardCharsets.UTF_8);
        }
        finally {
            outputCollector.close();
            errorCollector.close();
        }
        return executionResults;
    }
}

