/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.Page;
import com.dataiku.dip.docextraction.Screenshotter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PagesIterator
implements Iterator<Page> {
    IDocumentScreenshotsDrawer document;
    Screenshotter.ScreenshotterSettings settings;
    int pageCount;
    boolean hasNextPaginationResults;
    int currentIndex;
    int endIndex;

    public PagesIterator(IDocumentScreenshotsDrawer document, Screenshotter.ScreenshotterSettings settings) {
        this.document = document;
        this.settings = settings;
        this.pageCount = document.getPageCount();
        if (settings.paginationOffset >= this.pageCount) {
            throw new IllegalArgumentException("Cannot start extraction at offset: " + settings.paginationOffset + ", the document is only " + this.pageCount + " pages long");
        }
        if (settings.paginationOffset + settings.paginationSize < this.pageCount) {
            this.hasNextPaginationResults = true;
        }
        this.endIndex = Math.min(this.pageCount, settings.paginationOffset + settings.paginationSize) - 1;
        this.currentIndex = settings.paginationOffset;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex <= this.endIndex;
    }

    @Override
    public Page next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Page p = new Page(this.document, this.currentIndex);
        ++this.currentIndex;
        return p;
    }
}

