/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction.common.chunks;

import com.dataiku.dip.docextraction.Content;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.PathUtils;
import java.util.List;

public class TextFirstExtractionChunk {
    public String fullContent;
    public List<String> outline;
    public Content parentStructure;
    public Content.PageRange pageRange;
    public String caption;
    public InputRefs.SingleImageRef imageRef;

    private TextFirstExtractionChunk() {
    }

    public static TextFirstExtractionChunk build(String fullContent, List<String> outline, Content parentStructure, Content.PageRange pageRange) {
        TextFirstExtractionChunk textChunk = new TextFirstExtractionChunk();
        textChunk.fullContent = fullContent;
        textChunk.outline = outline;
        textChunk.parentStructure = parentStructure;
        textChunk.pageRange = pageRange;
        return textChunk;
    }

    public static TextFirstExtractionChunk buildForImage(String fullContent, List<String> outline, Content parentStructure, Content.PageRange pageRange, String caption, InputRefs.SingleImageRef imageRef) {
        TextFirstExtractionChunk captionedImageChunk = TextFirstExtractionChunk.build(fullContent, outline, parentStructure, pageRange);
        captionedImageChunk.caption = caption;
        captionedImageChunk.imageRef = imageRef;
        return captionedImageChunk;
    }

    public static String getImagesPrefixPathFromContent(Content content) {
        if (content == null || content.content == null) {
            return null;
        }
        for (Content child : content.content) {
            Content.Section section;
            String path;
            if (child instanceof Content.Image) {
                Content.Image img = (Content.Image)child;
                if (img.imageRef != null && (path = TextFirstExtractionChunk.getImagesPrefixPathFromImageRef(img.imageRef)) != null) {
                    return path;
                }
            }
            if (!(child instanceof Content.Section) || (path = TextFirstExtractionChunk.getImagesPrefixPathFromContent(section = (Content.Section)child)) == null) continue;
            return path;
        }
        return null;
    }

    public static String getImagesPrefixPathFromImageRef(InputRefs.SingleImageRef imageRef) {
        if (imageRef instanceof InputRefs.SingleManagedFolderImageRef) {
            InputRefs.SingleManagedFolderImageRef storedImg = (InputRefs.SingleManagedFolderImageRef)imageRef;
            return PathUtils.getParent((String)storedImg.path);
        }
        return null;
    }

    public String getImagesCommonPrefixPath() {
        if (this.imageRef != null) {
            return TextFirstExtractionChunk.getImagesPrefixPathFromImageRef(this.imageRef);
        }
        return TextFirstExtractionChunk.getImagesPrefixPathFromContent(this.parentStructure);
    }
}

