/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction.common.chunks;

import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocumentPageRange;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.List;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=PageChunk.class, type="page"), @Mapping(value=MultiPagesChunk.class, type="pages")})
public abstract class VlmExtractionChunk {
    public String promptOutput;
    public DocumentPageRange pageRange;
    public List<String> images;

    public static VlmExtractionChunk build(int windowSize, int pageStart, int pageEnd, @Nullable List<String> imagePaths) {
        VlmExtractionChunk chunk = windowSize == 1 ? new PageChunk() : new MultiPagesChunk();
        chunk.pageRange = new DocumentPageRange(pageStart, pageEnd);
        chunk.images = imagePaths;
        return chunk;
    }

    public static class PageChunk
    extends VlmExtractionChunk {
        protected static final String TYPE = "page";
    }

    public static class MultiPagesChunk
    extends VlmExtractionChunk {
        protected static final String TYPE = "pages";
    }
}

